/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.ext;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.core.ViewResourceCallback;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprOrderedExpr;
import com.espertech.esper.epl.named.RemoveStreamViewCapability;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewCapDataWindowAccess;
import com.espertech.esper.view.ViewCapability;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.ext.IStreamSortedRandomAccess;
import com.espertech.esper.view.ext.SortWindowView;
import com.espertech.esper.view.window.RandomAccessByIndexGetter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortWindowViewFactory
implements DataWindowViewFactory {
    private static final String NAME = "Sort view";
    private List<ExprNode> viewParameters;
    protected ExprNode[] sortCriteriaExpressions;
    protected boolean[] isDescendingValues;
    protected int sortWindowSize;
    protected RandomAccessByIndexGetter randomAccessGetterImpl;
    private EventType eventType;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> viewParams) throws ViewParameterException {
        this.viewParameters = viewParams;
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        this.eventType = parentEventType;
        String message = "Sort view requires a numeric size parameter and a list of expressions providing sort keys";
        if (this.viewParameters.size() < 2) {
            throw new ViewParameterException(message);
        }
        ExprNode[] validated = ViewFactorySupport.validate(NAME, parentEventType, statementContext, this.viewParameters, true);
        for (int i = 1; i < validated.length; ++i) {
            ViewFactorySupport.assertReturnsNonConstant(NAME, validated[i], i);
        }
        Object sortSize = ViewFactorySupport.evaluateAssertNoProperties(NAME, validated[0], 0, statementContext);
        if (sortSize == null || !(sortSize instanceof Number)) {
            throw new ViewParameterException(message);
        }
        this.sortWindowSize = ((Number)sortSize).intValue();
        this.sortCriteriaExpressions = new ExprNode[validated.length - 1];
        this.isDescendingValues = new boolean[this.sortCriteriaExpressions.length];
        for (int i = 1; i < validated.length; ++i) {
            if (validated[i] instanceof ExprOrderedExpr) {
                this.isDescendingValues[i - 1] = ((ExprOrderedExpr)validated[i]).isDescending();
                this.sortCriteriaExpressions[i - 1] = validated[i].getChildNodes().get(0);
                continue;
            }
            this.sortCriteriaExpressions[i - 1] = validated[i];
        }
    }

    @Override
    public boolean canProvideCapability(ViewCapability viewCapability) {
        if (viewCapability instanceof RemoveStreamViewCapability) {
            return true;
        }
        return viewCapability instanceof ViewCapDataWindowAccess;
    }

    @Override
    public void setProvideCapability(ViewCapability viewCapability, ViewResourceCallback resourceCallback) {
        if (!this.canProvideCapability(viewCapability)) {
            throw new UnsupportedOperationException("View capability " + viewCapability.getClass().getSimpleName() + " not supported");
        }
        if (viewCapability instanceof RemoveStreamViewCapability) {
            return;
        }
        if (this.randomAccessGetterImpl == null) {
            this.randomAccessGetterImpl = new RandomAccessByIndexGetter();
        }
        resourceCallback.setViewResource(this.randomAccessGetterImpl);
    }

    @Override
    public View makeView(StatementContext statementContext) {
        IStreamSortedRandomAccess sortedRandomAccess = null;
        if (this.randomAccessGetterImpl != null) {
            sortedRandomAccess = new IStreamSortedRandomAccess(this.randomAccessGetterImpl);
            this.randomAccessGetterImpl.updated(sortedRandomAccess);
        }
        boolean useCollatorSort = false;
        if (statementContext.getConfigSnapshot() != null) {
            useCollatorSort = statementContext.getConfigSnapshot().getEngineDefaults().getLanguage().isSortUsingCollator();
        }
        return new SortWindowView(this, this.sortCriteriaExpressions, this.isDescendingValues, this.sortWindowSize, sortedRandomAccess, useCollatorSort, statementContext);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (this.randomAccessGetterImpl != null) {
            return false;
        }
        if (!(view instanceof SortWindowView)) {
            return false;
        }
        SortWindowView other = (SortWindowView)view;
        if (other.getSortWindowSize() != this.sortWindowSize || !this.compare(other.getIsDescendingValues(), this.isDescendingValues) || !ExprNodeUtility.deepEquals(other.getSortCriteriaExpressions(), this.sortCriteriaExpressions)) {
            return false;
        }
        return other.isEmpty();
    }

    private boolean compare(boolean[] one, boolean[] two) {
        if (one.length != two.length) {
            return false;
        }
        for (int i = 0; i < one.length; ++i) {
            if (one[i] == two[i]) continue;
            return false;
        }
        return true;
    }
}

