/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.internal;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.internal.IntersectViewFactory;
import com.espertech.esper.view.internal.LastPostObserver;
import com.espertech.esper.view.internal.LastPostObserverView;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntersectView
extends ViewSupport
implements LastPostObserver,
CloneableView {
    private static final Log log = LogFactory.getLog(IntersectView.class);
    private final IntersectViewFactory intersectViewFactory;
    private final EventType eventType;
    private final View[] views;
    private final EventBean[][] oldEventsPerView;
    private final Set<EventBean> removalEvents = new HashSet<EventBean>();
    private boolean isHasRemovestreamData;
    private boolean isRetainObserverEvents;
    private boolean isDiscardObserverEvents;

    public IntersectView(IntersectViewFactory factory, EventType eventType, List<View> viewList) {
        this.intersectViewFactory = factory;
        this.eventType = eventType;
        this.views = viewList.toArray(new View[viewList.size()]);
        this.oldEventsPerView = new EventBean[viewList.size()][];
        for (int i = 0; i < viewList.size(); ++i) {
            LastPostObserverView view = new LastPostObserverView(i);
            this.views[i].removeAllViews();
            this.views[i].addView(view);
            view.setObserver(this);
        }
    }

    @Override
    public View cloneView(StatementContext statementContext) {
        return this.intersectViewFactory.makeView(statementContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (newData != null && oldData != null) {
            log.error("Intersection view received both insert and remove stream");
        }
        if (newData != null) {
            this.isHasRemovestreamData = false;
            this.isRetainObserverEvents = true;
            try {
                for (View view : this.views) {
                    view.update(newData, oldData);
                }
            }
            finally {
                this.isRetainObserverEvents = false;
            }
            if (this.isHasRemovestreamData) {
                this.removalEvents.clear();
                for (int i = 0; i < this.oldEventsPerView.length; ++i) {
                    if (this.oldEventsPerView[i] == null) continue;
                    EventBean[] viewOldData = this.oldEventsPerView[i];
                    this.oldEventsPerView[i] = null;
                    this.removalEvents.addAll(Arrays.asList(viewOldData));
                    this.isDiscardObserverEvents = true;
                    try {
                        for (int j = 0; j < this.views.length; ++j) {
                            if (i == j) continue;
                            this.views[j].update(null, viewOldData);
                        }
                        continue;
                    }
                    finally {
                        this.isDiscardObserverEvents = false;
                    }
                }
                oldData = this.removalEvents.toArray(new EventBean[this.removalEvents.size()]);
            }
            this.updateChildren(newData, oldData);
        } else if (oldData != null) {
            this.isDiscardObserverEvents = true;
            try {
                for (View view : this.views) {
                    view.update(null, oldData);
                }
            }
            finally {
                this.isDiscardObserverEvents = false;
            }
            this.updateChildren(null, oldData);
        }
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        return this.views[0].iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newData(int streamId, EventBean[] newEvents, EventBean[] oldEvents) {
        if (oldEvents == null || this.isDiscardObserverEvents) {
            return;
        }
        if (this.isRetainObserverEvents) {
            this.oldEventsPerView[streamId] = oldEvents;
            this.isHasRemovestreamData = true;
            return;
        }
        this.isDiscardObserverEvents = true;
        try {
            for (int i = 0; i < this.views.length; ++i) {
                if (i == streamId) continue;
                this.views[i].update(null, oldEvents);
            }
        }
        finally {
            this.isDiscardObserverEvents = false;
        }
        this.updateChildren(null, oldEvents);
    }
}

