/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.internal;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.core.ViewResourceCallback;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewCapPriorEventAccess;
import com.espertech.esper.view.ViewCapability;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.internal.PriorEventBufferMulti;
import com.espertech.esper.view.internal.PriorEventBufferSingle;
import com.espertech.esper.view.internal.PriorEventBufferUnbound;
import com.espertech.esper.view.internal.PriorEventView;
import com.espertech.esper.view.window.RelativeAccessByEventNIndex;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorEventViewFactory
implements ViewFactory {
    protected TreeMap<Integer, List<ViewResourceCallback>> callbacksPerIndex = new TreeMap();
    private EventType eventType;
    protected boolean isUnbound;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        List<Object> viewParameters = ViewFactorySupport.validateAndEvaluate("Prior event view", viewFactoryContext.getStatementContext(), expressionParameters);
        if (viewParameters.size() != 1) {
            throw new ViewParameterException("View requires a single parameter indicating unbound or not");
        }
        this.isUnbound = (Boolean)viewParameters.get(0);
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        this.eventType = parentEventType;
    }

    @Override
    public boolean canProvideCapability(ViewCapability viewCapability) {
        return viewCapability instanceof ViewCapPriorEventAccess;
    }

    @Override
    public void setProvideCapability(ViewCapability viewCapability, ViewResourceCallback resourceCallback) {
        if (!this.canProvideCapability(viewCapability)) {
            throw new UnsupportedOperationException("View capability " + viewCapability.getClass().getSimpleName() + " not supported");
        }
        ViewCapPriorEventAccess requested = (ViewCapPriorEventAccess)viewCapability;
        int reqIndex = requested.getIndexConstant();
        List<ViewResourceCallback> callbackList = this.callbacksPerIndex.get(reqIndex);
        if (callbackList == null) {
            callbackList = new LinkedList<ViewResourceCallback>();
            this.callbacksPerIndex.put(reqIndex, callbackList);
        }
        callbackList.add(resourceCallback);
    }

    @Override
    public View makeView(StatementContext statementContext) {
        if (this.callbacksPerIndex.isEmpty()) {
            throw new IllegalStateException("No resources requested");
        }
        int[] requested = new int[this.callbacksPerIndex.size()];
        int count = 0;
        for (int reqIndex : this.callbacksPerIndex.keySet()) {
            requested[count++] = reqIndex;
        }
        Object viewUpdatedCollection = this.isUnbound ? new PriorEventBufferUnbound(this.callbacksPerIndex.lastKey()) : (requested.length == 1 ? new PriorEventBufferSingle(requested[0]) : new PriorEventBufferMulti(requested));
        int relativeIndex = 0;
        for (int reqIndex : this.callbacksPerIndex.keySet()) {
            List<ViewResourceCallback> callbacks = this.callbacksPerIndex.get(reqIndex);
            for (ViewResourceCallback callback : callbacks) {
                if (viewUpdatedCollection instanceof RelativeAccessByEventNIndex) {
                    RelativeAccessByEventNIndex relativeAccess = (RelativeAccessByEventNIndex)viewUpdatedCollection;
                    callback.setViewResource(new RelativeAccessImpl(relativeAccess, relativeIndex));
                    continue;
                }
                callback.setViewResource(viewUpdatedCollection);
            }
            ++relativeIndex;
        }
        return new PriorEventView((ViewUpdatedCollection)viewUpdatedCollection);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        return false;
    }

    public static class RelativeAccessImpl
    implements RelativeAccessByEventNIndex {
        private final RelativeAccessByEventNIndex buffer;
        private final int relativeIndex;

        public RelativeAccessImpl(RelativeAccessByEventNIndex buffer, int relativeIndex) {
            this.buffer = buffer;
            this.relativeIndex = relativeIndex;
        }

        public EventBean getRelativeToEvent(EventBean event, int prevIndex) {
            return this.buffer.getRelativeToEvent(event, this.relativeIndex);
        }
    }
}

