/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.internal;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.NullIterator;
import com.espertech.esper.core.EPStatementHandle;
import com.espertech.esper.core.InternalEventRouter;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.internal.RouteResultViewHandler;
import com.espertech.esper.view.internal.RouteResultViewHandlerAll;
import com.espertech.esper.view.internal.RouteResultViewHandlerFirst;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteResultView
extends ViewSupport {
    private static final NullIterator nullIterator = new NullIterator();
    private final EventType eventType;
    private RouteResultViewHandler handler;
    private ExprEvaluatorContext exprEvaluatorContext;

    public RouteResultView(boolean isFirst, EventType eventType, EPStatementHandle epStatementHandle, InternalEventRouter internalEventRouter, ResultSetProcessor[] processors, ExprNode[] whereClauses, StatementContext statementContext) {
        if (whereClauses.length != processors.length) {
            throw new IllegalArgumentException("Number of where-clauses and processors does not match");
        }
        this.exprEvaluatorContext = statementContext;
        this.eventType = eventType;
        this.handler = isFirst ? new RouteResultViewHandlerFirst(epStatementHandle, internalEventRouter, processors, whereClauses, statementContext) : new RouteResultViewHandlerAll(epStatementHandle, internalEventRouter, processors, whereClauses, statementContext);
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (newData == null) {
            return;
        }
        for (EventBean bean : newData) {
            boolean isHandled = this.handler.handle(bean, this.exprEvaluatorContext);
            if (isHandled) continue;
            this.updateChildren(new EventBean[]{bean}, null);
        }
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        return nullIterator;
    }
}

