/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.stat;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.SingleEventIterator;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.stat.BaseStatisticsBean;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseBivariateStatisticsView
extends ViewSupport {
    protected BaseStatisticsBean statisticsBean;
    private ExprNode expressionX;
    private ExprNode expressionY;
    private EventBean[] eventsPerStream = new EventBean[1];
    protected StatementContext statementContext;
    private EventBean lastNewEvent;

    public BaseBivariateStatisticsView(StatementContext statementContext, BaseStatisticsBean statisticsBean, ExprNode expressionX, ExprNode expressionY) {
        this.statementContext = statementContext;
        this.statisticsBean = statisticsBean;
        this.expressionX = expressionX;
        this.expressionY = expressionY;
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        double Y;
        double X;
        int i;
        BaseStatisticsBean oldValues = null;
        if (this.lastNewEvent == null && this.hasViews()) {
            oldValues = (BaseStatisticsBean)this.statisticsBean.clone();
        }
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                this.eventsPerStream[0] = newData[i];
                X = ((Number)this.expressionX.evaluate(this.eventsPerStream, true, this.statementContext)).doubleValue();
                Y = ((Number)this.expressionY.evaluate(this.eventsPerStream, true, this.statementContext)).doubleValue();
                this.statisticsBean.addPoint(X, Y);
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                this.eventsPerStream[0] = oldData[i];
                X = ((Number)this.expressionX.evaluate(this.eventsPerStream, true, this.statementContext)).doubleValue();
                Y = ((Number)this.expressionY.evaluate(this.eventsPerStream, true, this.statementContext)).doubleValue();
                this.statisticsBean.removePoint(X, Y);
            }
        }
        if (this.hasViews()) {
            if (this.lastNewEvent == null) {
                BaseStatisticsBean newValues = (BaseStatisticsBean)this.statisticsBean.clone();
                EventBean newValuesEvent = this.statementContext.getEventAdapterService().adapterForBean(newValues);
                EventBean oldValuesEvent = this.statementContext.getEventAdapterService().adapterForBean(oldValues);
                this.updateChildren(new EventBean[]{newValuesEvent}, new EventBean[]{oldValuesEvent});
                this.lastNewEvent = newValuesEvent;
            } else {
                BaseStatisticsBean newValues = (BaseStatisticsBean)this.statisticsBean.clone();
                EventBean newValuesEvent = this.statementContext.getEventAdapterService().adapterForBean(newValues);
                this.updateChildren(new EventBean[]{newValuesEvent}, new EventBean[]{this.lastNewEvent});
                this.lastNewEvent = newValuesEvent;
            }
        }
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return new SingleEventIterator(this.statementContext.getEventAdapterService().adapterForBean(this.statisticsBean));
    }

    public final ExprNode getExpressionX() {
        return this.expressionX;
    }

    public final ExprNode getExpressionY() {
        return this.expressionY;
    }
}

