/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.stat;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.SingleEventIterator;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFieldEnum;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.stat.BaseStatisticsBean;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnivariateStatisticsView
extends ViewSupport
implements CloneableView {
    private final StatementContext statementContext;
    private final EventType eventType;
    private final ExprNode fieldExpression;
    private final BaseStatisticsBean baseStatisticsBean = new BaseStatisticsBean();
    private EventBean lastNewEvent;
    private EventBean[] eventsPerStream = new EventBean[1];

    public UnivariateStatisticsView(StatementContext statementContext, ExprNode fieldExpression) {
        this.statementContext = statementContext;
        this.fieldExpression = fieldExpression;
        this.eventType = UnivariateStatisticsView.createEventType(statementContext);
    }

    @Override
    public View cloneView(StatementContext statementContext) {
        return new UnivariateStatisticsView(statementContext, this.fieldExpression);
    }

    public final ExprNode getFieldExpression() {
        return this.fieldExpression;
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        double point;
        int i;
        EventBean oldDataMap = null;
        if (this.lastNewEvent == null && this.hasViews()) {
            oldDataMap = UnivariateStatisticsView.populateMap(this.baseStatisticsBean, this.statementContext.getEventAdapterService(), this.eventType);
        }
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                this.eventsPerStream[0] = newData[i];
                point = ((Number)this.fieldExpression.evaluate(this.eventsPerStream, true, this.statementContext)).doubleValue();
                this.baseStatisticsBean.addPoint(point, 0.0);
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                this.eventsPerStream[0] = oldData[i];
                point = ((Number)this.fieldExpression.evaluate(this.eventsPerStream, true, this.statementContext)).doubleValue();
                this.baseStatisticsBean.removePoint(point, 0.0);
            }
        }
        if (this.hasViews()) {
            EventBean newDataMap = UnivariateStatisticsView.populateMap(this.baseStatisticsBean, this.statementContext.getEventAdapterService(), this.eventType);
            if (this.lastNewEvent == null) {
                this.updateChildren(new EventBean[]{newDataMap}, new EventBean[]{oldDataMap});
            } else {
                this.updateChildren(new EventBean[]{newDataMap}, new EventBean[]{this.lastNewEvent});
            }
            this.lastNewEvent = newDataMap;
        }
    }

    @Override
    public final EventType getEventType() {
        return this.eventType;
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return new SingleEventIterator(UnivariateStatisticsView.populateMap(this.baseStatisticsBean, this.statementContext.getEventAdapterService(), this.eventType));
    }

    public final String toString() {
        return this.getClass().getName() + " fieldExpression=" + this.fieldExpression;
    }

    private static EventBean populateMap(BaseStatisticsBean baseStatisticsBean, EventAdapterService eventAdapterService, EventType eventType) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(ViewFieldEnum.UNIVARIATE_STATISTICS__DATAPOINTS.getName(), baseStatisticsBean.getN());
        result.put(ViewFieldEnum.UNIVARIATE_STATISTICS__TOTAL.getName(), baseStatisticsBean.getXSum());
        result.put(ViewFieldEnum.UNIVARIATE_STATISTICS__STDDEV.getName(), baseStatisticsBean.getXStandardDeviationSample());
        result.put(ViewFieldEnum.UNIVARIATE_STATISTICS__STDDEVPA.getName(), baseStatisticsBean.getXStandardDeviationPop());
        result.put(ViewFieldEnum.UNIVARIATE_STATISTICS__VARIANCE.getName(), baseStatisticsBean.getXVariance());
        result.put(ViewFieldEnum.UNIVARIATE_STATISTICS__AVERAGE.getName(), baseStatisticsBean.getXAverage());
        return eventAdapterService.adaptorForTypedMap(result, eventType);
    }

    protected static EventType createEventType(StatementContext statementContext) {
        HashMap<String, Object> eventTypeMap = new HashMap<String, Object>();
        eventTypeMap.put(ViewFieldEnum.UNIVARIATE_STATISTICS__DATAPOINTS.getName(), Long.TYPE);
        eventTypeMap.put(ViewFieldEnum.UNIVARIATE_STATISTICS__TOTAL.getName(), Double.TYPE);
        eventTypeMap.put(ViewFieldEnum.UNIVARIATE_STATISTICS__STDDEV.getName(), Double.TYPE);
        eventTypeMap.put(ViewFieldEnum.UNIVARIATE_STATISTICS__STDDEVPA.getName(), Double.TYPE);
        eventTypeMap.put(ViewFieldEnum.UNIVARIATE_STATISTICS__VARIANCE.getName(), Double.TYPE);
        eventTypeMap.put(ViewFieldEnum.UNIVARIATE_STATISTICS__AVERAGE.getName(), Double.TYPE);
        return statementContext.getEventAdapterService().createAnonymousMapType(eventTypeMap);
    }
}

