/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.stat;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.core.ViewResourceCallback;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewCapability;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.stat.WeightedAverageView;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightedAverageViewFactory
implements ViewFactory {
    private List<ExprNode> viewParameters;
    protected ExprNode fieldNameX;
    protected ExprNode fieldNameWeight;
    private EventType eventType;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        this.viewParameters = expressionParameters;
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        ExprNode[] validated = ViewFactorySupport.validate("Weighted average view", parentEventType, statementContext, this.viewParameters, false);
        String errorMessage = "Weighted average view requires two expressions returning numeric values as parameters";
        if (this.viewParameters.size() != 2) {
            throw new ViewParameterException(errorMessage);
        }
        if (!JavaClassHelper.isNumeric(validated[0].getType()) || !JavaClassHelper.isNumeric(validated[1].getType())) {
            throw new ViewParameterException(errorMessage);
        }
        this.fieldNameX = validated[0];
        this.fieldNameWeight = validated[1];
        this.eventType = WeightedAverageView.createEventType(statementContext);
    }

    @Override
    public boolean canProvideCapability(ViewCapability viewCapability) {
        return false;
    }

    @Override
    public void setProvideCapability(ViewCapability viewCapability, ViewResourceCallback resourceCallback) {
        throw new UnsupportedOperationException("View capability " + viewCapability.getClass().getSimpleName() + " not supported");
    }

    @Override
    public View makeView(StatementContext statementContext) {
        return new WeightedAverageView(statementContext, this.fieldNameX, this.fieldNameWeight);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (!(view instanceof WeightedAverageView)) {
            return false;
        }
        WeightedAverageView myView = (WeightedAverageView)view;
        return ExprNodeUtility.deepEquals(this.fieldNameWeight, myView.getFieldNameWeight()) && ExprNodeUtility.deepEquals(this.fieldNameX, myView.getFieldNameX());
    }
}

