/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.std;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.std.AddPropertyValueView;
import com.espertech.esper.view.std.MergeView;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GroupByView
extends ViewSupport
implements CloneableView {
    private final ExprNode[] criteriaExpressions;
    private final StatementContext statementContext;
    private EventBean[] eventsPerStream = new EventBean[1];
    private String[] propertyNames;
    private final Map<MultiKey<Object>, List<View>> subViewsPerKey = new HashMap<MultiKey<Object>, List<View>>();
    private final HashMap<List<View>, Pair<List<EventBean>, List<EventBean>>> groupedEvents = new HashMap();
    private static final Log log = LogFactory.getLog(GroupByView.class);

    public GroupByView(StatementContext statementContext, ExprNode[] criteriaExpressions) {
        this.statementContext = statementContext;
        this.criteriaExpressions = criteriaExpressions;
        this.propertyNames = new String[criteriaExpressions.length];
        for (int i = 0; i < criteriaExpressions.length; ++i) {
            this.propertyNames[i] = criteriaExpressions[i].toExpressionString();
        }
    }

    @Override
    public View cloneView(StatementContext statementContext) {
        return new GroupByView(statementContext, this.criteriaExpressions);
    }

    public ExprNode[] getCriteriaExpressions() {
        return this.criteriaExpressions;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Updating view");
            GroupByView.dumpUpdateParams("GroupByView", newData, oldData);
        }
        if (newData != null && oldData == null && newData.length == 1) {
            EventBean event = newData[0];
            EventBean[] newDataToPost = new EventBean[]{event};
            Object[] groupByValues = new Object[this.criteriaExpressions.length];
            this.eventsPerStream[0] = event;
            for (int i = 0; i < this.criteriaExpressions.length; ++i) {
                groupByValues[i] = this.criteriaExpressions[i].evaluate(this.eventsPerStream, true, this.statementContext);
            }
            MultiKey<Object> groupByValuesKey = new MultiKey<Object>(groupByValues);
            List<View> subViews = this.subViewsPerKey.get(groupByValuesKey);
            if (subViews == null) {
                subViews = GroupByView.makeSubViews(this, this.propertyNames, groupByValuesKey.getArray(), this.statementContext);
                this.subViewsPerKey.put(groupByValuesKey, subViews);
            }
            ViewSupport.updateChildren(subViews, newDataToPost, null);
        } else {
            if (newData != null) {
                for (EventBean newValue : newData) {
                    this.handleEvent(newValue, true);
                }
            }
            if (oldData != null) {
                for (EventBean oldValue : oldData) {
                    this.handleEvent(oldValue, false);
                }
            }
            for (Map.Entry<List<View>, Pair<List<EventBean>, List<EventBean>>> entry : this.groupedEvents.entrySet()) {
                EventBean[] newEvents = EventBeanUtility.toArray(entry.getValue().getFirst());
                EventBean[] oldEvents = EventBeanUtility.toArray(entry.getValue().getSecond());
                ViewSupport.updateChildren(entry.getKey(), newEvents, oldEvents);
            }
            this.groupedEvents.clear();
        }
    }

    private void handleEvent(EventBean event, boolean isNew) {
        Pair<List<EventBean>, List<EventBean>> pair;
        Object[] groupByValues = new Object[this.criteriaExpressions.length];
        this.eventsPerStream[0] = event;
        for (int i = 0; i < this.criteriaExpressions.length; ++i) {
            groupByValues[i] = this.criteriaExpressions[i].evaluate(this.eventsPerStream, true, this.statementContext);
        }
        MultiKey<Object> groupByValuesKey = new MultiKey<Object>(groupByValues);
        List<View> subViews = this.subViewsPerKey.get(groupByValuesKey);
        if (subViews == null) {
            subViews = GroupByView.makeSubViews(this, this.propertyNames, groupByValuesKey.getArray(), this.statementContext);
            this.subViewsPerKey.put(groupByValuesKey, subViews);
        }
        if ((pair = this.groupedEvents.get(subViews)) == null) {
            LinkedList listNew = new LinkedList();
            LinkedList listOld = new LinkedList();
            pair = new Pair(listNew, listOld);
            this.groupedEvents.put(subViews, pair);
        }
        if (isNew) {
            pair.getFirst().add(event);
        } else {
            pair.getSecond().add(event);
        }
    }

    @Override
    public final Iterator<EventBean> iterator() {
        throw new UnsupportedOperationException("Cannot iterate over group view, this operation is not supported");
    }

    public final String toString() {
        return this.getClass().getName() + " groupFieldNames=" + Arrays.toString(this.criteriaExpressions);
    }

    protected static List<View> makeSubViews(GroupByView groupView, String[] propertyNames, Object[] groupByValues, StatementContext statementContext) {
        if (!groupView.hasViews()) {
            String message = "Unexpected empty list of child nodes for group view";
            log.fatal(".copySubViews " + message);
            throw new EPException(message);
        }
        LinkedList<View> subViewList = new LinkedList<View>();
        for (View originalChildView : groupView.getViews()) {
            if (originalChildView instanceof MergeView) {
                String message = "Unexpected merge view as child of group-by view";
                log.fatal(".copySubViews " + message);
                throw new EPException(message);
            }
            if (!(originalChildView instanceof CloneableView)) {
                throw new EPException("Unexpected error copying subview " + originalChildView.getClass().getName());
            }
            CloneableView cloneableView = (CloneableView)((Object)originalChildView);
            View copyChildView = cloneableView.cloneView(statementContext);
            copyChildView.setParent(groupView);
            subViewList.add(copyChildView);
            GroupByView.copySubViews(groupView.criteriaExpressions, propertyNames, groupByValues, originalChildView, copyChildView, statementContext);
        }
        return subViewList;
    }

    private static void copySubViews(ExprNode[] criteriaExpressions, String[] propertyNames, Object[] groupByValues, View originalView, View copyView, StatementContext statementContext) {
        for (View subView : originalView.getViews()) {
            MergeView mergeView;
            if (subView instanceof MergeView && ExprNodeUtility.deepEquals((mergeView = (MergeView)subView).getGroupFieldNames(), criteriaExpressions)) {
                AddPropertyValueView mergeDataView = new AddPropertyValueView(statementContext, propertyNames, groupByValues, mergeView.getEventType());
                copyView.addView(mergeDataView);
                mergeDataView.addView(mergeView);
                mergeView.addParentView(mergeDataView);
                continue;
            }
            if (!(subView instanceof CloneableView)) {
                throw new EPException("Unexpected error copying subview");
            }
            CloneableView cloneableView = (CloneableView)((Object)subView);
            View copiedChild = cloneableView.cloneView(statementContext);
            copyView.addView(copiedChild);
            GroupByView.copySubViews(criteriaExpressions, propertyNames, groupByValues, subView, copiedChild, statementContext);
        }
    }
}

