/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.std;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.core.ViewResourceCallback;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewCapability;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.std.GroupByView;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupByViewFactory
implements ViewFactory {
    protected List<ExprNode> viewParameters;
    protected ExprNode[] criteriaExpressions;
    private EventType eventType;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        this.viewParameters = expressionParameters;
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        this.criteriaExpressions = ViewFactorySupport.validate("Group-by view", parentEventType, statementContext, this.viewParameters, false);
        if (this.criteriaExpressions.length == 0) {
            String errorMessage = "Unique-by view requires a one or more expressions provinding unique values as parameters";
            throw new ViewParameterException(errorMessage);
        }
        this.eventType = parentEventType;
    }

    public ExprNode[] getCriteriaExpressions() {
        return this.criteriaExpressions;
    }

    @Override
    public boolean canProvideCapability(ViewCapability viewCapability) {
        return false;
    }

    @Override
    public void setProvideCapability(ViewCapability viewCapability, ViewResourceCallback resourceCallback) {
        throw new UnsupportedOperationException("View capability " + viewCapability.getClass().getSimpleName() + " not supported");
    }

    @Override
    public View makeView(StatementContext statementContext) {
        return new GroupByView(statementContext, this.criteriaExpressions);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    protected static String[] getFieldNameParams(List<Object> viewParameters, String viewName) throws ViewParameterException {
        String[] fieldNames;
        String errorMessage = '\'' + viewName + "' view requires a list of String values or a String-array as parameter";
        if (viewParameters.isEmpty()) {
            throw new ViewParameterException(errorMessage);
        }
        if (viewParameters.size() > 1) {
            ArrayList<String> fields = new ArrayList<String>();
            for (Object param : viewParameters) {
                if (!(param instanceof String)) {
                    throw new ViewParameterException(errorMessage);
                }
                fields.add((String)param);
            }
            fieldNames = fields.toArray(new String[fields.size()]);
        } else {
            Object param = viewParameters.get(0);
            if (param instanceof String[]) {
                String[] arr = (String[])param;
                if (arr.length == 0) {
                    throw new ViewParameterException(errorMessage);
                }
                fieldNames = arr;
            } else if (param instanceof String) {
                fieldNames = new String[]{(String)param};
            } else {
                throw new ViewParameterException(errorMessage);
            }
        }
        return fieldNames;
    }

    @Override
    public boolean canReuse(View view) {
        if (!(view instanceof GroupByView)) {
            return false;
        }
        GroupByView myView = (GroupByView)view;
        return ExprNodeUtility.deepEquals(myView.getCriteriaExpressions(), this.criteriaExpressions);
    }
}

