/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.std;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.core.ViewResourceCallback;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewCapability;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.std.GroupByViewFactory;
import com.espertech.esper.view.std.MergeView;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeViewFactory
implements ViewFactory {
    private List<ExprNode> viewParameters;
    private ExprNode[] criteriaExpressions;
    private EventType eventType;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        this.viewParameters = expressionParameters;
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        GroupByViewFactory groupByViewFactory = null;
        ExprNode[] unvalidated = this.viewParameters.toArray(new ExprNode[this.viewParameters.size()]);
        for (ViewFactory parentView : parentViewFactories) {
            GroupByViewFactory candidateGroupByView;
            if (!(parentView instanceof GroupByViewFactory) || !ExprNodeUtility.deepEquals((candidateGroupByView = (GroupByViewFactory)parentView).getCriteriaExpressions(), unvalidated)) continue;
            groupByViewFactory = candidateGroupByView;
        }
        if (groupByViewFactory == null) {
            throw new ViewParameterException("Group by view for this merge view could not be found among parent views");
        }
        this.criteriaExpressions = groupByViewFactory.getCriteriaExpressions();
        Class[] fieldTypes = new Class[this.criteriaExpressions.length];
        for (int i = 0; i < fieldTypes.length; ++i) {
            fieldTypes[i] = this.criteriaExpressions[i].getType();
        }
        boolean parentContainsMergeKeys = true;
        String[] fieldNames = new String[this.criteriaExpressions.length];
        for (int i = 0; i < this.criteriaExpressions.length; ++i) {
            String name;
            fieldNames[i] = name = this.criteriaExpressions[i].toExpressionString();
            if (parentEventType.isProperty(name)) continue;
            parentContainsMergeKeys = false;
        }
        if (parentContainsMergeKeys) {
            this.eventType = parentEventType;
        } else {
            HashMap<String, Object> additionalProps = new HashMap<String, Object>();
            for (int i = 0; i < fieldNames.length; ++i) {
                additionalProps.put(fieldNames[i], fieldTypes[i]);
            }
            this.eventType = statementContext.getEventAdapterService().createAnonymousWrapperType(parentEventType, additionalProps);
        }
    }

    @Override
    public boolean canProvideCapability(ViewCapability viewCapability) {
        return false;
    }

    @Override
    public void setProvideCapability(ViewCapability viewCapability, ViewResourceCallback resourceCallback) {
        throw new UnsupportedOperationException("View capability " + viewCapability.getClass().getSimpleName() + " not supported");
    }

    @Override
    public View makeView(StatementContext statementContext) {
        return new MergeView(statementContext, this.criteriaExpressions, this.eventType);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (!(view instanceof MergeView)) {
            return false;
        }
        MergeView myView = (MergeView)view;
        return ExprNodeUtility.deepEquals(myView.getGroupFieldNames(), this.criteriaExpressions);
    }
}

