/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.core.ViewResourceCallback;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.named.RemoveStreamViewCapability;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewCapability;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.window.FirstTimeView;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirstTimeViewFactory
implements DataWindowViewFactory {
    private EventType eventType;
    protected long millisecondsBeforeExpiry;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        List<Object> viewParameters = ViewFactorySupport.validateAndEvaluate("Time first view", viewFactoryContext.getStatementContext(), expressionParameters);
        String errorMessage = "Time first view requires a single numeric or time period parameter";
        if (viewParameters.size() != 1) {
            throw new ViewParameterException(errorMessage);
        }
        Object parameter = viewParameters.get(0);
        if (!(parameter instanceof Number)) {
            throw new ViewParameterException(errorMessage);
        }
        Number param = (Number)parameter;
        this.millisecondsBeforeExpiry = JavaClassHelper.isFloatingPointNumber(param) ? Math.round(1000.0 * param.doubleValue()) : 1000L * param.longValue();
        if (this.millisecondsBeforeExpiry < 1L) {
            throw new ViewParameterException("Time first view requires a size of at least 1 msec");
        }
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        this.eventType = parentEventType;
    }

    @Override
    public boolean canProvideCapability(ViewCapability viewCapability) {
        return viewCapability instanceof RemoveStreamViewCapability;
    }

    @Override
    public void setProvideCapability(ViewCapability viewCapability, ViewResourceCallback resourceCallback) {
        if (!this.canProvideCapability(viewCapability)) {
            throw new UnsupportedOperationException("View capability " + viewCapability.getClass().getSimpleName() + " not supported");
        }
    }

    @Override
    public View makeView(StatementContext statementContext) {
        return new FirstTimeView(this, statementContext, this.millisecondsBeforeExpiry);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (!(view instanceof FirstTimeView)) {
            return false;
        }
        FirstTimeView myView = (FirstTimeView)view;
        if (myView.getMsecIntervalSize() != this.millisecondsBeforeExpiry) {
            return false;
        }
        return myView.isEmpty();
    }
}

