/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.view.window.RandomAccessByIndex;
import com.espertech.esper.view.window.RandomAccessByIndexObserver;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IStreamRandomAccess
implements RandomAccessByIndex,
ViewUpdatedCollection {
    private ArrayList<EventBean> arrayList;
    private final RandomAccessByIndexObserver updateObserver;

    public IStreamRandomAccess(RandomAccessByIndexObserver updateObserver) {
        this.updateObserver = updateObserver;
        this.arrayList = new ArrayList();
    }

    public void setArrayList(ArrayList<EventBean> arrayList) {
        this.arrayList = arrayList;
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        int i;
        if (this.updateObserver != null) {
            this.updateObserver.updated(this);
        }
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                this.arrayList.add(0, newData[i]);
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                this.arrayList.remove(this.arrayList.size() - 1);
            }
        }
    }

    public void remove(EventBean oldData) {
        if (this.updateObserver != null) {
            this.updateObserver.updated(this);
        }
        this.arrayList.remove(this.arrayList.size() - 1);
    }

    public void update(EventBean newData) {
        if (this.updateObserver != null) {
            this.updateObserver.updated(this);
        }
        this.arrayList.add(0, newData);
    }

    @Override
    public EventBean getNewData(int index) {
        if (index < this.arrayList.size()) {
            return this.arrayList.get(index);
        }
        return null;
    }

    @Override
    public EventBean getOldData(int index) {
        return null;
    }

    @Override
    public void destroy() {
    }

    public boolean isEmpty() {
        return this.arrayList.isEmpty();
    }
}

