/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.core.ViewResourceCallback;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.named.RemoveStreamViewCapability;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewCapDataWindowAccess;
import com.espertech.esper.view.ViewCapability;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.window.IStreamRelativeAccess;
import com.espertech.esper.view.window.LengthBatchView;
import com.espertech.esper.view.window.LengthBatchViewRStream;
import com.espertech.esper.view.window.RelativeAccessByEventNIndexMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LengthBatchViewFactory
implements DataWindowViewFactory {
    protected int size;
    protected RelativeAccessByEventNIndexMap relativeAccessGetterImpl;
    protected boolean isRemoveStreamHandling;
    private EventType eventType;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        List<Object> viewParameters = ViewFactorySupport.validateAndEvaluate("Length window view", viewFactoryContext.getStatementContext(), expressionParameters);
        String errorMessage = "Length window view requires a single integer-type parameter";
        if (viewParameters.size() != 1) {
            throw new ViewParameterException(errorMessage);
        }
        Object parameter = viewParameters.get(0);
        if (!(parameter instanceof Number)) {
            throw new ViewParameterException(errorMessage);
        }
        Number numParam = (Number)parameter;
        if (JavaClassHelper.isFloatingPointNumber(numParam) || numParam instanceof Long) {
            throw new ViewParameterException(errorMessage);
        }
        this.size = numParam.intValue();
        if (this.size <= 0) {
            throw new ViewParameterException("Length window requires a positive number");
        }
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        this.eventType = parentEventType;
    }

    @Override
    public boolean canProvideCapability(ViewCapability viewCapability) {
        if (viewCapability instanceof RemoveStreamViewCapability) {
            return true;
        }
        return viewCapability instanceof ViewCapDataWindowAccess;
    }

    @Override
    public void setProvideCapability(ViewCapability viewCapability, ViewResourceCallback resourceCallback) {
        if (!this.canProvideCapability(viewCapability)) {
            throw new UnsupportedOperationException("View capability " + viewCapability.getClass().getSimpleName() + " not supported");
        }
        if (viewCapability instanceof RemoveStreamViewCapability) {
            this.isRemoveStreamHandling = true;
            return;
        }
        if (this.relativeAccessGetterImpl == null) {
            this.relativeAccessGetterImpl = new RelativeAccessByEventNIndexMap();
        }
        resourceCallback.setViewResource(this.relativeAccessGetterImpl);
    }

    @Override
    public View makeView(StatementContext statementContext) {
        IStreamRelativeAccess relativeAccessByEvent = null;
        if (this.relativeAccessGetterImpl != null) {
            relativeAccessByEvent = new IStreamRelativeAccess(this.relativeAccessGetterImpl);
            this.relativeAccessGetterImpl.updated(relativeAccessByEvent, null);
        }
        if (this.isRemoveStreamHandling) {
            return new LengthBatchViewRStream(this, this.size);
        }
        return new LengthBatchView(this, this.size, relativeAccessByEvent);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (this.relativeAccessGetterImpl != null) {
            return false;
        }
        if (!(view instanceof LengthBatchView)) {
            return false;
        }
        LengthBatchView myView = (LengthBatchView)view;
        if (myView.getSize() != this.size) {
            return false;
        }
        return myView.isEmpty();
    }
}

