/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.view.BatchingDataWindowView;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.window.LengthBatchViewFactory;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LengthBatchViewRStream
extends ViewSupport
implements CloneableView,
BatchingDataWindowView {
    private final LengthBatchViewFactory lengthBatchViewFactory;
    private final int size;
    private LinkedHashSet<EventBean> lastBatch = null;
    private LinkedHashSet<EventBean> currentBatch = new LinkedHashSet();
    private static final Log log = LogFactory.getLog(LengthBatchViewRStream.class);

    public LengthBatchViewRStream(LengthBatchViewFactory lengthBatchViewFactory, int size) {
        this.lengthBatchViewFactory = lengthBatchViewFactory;
        this.size = size;
        if (size <= 0) {
            throw new IllegalArgumentException("Invalid size parameter, size=" + size);
        }
    }

    @Override
    public View cloneView(StatementContext statementContext) {
        return this.lengthBatchViewFactory.makeView(statementContext);
    }

    public final int getSize() {
        return this.size;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Received update,   newData.length==" + (newData == null ? 0 : newData.length) + "  oldData.length==" + (oldData == null ? 0 : oldData.length));
        }
        if (oldData != null) {
            for (int i = 0; i < oldData.length; ++i) {
                this.currentBatch.remove(oldData[i]);
            }
        }
        if (newData == null || newData.length == 0) {
            return;
        }
        this.currentBatch.addAll(Arrays.asList(newData));
        if (this.currentBatch.size() < this.size) {
            return;
        }
        this.sendBatch();
    }

    protected final void sendBatch() {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".sendBatch Update child views");
        }
        if (this.hasViews()) {
            EventBean[] newData = null;
            EventBean[] oldData = null;
            if (!this.currentBatch.isEmpty()) {
                newData = this.currentBatch.toArray(new EventBean[this.currentBatch.size()]);
            }
            if (this.lastBatch != null && !this.lastBatch.isEmpty()) {
                oldData = this.lastBatch.toArray(new EventBean[this.lastBatch.size()]);
            }
            if (newData != null || oldData != null) {
                this.updateChildren(newData, oldData);
            }
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".sendBatch Published updated data, ....newData size=" + this.currentBatch.size());
            for (EventBean object : this.currentBatch) {
                log.debug(".sendBatch object=" + object);
            }
        }
        this.lastBatch = this.currentBatch;
        this.currentBatch = new LinkedHashSet();
    }

    public boolean isEmpty() {
        if (this.lastBatch != null && !this.lastBatch.isEmpty()) {
            return false;
        }
        return this.currentBatch.isEmpty();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.currentBatch.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " size=" + this.size;
    }
}

