/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.EPStatementHandleCallback;
import com.espertech.esper.core.ExtensionServicesContext;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.schedule.ScheduleHandle;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.window.TimeAccumViewFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TimeAccumView
extends ViewSupport
implements CloneableView,
DataWindowView {
    private final TimeAccumViewFactory factory;
    private final StatementContext statementContext;
    private final long msecIntervalSize;
    private final ViewUpdatedCollection viewUpdatedCollection;
    private final ScheduleSlot scheduleSlot;
    private ArrayList<EventBean> currentBatch = new ArrayList();
    private long callbackScheduledTime;
    private EPStatementHandleCallback handle;
    private static final Log log = LogFactory.getLog(TimeAccumView.class);

    public TimeAccumView(TimeAccumViewFactory timeBatchViewFactory, StatementContext statementContext, long msecIntervalSize, ViewUpdatedCollection viewUpdatedCollection) {
        this.statementContext = statementContext;
        this.factory = timeBatchViewFactory;
        this.msecIntervalSize = msecIntervalSize;
        this.viewUpdatedCollection = viewUpdatedCollection;
        this.scheduleSlot = statementContext.getScheduleBucket().allocateSlot();
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            public void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
                TimeAccumView.this.sendRemoveStream();
            }
        };
        this.handle = new EPStatementHandleCallback(statementContext.getEpStatementHandle(), callback);
    }

    @Override
    public View cloneView(StatementContext statementContext) {
        return this.factory.makeView(statementContext);
    }

    public final long getMsecIntervalSize() {
        return this.msecIntervalSize;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Received update,   newData.length==" + (newData == null ? 0 : newData.length) + "  oldData.length==" + (oldData == null ? 0 : oldData.length));
        }
        if (this.statementContext == null) {
            String message = "View context has not been supplied, cannot addSchedule callback";
            log.fatal(".update " + message);
            throw new EPException(message);
        }
        if (newData == null || newData.length == 0) {
            return;
        }
        boolean removeSchedule = false;
        boolean addSchedule = false;
        long timestamp = this.statementContext.getSchedulingService().getTime();
        if (!this.currentBatch.isEmpty()) {
            long callbackTime = timestamp + this.msecIntervalSize;
            if (callbackTime != this.callbackScheduledTime) {
                removeSchedule = true;
                addSchedule = true;
            }
        } else {
            addSchedule = true;
        }
        if (removeSchedule) {
            this.statementContext.getSchedulingService().remove(this.handle, this.scheduleSlot);
        }
        if (addSchedule) {
            this.statementContext.getSchedulingService().add(this.msecIntervalSize, (ScheduleHandle)this.handle, this.scheduleSlot);
            this.callbackScheduledTime = this.msecIntervalSize + timestamp;
        }
        this.currentBatch.addAll(Arrays.asList(newData));
        if (this.viewUpdatedCollection != null) {
            this.viewUpdatedCollection.update(newData, null);
        }
        if (this.hasViews()) {
            this.updateChildren(newData, null);
        }
    }

    protected final void sendRemoveStream() {
        this.callbackScheduledTime = -1L;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".sendRemoveStream Update child views,   time=" + this.statementContext.getSchedulingService().getTime());
        }
        if (this.hasViews()) {
            EventBean[] oldData = null;
            if (!this.currentBatch.isEmpty()) {
                oldData = this.currentBatch.toArray(new EventBean[this.currentBatch.size()]);
            }
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(null, oldData);
            }
            if (oldData != null) {
                this.updateChildren(null, oldData);
            }
        }
        this.currentBatch.clear();
    }

    public boolean isEmpty() {
        return this.currentBatch.isEmpty();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.currentBatch.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " msecIntervalSize=" + this.msecIntervalSize;
    }
}

