/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.core.ViewResourceCallback;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.named.RemoveStreamViewCapability;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewCapDataWindowAccess;
import com.espertech.esper.view.ViewCapability;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.window.IStreamRandomAccess;
import com.espertech.esper.view.window.RandomAccessByIndexGetter;
import com.espertech.esper.view.window.TimeAccumView;
import com.espertech.esper.view.window.TimeAccumViewRStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeAccumViewFactory
implements DataWindowViewFactory {
    private EventType eventType;
    protected long millisecondsQuietTime;
    protected RandomAccessByIndexGetter randomAccessGetterImpl;
    protected boolean isRemoveStreamHandling;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        List<Object> viewParameters = ViewFactorySupport.validateAndEvaluate("Time accumulative batch view", viewFactoryContext.getStatementContext(), expressionParameters);
        String errorMessage = "Time accumulative batch view requires a single numeric parameter or time period parameter";
        if (viewParameters.size() != 1) {
            throw new ViewParameterException(errorMessage);
        }
        Object parameter = viewParameters.get(0);
        if (!(parameter instanceof Number)) {
            throw new ViewParameterException(errorMessage);
        }
        Number param = (Number)parameter;
        this.millisecondsQuietTime = JavaClassHelper.isFloatingPointNumber(param) ? Math.round(1000.0 * param.doubleValue()) : 1000L * param.longValue();
        if (this.millisecondsQuietTime < 1L) {
            throw new ViewParameterException("Time accumulative batch view requires a size of at least 1 msec");
        }
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        this.eventType = parentEventType;
    }

    @Override
    public boolean canProvideCapability(ViewCapability viewCapability) {
        if (viewCapability instanceof RemoveStreamViewCapability) {
            return true;
        }
        return viewCapability instanceof ViewCapDataWindowAccess;
    }

    @Override
    public void setProvideCapability(ViewCapability viewCapability, ViewResourceCallback resourceCallback) {
        if (!this.canProvideCapability(viewCapability)) {
            throw new UnsupportedOperationException("View capability " + viewCapability.getClass().getSimpleName() + " not supported");
        }
        if (viewCapability instanceof RemoveStreamViewCapability) {
            this.isRemoveStreamHandling = true;
            return;
        }
        if (this.randomAccessGetterImpl == null) {
            this.randomAccessGetterImpl = new RandomAccessByIndexGetter();
        }
        resourceCallback.setViewResource(this.randomAccessGetterImpl);
    }

    @Override
    public View makeView(StatementContext statementContext) {
        IStreamRandomAccess randomAccess = null;
        if (this.randomAccessGetterImpl != null) {
            randomAccess = new IStreamRandomAccess(this.randomAccessGetterImpl);
            this.randomAccessGetterImpl.updated(randomAccess);
        }
        if (this.isRemoveStreamHandling) {
            return new TimeAccumViewRStream(this, statementContext, this.millisecondsQuietTime);
        }
        return new TimeAccumView(this, statementContext, this.millisecondsQuietTime, randomAccess);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (this.randomAccessGetterImpl != null) {
            return false;
        }
        if (!(view instanceof TimeAccumView)) {
            return false;
        }
        TimeAccumView myView = (TimeAccumView)view;
        if (myView.getMsecIntervalSize() != this.millisecondsQuietTime) {
            return false;
        }
        return myView.isEmpty();
    }
}

