/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.EPStatementHandleCallback;
import com.espertech.esper.core.ExtensionServicesContext;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.schedule.ScheduleHandle;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.window.TimeAccumViewFactory;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TimeAccumViewRStream
extends ViewSupport
implements CloneableView,
DataWindowView {
    private final TimeAccumViewFactory factory;
    private final StatementContext statementContext;
    private final long msecIntervalSize;
    private final ScheduleSlot scheduleSlot;
    private LinkedHashMap<EventBean, Long> currentBatch = new LinkedHashMap();
    private EventBean lastEvent;
    private long callbackScheduledTime;
    private EPStatementHandleCallback handle;
    private static final Log log = LogFactory.getLog(TimeAccumViewRStream.class);

    public TimeAccumViewRStream(TimeAccumViewFactory timeBatchViewFactory, StatementContext statementContext, long msecIntervalSize) {
        this.statementContext = statementContext;
        this.factory = timeBatchViewFactory;
        this.msecIntervalSize = msecIntervalSize;
        this.scheduleSlot = statementContext.getScheduleBucket().allocateSlot();
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            public void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
                TimeAccumViewRStream.this.sendRemoveStream();
            }
        };
        this.handle = new EPStatementHandleCallback(statementContext.getEpStatementHandle(), callback);
    }

    @Override
    public View cloneView(StatementContext statementContext) {
        return this.factory.makeView(statementContext);
    }

    public final long getMsecIntervalSize() {
        return this.msecIntervalSize;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Received update,   newData.length==" + (newData == null ? 0 : newData.length) + "  oldData.length==" + (oldData == null ? 0 : oldData.length));
        }
        if (this.statementContext == null) {
            String message = "View context has not been supplied, cannot addSchedule callback";
            log.fatal(".update " + message);
            throw new EPException(message);
        }
        if (newData != null && newData.length > 0) {
            boolean removeSchedule = false;
            boolean addSchedule = false;
            long timestamp = this.statementContext.getSchedulingService().getTime();
            if (!this.currentBatch.isEmpty()) {
                long callbackTime = timestamp + this.msecIntervalSize;
                if (callbackTime != this.callbackScheduledTime) {
                    removeSchedule = true;
                    addSchedule = true;
                }
            } else {
                addSchedule = true;
            }
            if (removeSchedule) {
                this.statementContext.getSchedulingService().remove(this.handle, this.scheduleSlot);
                this.callbackScheduledTime = -1L;
            }
            if (addSchedule) {
                this.statementContext.getSchedulingService().add(this.msecIntervalSize, (ScheduleHandle)this.handle, this.scheduleSlot);
                this.callbackScheduledTime = this.msecIntervalSize + timestamp;
            }
            for (int i = 0; i < newData.length; ++i) {
                this.currentBatch.put(newData[i], timestamp);
                this.lastEvent = newData[i];
            }
        }
        if (oldData != null && oldData.length > 0) {
            boolean removedLastEvent = false;
            for (EventBean anOldData : oldData) {
                this.currentBatch.remove(anOldData);
                if (anOldData != this.lastEvent) continue;
                removedLastEvent = true;
            }
            if (this.currentBatch.size() == 0) {
                this.statementContext.getSchedulingService().remove(this.handle, this.scheduleSlot);
                this.callbackScheduledTime = -1L;
                this.lastEvent = null;
            } else if (removedLastEvent) {
                Set<EventBean> keyset = this.currentBatch.keySet();
                EventBean[] events = keyset.toArray(new EventBean[keyset.size()]);
                this.lastEvent = events[events.length - 1];
                long lastTimestamp = this.currentBatch.get(this.lastEvent);
                long timestamp = this.statementContext.getSchedulingService().getTime();
                long callbackTime = lastTimestamp + this.msecIntervalSize;
                long deltaFromNow = callbackTime - timestamp;
                if (callbackTime != this.callbackScheduledTime) {
                    this.statementContext.getSchedulingService().remove(this.handle, this.scheduleSlot);
                    this.statementContext.getSchedulingService().add(deltaFromNow, (ScheduleHandle)this.handle, this.scheduleSlot);
                    this.callbackScheduledTime = callbackTime;
                }
            }
        }
        if (this.hasViews()) {
            this.updateChildren(newData, oldData);
        }
    }

    protected final void sendRemoveStream() {
        this.callbackScheduledTime = -1L;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".sendRemoveStream Update child views,   time=" + this.statementContext.getSchedulingService().getTime());
        }
        if (this.hasViews()) {
            EventBean[] oldData = null;
            if (!this.currentBatch.isEmpty()) {
                oldData = this.currentBatch.keySet().toArray(new EventBean[this.currentBatch.size()]);
            }
            if (oldData != null) {
                this.updateChildren(null, oldData);
            }
        }
        this.currentBatch.clear();
    }

    public boolean isEmpty() {
        return this.currentBatch.isEmpty();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.currentBatch.keySet().iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " msecIntervalSize=" + this.msecIntervalSize;
    }
}

