/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.EPStatementHandleCallback;
import com.espertech.esper.core.ExtensionServicesContext;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.schedule.ScheduleHandle;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.view.BatchingDataWindowView;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.window.TimeBatchViewFactory;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TimeBatchView
extends ViewSupport
implements CloneableView,
BatchingDataWindowView {
    private final TimeBatchViewFactory timeBatchViewFactory;
    private final StatementContext statementContext;
    private final long msecIntervalSize;
    private final Long initialReferencePoint;
    private final boolean isForceOutput;
    private final boolean isStartEager;
    private final ViewUpdatedCollection viewUpdatedCollection;
    private final ScheduleSlot scheduleSlot;
    private Long currentReferencePoint;
    private LinkedList<EventBean> lastBatch = null;
    private LinkedList<EventBean> currentBatch = new LinkedList();
    private boolean isCallbackScheduled;
    private static final Log log = LogFactory.getLog(TimeBatchView.class);

    public TimeBatchView(TimeBatchViewFactory timeBatchViewFactory, StatementContext statementContext, long msecIntervalSize, Long referencePoint, boolean forceOutput, boolean isStartEager, ViewUpdatedCollection viewUpdatedCollection) {
        this.statementContext = statementContext;
        this.timeBatchViewFactory = timeBatchViewFactory;
        this.msecIntervalSize = msecIntervalSize;
        this.initialReferencePoint = referencePoint;
        this.isStartEager = isStartEager;
        this.viewUpdatedCollection = viewUpdatedCollection;
        this.isForceOutput = forceOutput;
        this.scheduleSlot = statementContext.getScheduleBucket().allocateSlot();
        if (isStartEager) {
            if (this.currentReferencePoint == null) {
                this.currentReferencePoint = statementContext.getSchedulingService().getTime();
            }
            this.scheduleCallback();
            this.isCallbackScheduled = true;
        }
    }

    @Override
    public View cloneView(StatementContext statementContext) {
        return this.timeBatchViewFactory.makeView(statementContext);
    }

    public final long getMsecIntervalSize() {
        return this.msecIntervalSize;
    }

    public final Long getInitialReferencePoint() {
        return this.initialReferencePoint;
    }

    public boolean isForceOutput() {
        return this.isForceOutput;
    }

    public boolean isStartEager() {
        return this.isStartEager;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Received update,   newData.length==" + (newData == null ? 0 : newData.length) + "  oldData.length==" + (oldData == null ? 0 : oldData.length));
        }
        if (this.statementContext == null) {
            String message = "View context has not been supplied, cannot schedule callback";
            log.fatal(".update " + message);
            throw new EPException(message);
        }
        if (newData == null || newData.length == 0) {
            return;
        }
        if (this.currentBatch.isEmpty()) {
            if (this.currentReferencePoint == null) {
                this.currentReferencePoint = this.initialReferencePoint;
                if (this.currentReferencePoint == null) {
                    this.currentReferencePoint = this.statementContext.getSchedulingService().getTime();
                }
            }
            if (!this.isCallbackScheduled) {
                this.scheduleCallback();
                this.isCallbackScheduled = true;
            }
        }
        this.currentBatch.addAll(Arrays.asList(newData));
    }

    protected final void sendBatch() {
        this.isCallbackScheduled = false;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".sendBatch Update child views,   time=" + this.statementContext.getSchedulingService().getTime());
        }
        if (this.hasViews()) {
            EventBean[] newData = null;
            EventBean[] oldData = null;
            if (!this.currentBatch.isEmpty()) {
                newData = this.currentBatch.toArray(new EventBean[this.currentBatch.size()]);
            }
            if (this.lastBatch != null && !this.lastBatch.isEmpty()) {
                oldData = this.lastBatch.toArray(new EventBean[this.lastBatch.size()]);
            }
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(newData, oldData);
            }
            if (newData != null || oldData != null || this.isForceOutput) {
                this.updateChildren(newData, oldData);
            }
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".sendBatch Published updated data, ....newData size=" + this.currentBatch.size());
            for (EventBean object : this.currentBatch) {
                log.debug(".sendBatch object=" + object);
            }
        }
        if (!this.currentBatch.isEmpty() || this.lastBatch != null && !this.lastBatch.isEmpty() || this.isForceOutput) {
            this.scheduleCallback();
            this.isCallbackScheduled = true;
        }
        this.lastBatch = this.currentBatch;
        this.currentBatch = new LinkedList();
    }

    public boolean isEmpty() {
        if (this.lastBatch != null && !this.lastBatch.isEmpty()) {
            return false;
        }
        return this.currentBatch.isEmpty();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.currentBatch.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " msecIntervalSize=" + this.msecIntervalSize + " initialReferencePoint=" + this.initialReferencePoint;
    }

    private void scheduleCallback() {
        long current = this.statementContext.getSchedulingService().getTime();
        long afterMSec = TimeBatchView.computeWaitMSec(current, this.currentReferencePoint, this.msecIntervalSize);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".scheduleCallback Scheduled new callback for  afterMsec=" + afterMSec + " now=" + current + " currentReferencePoint=" + this.currentReferencePoint + " initialReferencePoint=" + this.initialReferencePoint + " msecIntervalSize=" + this.msecIntervalSize);
        }
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            public void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
                TimeBatchView.this.sendBatch();
            }
        };
        EPStatementHandleCallback handle = new EPStatementHandleCallback(this.statementContext.getEpStatementHandle(), callback);
        this.statementContext.getSchedulingService().add(afterMSec, (ScheduleHandle)handle, this.scheduleSlot);
    }

    protected static long computeWaitMSec(long current, long reference, long interval) {
        long solution;
        long n = (current - reference) / interval;
        if (reference > current) {
            --n;
        }
        if ((solution = reference + (n + 1L) * interval - current) == 0L) {
            return interval;
        }
        return solution;
    }
}

