/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ArrayDequeJDK6Backport;
import com.espertech.esper.collection.TimeWindow;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.EPStatementHandleCallback;
import com.espertech.esper.core.ExtensionServicesContext;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.schedule.ScheduleAdjustmentCallback;
import com.espertech.esper.schedule.ScheduleHandle;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.window.TimeWindowViewFactory;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TimeWindowView
extends ViewSupport
implements CloneableView,
DataWindowView,
ScheduleAdjustmentCallback {
    private final TimeWindowViewFactory timeWindowViewFactory;
    private final long millisecondsBeforeExpiry;
    private final TimeWindow timeWindow;
    private final ViewUpdatedCollection viewUpdatedCollection;
    private final StatementContext statementContext;
    private final ScheduleSlot scheduleSlot;
    private final EPStatementHandleCallback handle;
    private static final Log log = LogFactory.getLog(TimeWindowView.class);

    public TimeWindowView(StatementContext statementContext, TimeWindowViewFactory timeWindowViewFactory, long millisecondsBeforeExpiry, ViewUpdatedCollection viewUpdatedCollection, boolean isRemoveStreamHandling) {
        this.statementContext = statementContext;
        this.timeWindowViewFactory = timeWindowViewFactory;
        this.millisecondsBeforeExpiry = millisecondsBeforeExpiry;
        this.viewUpdatedCollection = viewUpdatedCollection;
        this.scheduleSlot = statementContext.getScheduleBucket().allocateSlot();
        this.timeWindow = new TimeWindow(isRemoveStreamHandling);
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            public void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
                TimeWindowView.this.expire();
            }
        };
        this.handle = new EPStatementHandleCallback(statementContext.getEpStatementHandle(), callback);
        statementContext.getScheduleAdjustmentService().addCallback(this);
    }

    @Override
    public void adjust(long delta) {
        this.timeWindow.adjust(delta);
    }

    @Override
    public View cloneView(StatementContext statementContext) {
        return this.timeWindowViewFactory.makeView(statementContext);
    }

    public final long getMillisecondsBeforeExpiry() {
        return this.millisecondsBeforeExpiry;
    }

    public ViewUpdatedCollection getViewUpdatedCollection() {
        return this.viewUpdatedCollection;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        int i;
        if (this.statementContext == null) {
            String message = "View context has not been supplied, cannot schedule callback";
            log.fatal(".update " + message);
            throw new EPException(message);
        }
        long timestamp = this.statementContext.getSchedulingService().getTime();
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                this.timeWindow.remove(oldData[i]);
            }
        }
        if (newData != null && newData.length > 0) {
            if (this.timeWindow.isEmpty()) {
                this.scheduleCallback(this.millisecondsBeforeExpiry);
            }
            for (i = 0; i < newData.length; ++i) {
                this.timeWindow.add(timestamp, newData[i]);
            }
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(newData, null);
            }
        }
        if (this.hasViews()) {
            this.updateChildren(newData, oldData);
        }
    }

    protected final void expire() {
        long expireBeforeTimestamp = this.statementContext.getSchedulingService().getTime() - this.millisecondsBeforeExpiry + 1L;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".expire Expiring messages before msec=" + expireBeforeTimestamp + "  date=" + this.statementContext.getSchedulingService().getTime());
        }
        ArrayDequeJDK6Backport<EventBean> expired = this.timeWindow.expireEvents(expireBeforeTimestamp);
        if (this.hasViews() && expired != null && !expired.isEmpty()) {
            EventBean[] oldEvents = expired.toArray(new EventBean[expired.size()]);
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(null, oldEvents);
            }
            this.updateChildren(null, oldEvents);
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".expire Expired messages....size=" + expired.size());
            for (EventBean object : expired) {
                log.debug(".expire object=" + object);
            }
        }
        if (this.timeWindow.isEmpty()) {
            return;
        }
        Long oldestTimestamp = this.timeWindow.getOldestTimestamp();
        long currentTimestamp = this.statementContext.getSchedulingService().getTime();
        long scheduleMillisec = this.millisecondsBeforeExpiry - (currentTimestamp - oldestTimestamp);
        this.scheduleCallback(scheduleMillisec);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".expire Scheduled new callback for now plus msec=" + scheduleMillisec);
        }
    }

    private void scheduleCallback(long msecAfterCurrentTime) {
        this.statementContext.getSchedulingService().add(msecAfterCurrentTime, (ScheduleHandle)this.handle, this.scheduleSlot);
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.timeWindow.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " millisecondsBeforeExpiry=" + this.millisecondsBeforeExpiry;
    }

    public boolean isEmpty() {
        return this.timeWindow.isEmpty();
    }
}

