/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esperio.socket;

import com.espertech.esper.client.EventBean;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ArrayAssertionUtil {
    private static final Log log = LogFactory.getLog(ArrayAssertionUtil.class);

    public static void assertEqualsStringArr(String[][] data, String[][] expectedValues) {
        if (expectedValues == null && data == null) {
            return;
        }
        if (expectedValues == null && data != null || expectedValues != null && data == null) {
            TestCase.assertTrue((boolean)false);
        }
        TestCase.assertEquals((String)"mismatch in number to elements", (int)expectedValues.length, (int)data.length);
        for (int i = 0; i < expectedValues.length; ++i) {
            TestCase.assertTrue((boolean)Arrays.equals(data[i], expectedValues[i]));
        }
    }

    public static void assertEqualsExactOrder(EventBean[] data, EventBean[] expectedValues) {
        ArrayAssertionUtil.assertEqualsExactOrder((Object[])data, (Object[])expectedValues);
    }

    public static void assertEqualsExactOrder(Iterator<EventBean> iterator, EventBean[] expectedValues) {
        ArrayAssertionUtil.assertEqualsExactOrder(iterator, (Object[])expectedValues);
    }

    public static void assertEqualsExactOrderUnderlying(Iterator<EventBean> iterator, Object[] expectedValues) {
        ArrayList<Object> underlyingValues = new ArrayList<Object>();
        while (iterator.hasNext()) {
            underlyingValues.add(iterator.next().getUnderlying());
        }
        try {
            iterator.next();
            TestCase.fail();
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        Object[] data = null;
        if (underlyingValues.size() > 0) {
            data = underlyingValues.toArray();
        }
        ArrayAssertionUtil.assertEqualsExactOrder((Object[])data, (Object[])expectedValues);
    }

    public static void assertEqualsExactOrderUnderlying(EventBean[] events, Object[] expectedValues) {
        if (expectedValues == null && events == null) {
            return;
        }
        if (expectedValues == null && events != null || expectedValues != null && events == null) {
            TestCase.assertTrue((boolean)false);
        }
        TestCase.assertEquals((int)expectedValues.length, (int)events.length);
        ArrayList<Object> underlying = new ArrayList<Object>();
        for (EventBean event : events) {
            underlying.add(event.getUnderlying());
        }
        ArrayAssertionUtil.assertEqualsExactOrder((Object[])underlying.toArray(), (Object[])expectedValues);
    }

    public static void assertEqualsExactOrder(Object[] data, Object[] expectedValues) {
        if (expectedValues == null && data == null) {
            return;
        }
        if (expectedValues == null && data != null || expectedValues != null && data == null) {
            TestCase.assertTrue((boolean)false);
        }
        TestCase.assertEquals((int)expectedValues.length, (int)data.length);
        for (int i = 0; i < expectedValues.length; ++i) {
            String expectedType = expectedValues[i] == null ? "null" : expectedValues[i].getClass().toString();
            String dataType = data[i] == null ? "null" : data[i].getClass().toString();
            TestCase.assertEquals((String)("at element " + i + " (expected type " + expectedType + " received " + dataType + ")"), (Object)expectedValues[i], (Object)data[i]);
        }
    }

    public static void assertSameExactOrder(Object[] expectedValues, Object[] data) {
        if (expectedValues == null && data == null) {
            return;
        }
        if (expectedValues == null && data != null || expectedValues != null && data == null) {
            TestCase.assertTrue((boolean)false);
        }
        TestCase.assertEquals((int)expectedValues.length, (int)data.length);
        for (int i = 0; i < expectedValues.length; ++i) {
            TestCase.assertSame((String)("at element " + i), (Object)expectedValues[i], (Object)data[i]);
        }
    }

    public static void assertEqualsExactOrder(int[] data, int[] expectedValues) {
        if (expectedValues == null && data == null) {
            return;
        }
        if (expectedValues == null && data != null || expectedValues != null && data == null) {
            TestCase.assertTrue((boolean)false);
        }
        TestCase.assertEquals((int)expectedValues.length, (int)data.length);
        for (int i = 0; i < expectedValues.length; ++i) {
            TestCase.assertEquals((int)expectedValues[i], (int)data[i]);
        }
    }

    public static void assertEqualsExactOrder(int[] expectedValues, Integer[] data) {
        if (expectedValues == null && data == null) {
            return;
        }
        if (expectedValues == null && data != null || expectedValues != null && data == null) {
            TestCase.assertTrue((boolean)false);
        }
        TestCase.assertEquals((int)expectedValues.length, (int)data.length);
        for (int i = 0; i < expectedValues.length; ++i) {
            TestCase.assertEquals((int)expectedValues[i], (int)data[i]);
        }
    }

    public static void assertEqualsExactOrder(short[] data, short[] expectedValues) {
        if (expectedValues == null && data == null) {
            return;
        }
        if (expectedValues == null && data != null || expectedValues != null && data == null) {
            TestCase.assertTrue((boolean)false);
        }
        TestCase.assertEquals((int)expectedValues.length, (int)data.length);
        for (int i = 0; i < expectedValues.length; ++i) {
            TestCase.assertEquals((short)expectedValues[i], (short)data[i]);
        }
    }

    public static void assertEqualsExactOrder(long[] data, long[] expectedValues) {
        if (expectedValues == null && data == null) {
            return;
        }
        if (expectedValues == null && data != null || expectedValues != null && data == null) {
            TestCase.assertTrue((boolean)false);
        }
        TestCase.assertEquals((int)expectedValues.length, (int)data.length);
        for (int i = 0; i < expectedValues.length; ++i) {
            TestCase.assertEquals((long)expectedValues[i], (long)data[i]);
        }
    }

    public static void assertEqualsExactOrder(Object[][] data, Object[][] expectedValues) {
        if (expectedValues == null && data == null) {
            return;
        }
        if (expectedValues == null && data != null || expectedValues != null && data == null) {
            TestCase.assertTrue((boolean)false);
        }
        TestCase.assertEquals((int)expectedValues.length, (int)data.length);
        for (int i = 0; i < expectedValues.length; ++i) {
            ArrayAssertionUtil.assertEqualsExactOrder((Object[])data[i], (Object[])expectedValues[i]);
        }
    }

    public static void assertEqualsExactOrder(String[] data, String[] expectedValues) {
        if (expectedValues == null && data == null) {
            return;
        }
        if (expectedValues == null && data != null || expectedValues != null && data == null) {
            TestCase.assertTrue((boolean)false);
        }
        TestCase.assertEquals((int)expectedValues.length, (int)data.length);
        for (int i = 0; i < expectedValues.length; ++i) {
            TestCase.assertEquals((String)expectedValues[i], (String)data[i]);
        }
    }

    public static void assertEqualsExactOrder(boolean[] data, boolean[] expectedValues) {
        if (expectedValues == null && data == null) {
            return;
        }
        if (expectedValues == null && data != null || expectedValues != null && data == null) {
            TestCase.assertTrue((boolean)false);
        }
        TestCase.assertEquals((int)expectedValues.length, (int)data.length);
        for (int i = 0; i < expectedValues.length; ++i) {
            TestCase.assertEquals((boolean)expectedValues[i], (boolean)data[i]);
        }
    }

    public static void assertEqualsExactOrder(Iterator iterator, Object[] expectedValues) {
        ArrayList values = new ArrayList();
        while (iterator.hasNext()) {
            values.add(iterator.next());
        }
        try {
            iterator.next();
            TestCase.fail();
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        Object[] data = null;
        if (values.size() > 0) {
            data = values.toArray();
        }
        ArrayAssertionUtil.assertEqualsExactOrder((Object[])data, (Object[])expectedValues);
    }

    public static void assertEqualsAnyOrder(int[] expected, Set<Integer> intSet) {
        if (intSet == null && expected == null) {
            return;
        }
        TestCase.assertEquals((String)"length mismatch", (int)expected.length, (int)intSet.size());
        for (int i = 0; i < expected.length; ++i) {
            TestCase.assertTrue((String)("not found: " + expected[i]), (boolean)intSet.contains(expected[i]));
        }
    }

    public static void assertEqualsAnyOrder(int[] expected, int[] result) {
        TestCase.assertEquals((String)"length mismatch", (int)expected.length, (int)result.length);
        HashSet<Integer> intSet = new HashSet<Integer>();
        for (int i = 0; i < result.length; ++i) {
            intSet.add(result[i]);
        }
        ArrayAssertionUtil.assertEqualsAnyOrder((int[])expected, intSet);
    }

    public static void assertEqualsAnyOrder(Object[] expected, Object[] receivedObj) {
        if (receivedObj == null && expected == null || receivedObj.length == 0 && expected == null || receivedObj == null && expected.length == 0) {
            return;
        }
        TestCase.assertEquals((int)expected.length, (int)receivedObj.length);
        Object[] received = new Object[receivedObj.length];
        System.arraycopy(receivedObj, 0, received, 0, receivedObj.length);
        int numMatches = 0;
        for (Object expectedObject : expected) {
            boolean found = false;
            for (int i = 0; i < received.length; ++i) {
                if (received[i] == null || !received[i].equals(expectedObject)) continue;
                found = true;
                ++numMatches;
                received[i] = null;
                break;
            }
            if (!found) {
                log.error(".assertEqualsAnyOrder Not found in received results is expected=" + expectedObject);
                log.error(".assertEqualsAnyOrder received=" + Arrays.toString(received));
            }
            TestCase.assertTrue((boolean)found);
        }
        TestCase.assertEquals((int)numMatches, (int)expected.length);
    }

    public static void assertPropsPerRow(EventBean[] received, Object[][] propertiesPerRow) {
        if (propertiesPerRow == null && (received == null || received.length == 0)) {
            return;
        }
        Assert.assertEquals((int)propertiesPerRow.length, (int)received.length);
        for (int i = 0; i < propertiesPerRow.length; ++i) {
            String name = (String)propertiesPerRow[i][0];
            Object value = propertiesPerRow[i][1];
            Object eventProp = received[i].get(name);
            Assert.assertEquals((String)("Error asserting property named " + name), (Object)value, (Object)eventProp);
        }
    }

    public static void assertPropsPerRow(List<Object[]> received, Object[][] propertiesListPerRow) {
        if (propertiesListPerRow == null && (received == null || received.size() == 0)) {
            return;
        }
        Assert.assertEquals((int)propertiesListPerRow.length, (int)received.size());
        for (int i = 0; i < propertiesListPerRow.length; ++i) {
            Object[] receivedThisRow = received.get(i);
            Object[] propertiesThisRow = propertiesListPerRow[i];
            Assert.assertEquals((int)receivedThisRow.length, (int)propertiesThisRow.length);
            for (int j = 0; j < propertiesThisRow.length; ++j) {
                Object expectedValue = propertiesThisRow[j];
                Object receivedValue = receivedThisRow[j];
                Assert.assertEquals((String)"Error asserting property", (Object)expectedValue, (Object)receivedValue);
            }
        }
    }

    public static void assertPropsPerRow(Map[] received, String[] propertyNames, Object[][] propertiesListPerRow) {
        if (propertiesListPerRow == null && (received == null || received.length == 0)) {
            return;
        }
        Assert.assertEquals((int)propertiesListPerRow.length, (int)received.length);
        for (int i = 0; i < propertiesListPerRow.length; ++i) {
            Object[] propertiesThisRow = propertiesListPerRow[i];
            for (int j = 0; j < propertiesThisRow.length; ++j) {
                String name = propertyNames[j];
                Object value = propertiesThisRow[j];
                Object eventProp = received[i].get(name);
                Assert.assertEquals((String)("Error asserting property named " + name), (Object)value, eventProp);
            }
        }
    }

    public static void assertPropsPerRow(Object[][] received, String[] propertyNames, Object[][] propertiesListPerRow) {
        if (propertiesListPerRow == null && (received == null || received.length == 0)) {
            return;
        }
        Assert.assertEquals((int)propertiesListPerRow.length, (int)received.length);
        for (int i = 0; i < propertiesListPerRow.length; ++i) {
            Object[] propertiesThisRow = propertiesListPerRow[i];
            for (int j = 0; j < propertiesThisRow.length; ++j) {
                String name = propertyNames[j];
                Object value = propertiesThisRow[j];
                Object eventProp = received[i][j];
                Assert.assertEquals((String)("Error asserting property named " + name), (Object)value, (Object)eventProp);
            }
        }
    }

    public static void assertPropsPerRow(EventBean[] received, String[] propertyNames, Object[][] propertiesListPerRow) {
        ArrayAssertionUtil.assertPropsPerRow((EventBean[])received, (String[])propertyNames, (Object[][])propertiesListPerRow, (String)"");
    }

    public static void assertPropsPerRow(EventBean[] received, String[] propertyNames, Object[][] propertiesListPerRow, String streamName) {
        if (propertiesListPerRow == null) {
            if (received == null || received.length == 0) {
                return;
            }
            Assert.fail((String)("No events expected by received one or more for stream " + streamName));
        }
        if (received == null) {
            Assert.fail((String)("No events received, however some were expected for stream " + streamName));
        }
        Assert.assertEquals((String)"Mismatch in the number of rows received", (int)propertiesListPerRow.length, (int)received.length);
        for (int i = 0; i < propertiesListPerRow.length; ++i) {
            Object[] propertiesThisRow = propertiesListPerRow[i];
            for (int j = 0; j < propertiesThisRow.length; ++j) {
                String name = propertyNames[j];
                Object value = propertiesThisRow[j];
                Object eventProp = received[i].get(name);
                Assert.assertEquals((String)("Error asserting property named " + name + " for row " + i + " for " + streamName), (Object)value, (Object)eventProp);
            }
        }
    }

    public static void assertProps(EventBean received, String[] propertyNames, Object[] propertiesThisRow) {
        if (propertiesThisRow == null && received == null) {
            return;
        }
        Assert.assertEquals((int)propertyNames.length, (int)propertiesThisRow.length);
        for (int j = 0; j < propertiesThisRow.length; ++j) {
            String name = propertyNames[j].trim();
            Object value = propertiesThisRow[j];
            Object eventProp = received.get(name);
            Assert.assertEquals((String)("Error asserting property named '" + name + "'"), (Object)value, (Object)eventProp);
        }
    }

    public static void assertAllProps(EventBean received, Object[] propertiesSortedByName) {
        if (propertiesSortedByName == null && received == null) {
            return;
        }
        String[] propertyNames = received.getEventType().getPropertyNames();
        Object[] propertyNamesSorted = new String[propertyNames.length];
        System.arraycopy(propertyNames, 0, propertyNamesSorted, 0, propertyNames.length);
        Arrays.sort(propertyNamesSorted);
        for (int j = 0; j < propertiesSortedByName.length; ++j) {
            String name = ((String)propertyNamesSorted[j]).trim();
            Object value = propertiesSortedByName[j];
            Object eventProp = received.get(name);
            Assert.assertEquals((String)("Error asserting property named '" + name + "'"), (Object)value, (Object)eventProp);
        }
    }

    public static void assertProps(Map pojo, String[] propertyNames, Object ... propertiesThisRow) {
        if (propertiesThisRow == null && pojo == null) {
            return;
        }
        for (int j = 0; j < propertiesThisRow.length; ++j) {
            String name = propertyNames[j].trim();
            Object value = propertiesThisRow[j];
            Object eventProp = pojo.get(name);
            Assert.assertEquals((String)("Error asserting property named '" + name + "'"), (Object)value, eventProp);
        }
    }

    public static void assertEqualsAnyOrder(Iterator<EventBean> iterator, String[] propertyNames, Object[][] propertiesListPerRow) {
        int i;
        EventBean[] received = ArrayAssertionUtil.iteratorToArray(iterator);
        if (propertiesListPerRow == null) {
            if (received == null || received.length == 0) {
                return;
            }
            Assert.fail((String)("Expected no results but received " + received.length + " events"));
        }
        Assert.assertEquals((int)propertiesListPerRow.length, (int)received.length);
        HashMap<EventBean, Object[]> valuesEachEvent = new HashMap<EventBean, Object[]>();
        for (i = 0; i < received.length; ++i) {
            Object[] values = new Object[propertyNames.length];
            for (int j = 0; j < propertyNames.length; ++j) {
                values[j] = received[i].get(propertyNames[j]);
            }
            valuesEachEvent.put(received[i], values);
        }
        for (i = 0; i < propertiesListPerRow.length; ++i) {
            Object[] propertiesThisRow = propertiesListPerRow[i];
            boolean isFound = false;
            for (Map.Entry entry : valuesEachEvent.entrySet()) {
                if (!Arrays.equals((Object[])entry.getValue(), propertiesThisRow)) continue;
                entry.setValue(null);
                isFound = true;
                break;
            }
            if (isFound) continue;
            String text = "Error finding property set: " + Arrays.toString(propertiesListPerRow[i]) + " among values: \n" + ArrayAssertionUtil.dump(valuesEachEvent);
            Assert.fail((String)text);
        }
        for (Map.Entry entry : valuesEachEvent.entrySet()) {
            if (entry.getValue() == null) continue;
            Assert.fail();
        }
    }

    private static String dump(Map<EventBean, Object[]> valuesEachEvent) {
        StringWriter buf = new StringWriter();
        PrintWriter writer = new PrintWriter(buf);
        for (Map.Entry<EventBean, Object[]> entry : valuesEachEvent.entrySet()) {
            String values = Arrays.toString(entry.getValue());
            writer.println(values);
        }
        return buf.toString();
    }

    public static void assertAllBooleanTrue(Object[] objects) {
        for (int i = 0; i < objects.length; ++i) {
            Assert.assertTrue((boolean)((Boolean)objects[i]));
        }
    }

    public static void assertTypeEqualsAnyOrder(Class[] classes, Object[] objects) {
        TestCase.assertEquals((int)classes.length, (int)objects.length);
        Object[] resultClasses = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            resultClasses[i] = objects[i].getClass();
        }
        ArrayAssertionUtil.assertEqualsAnyOrder((Object[])resultClasses, (Object[])classes);
    }

    public static EventBean[] iteratorToArray(Iterator<EventBean> iterator) {
        if (iterator == null) {
            Assert.fail((String)"Null iterator");
        }
        ArrayList<EventBean> events = new ArrayList<EventBean>();
        while (iterator.hasNext()) {
            events.add(iterator.next());
        }
        return events.toArray(new EventBean[0]);
    }

    public static Object[] iteratorToArrayUnderlying(Iterator<EventBean> iterator) {
        ArrayList<Object> events = new ArrayList<Object>();
        while (iterator.hasNext()) {
            events.add(iterator.next().getUnderlying());
        }
        return events.toArray();
    }

    public static int iteratorCount(Iterator<EventBean> iterator) {
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    public static Object[] sum(Object[] srcOne, Object[] srcTwo) {
        Object[] result = new Object[srcOne.length + srcTwo.length];
        System.arraycopy(srcOne, 0, result, 0, srcOne.length);
        System.arraycopy(srcTwo, 0, result, srcOne.length, srcTwo.length);
        return result;
    }

    public static void assertEqualsExactOrder(Iterator<EventBean> iterator, String[] fields, Object[][] expectedValues) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        while (iterator.hasNext()) {
            EventBean event = iterator.next();
            Object[] eventProps = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                eventProps[i] = event.get(fields[i]);
            }
            rows.add(eventProps);
        }
        try {
            iterator.next();
            TestCase.fail();
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        if (rows.size() == 0) {
            Assert.assertNull((String)"Expected rows in result but received none", (Object)expectedValues);
            return;
        }
        Object[][] data = (Object[][])rows.toArray((T[])new Object[0][]);
        if (expectedValues == null && data != null) {
            Assert.fail((String)("Expected no values but received data: " + data.length + " elements"));
        }
        Assert.assertEquals((int)expectedValues.length, (int)data.length);
        for (int i = 0; i < data.length; ++i) {
            ArrayAssertionUtil.assertEqualsExactOrder((Object[])data[i], (Object[])expectedValues[i]);
        }
    }

    public static void compare(EventBean[] events, List<Map<String, Object>> expectedValues) {
        if (expectedValues == null && events == null) {
            return;
        }
        if (expectedValues == null && events != null || expectedValues != null && events == null) {
            TestCase.assertTrue((boolean)false);
        }
        TestCase.assertEquals((int)expectedValues.size(), (int)events.length);
        for (int i = 0; i < expectedValues.size(); ++i) {
            ArrayAssertionUtil.compare((EventBean)events[i], expectedValues.get(i));
        }
    }

    public static void compare(Iterator<EventBean> iterator, List<Map<String, Object>> expectedValues) {
        ArrayList<EventBean> values = new ArrayList<EventBean>();
        while (iterator.hasNext()) {
            values.add(iterator.next());
        }
        try {
            iterator.next();
            TestCase.fail();
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        EventBean[] data = null;
        if (values.size() > 0) {
            data = values.toArray(new EventBean[0]);
        }
        ArrayAssertionUtil.compare(data, expectedValues);
    }

    private static void compare(EventBean event, Map<String, Object> expected) {
        for (Map.Entry<String, Object> entry : expected.entrySet()) {
            Object valueExpected = entry.getValue();
            Object property = event.get(entry.getKey());
            TestCase.assertEquals((Object)valueExpected, (Object)property);
        }
    }

    public static Object[][] addArray(Object[][] first, Object[][] ... more) {
        int i;
        int len = first.length;
        for (int i2 = 0; i2 < more.length; ++i2) {
            Object[][] next = more[i2];
            len += next.length;
        }
        Object[][] result = new Object[len][];
        int count = 0;
        for (i = 0; i < first.length; ++i) {
            result[count] = first[i];
            ++count;
        }
        for (i = 0; i < more.length; ++i) {
            Object[][] next = more[i];
            for (int j = 0; j < next.length; ++j) {
                result[count] = next[j];
                ++count;
            }
        }
        return result;
    }
}

