/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esperio.socket;

import com.espertech.esper.client.ConfigurationException;
import com.espertech.esper.client.EPServiceProviderManager;
import com.espertech.esper.core.EPServiceProviderSPI;
import com.espertech.esperio.socket.config.ConfigurationSocketAdapter;
import com.espertech.esperio.socket.config.SocketConfig;
import com.espertech.esperio.socket.core.EsperSocketService;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EsperIOSocketAdapter {
    private static Log log = LogFactory.getLog(EsperIOSocketAdapter.class);
    private final ConfigurationSocketAdapter config;
    private final String engineURI;
    private final Map<String, EsperSocketService> sockets = new HashMap();

    public EsperIOSocketAdapter(ConfigurationSocketAdapter config, String engineURI) {
        this.config = config;
        this.engineURI = engineURI;
    }

    public void initialize() {
    }

    public synchronized void start() {
        if (log.isInfoEnabled()) {
            log.info("Starting EsperIO Socket Adapter for engine URI '" + this.engineURI + "'");
        }
        EPServiceProviderSPI engineSPI = (EPServiceProviderSPI)EPServiceProviderManager.getProvider(this.engineURI);
        HashSet<Integer> ports = new HashSet<Integer>();
        for (Map.Entry entry : this.config.getSockets().entrySet()) {
            if (this.sockets.containsKey(entry.getKey())) {
                throw new ConfigurationException("A socket by name '" + (String)entry.getKey() + "' has already been configured.");
            }
            int port = ((SocketConfig)entry.getValue()).getPort();
            if (ports.contains(port)) {
                throw new ConfigurationException("A socket for port '" + port + "' has already been configured.");
            }
            ports.add(port);
            EsperSocketService socketService = new EsperSocketService((String)entry.getKey(), (SocketConfig)entry.getValue());
            this.sockets.put(entry.getKey(), socketService);
        }
        for (Map.Entry entry : this.sockets.entrySet()) {
            try {
                ((EsperSocketService)entry.getValue()).start((String)entry.getKey(), engineSPI);
            }
            catch (IOException e) {
                log.error("Error starting socket '" + (String)entry.getKey() + "' :" + e.getMessage());
            }
        }
        if (log.isInfoEnabled()) {
            log.info("Completed starting EsperIO Socket Adapter for engine URI '" + this.engineURI + "'.");
        }
    }

    public synchronized void destroy() {
        if (log.isDebugEnabled()) {
            log.debug("Destroying Esper Socket Adapter");
        }
        for (EsperSocketService service : this.sockets.values()) {
            try {
                service.destroy();
            }
            catch (Throwable t) {
                log.info("Error destroying service '" + service.getServiceName() + "' :" + t.getMessage());
            }
        }
        this.sockets.clear();
    }
}

