/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esperio.socket;

import com.espertech.esper.plugin.PluginLoader;
import com.espertech.esper.plugin.PluginLoaderInitContext;
import com.espertech.esperio.socket.EsperIOSocketAdapter;
import com.espertech.esperio.socket.config.ConfigurationSocketAdapter;
import java.io.File;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EsperIOSocketAdapterPlugin
implements PluginLoader {
    private static Log log = LogFactory.getLog(EsperIOSocketAdapterPlugin.class);
    private static final String ESPERIO_SOCKET_CONFIG_FILE = "esperio.socket.configuration.file";
    private EsperIOSocketAdapter socketadapter;
    private PluginLoaderInitContext context;

    public void init(PluginLoaderInitContext context) {
        this.context = context;
    }

    public void postInitialize() {
        ConfigurationSocketAdapter adapterConfig = this.context.getConfigXml() != null ? this.fromXml(this.context.getConfigXml()) : this.fromExternalFile();
        log.info("Starting Socket Adapter");
        this.socketadapter = new EsperIOSocketAdapter(adapterConfig, this.context.getEpServiceProvider().getURI());
        this.socketadapter.start();
    }

    public void destroy() {
        if (this.socketadapter != null) {
            this.socketadapter.destroy();
        }
        this.socketadapter = null;
    }

    private ConfigurationSocketAdapter fromXml(String xml) {
        ConfigurationSocketAdapter adapter = new ConfigurationSocketAdapter();
        return adapter.configureFromString(xml);
    }

    private ConfigurationSocketAdapter fromExternalFile() {
        URL urlConfigFile;
        String configFile = this.context.getProperties().getProperty(ESPERIO_SOCKET_CONFIG_FILE);
        if (configFile == null) {
            String message = "Required initialization property 'esperio.socket.configuration.file' is not provided";
            log.error(message);
            throw new RuntimeException(message);
        }
        try {
            urlConfigFile = this.resolveURL(configFile);
        }
        catch (Exception ex) {
            String message = "Error resolving config file from classpath or as a URL: " + ex.getMessage();
            log.error(message, ex);
            throw new RuntimeException(message, ex);
        }
        if (urlConfigFile == null) {
            String message = "Configuration file could not be resolved from '" + urlConfigFile + "'";
            log.error(message);
            throw new RuntimeException(message);
        }
        ConfigurationSocketAdapter config = new ConfigurationSocketAdapter();
        try {
            config.configure(urlConfigFile);
        }
        catch (RuntimeException ex) {
            String message = "Configuration file read error for config file '" + urlConfigFile + "': " + ex.getMessage();
            log.error(message, ex);
            throw new RuntimeException(message, ex);
        }
        return config;
    }

    private URL resolveURL(String config) throws Exception {
        URL url = this.getClass().getClassLoader().getResource(config);
        if (url != null) {
            return url;
        }
        url = Thread.currentThread().getContextClassLoader().getResource(config);
        if (url != null) {
            return url;
        }
        File file = new File(config);
        if (!file.isAbsolute()) {
            String espereeBase = System.getProperty("esperee.base");
            file = new File(espereeBase, config);
        }
        if (file.exists()) {
            return file.toURI().toURL();
        }
        return new URL(config);
    }
}

