/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esperio.socket;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.UpdateListener;
import com.espertech.esper.collection.UniformPair;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupportUpdateListener
implements UpdateListener {
    private final List<EventBean[]> newDataList = new LinkedList();
    private final List<EventBean[]> oldDataList = new LinkedList();
    private EventBean[] lastNewData;
    private EventBean[] lastOldData;
    private boolean isInvoked;

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        this.oldDataList.add(oldData);
        this.newDataList.add(newData);
        this.lastNewData = newData;
        this.lastOldData = oldData;
        this.isInvoked = true;
    }

    public void reset() {
        this.oldDataList.clear();
        this.newDataList.clear();
        this.lastNewData = null;
        this.lastOldData = null;
        this.isInvoked = false;
    }

    public EventBean[] getLastNewData() {
        return this.lastNewData;
    }

    public EventBean[] getLastNewDataAndReset() {
        EventBean[] hold = this.lastNewData;
        this.reset();
        return hold;
    }

    public EventBean[] getAndResetLastNewData() {
        EventBean[] lastNew = this.lastNewData;
        this.reset();
        return lastNew;
    }

    public EventBean assertOneGetNewAndReset() {
        Assert.assertTrue((boolean)this.isInvoked);
        Assert.assertEquals((int)1, (int)this.newDataList.size());
        Assert.assertEquals((int)1, (int)this.oldDataList.size());
        Assert.assertEquals((int)1, (int)this.lastNewData.length);
        Assert.assertNull((Object)this.lastOldData);
        EventBean lastNew = this.lastNewData[0];
        this.reset();
        return lastNew;
    }

    public EventBean assertOneGetNew() {
        Assert.assertTrue((boolean)this.isInvoked);
        Assert.assertEquals((int)1, (int)this.newDataList.size());
        Assert.assertEquals((int)1, (int)this.oldDataList.size());
        Assert.assertEquals((int)1, (int)this.lastNewData.length);
        return this.lastNewData[0];
    }

    public EventBean assertOneGetOld() {
        Assert.assertTrue((boolean)this.isInvoked);
        Assert.assertEquals((int)1, (int)this.newDataList.size());
        Assert.assertEquals((int)1, (int)this.oldDataList.size());
        Assert.assertEquals((int)1, (int)this.lastOldData.length);
        return this.lastOldData[0];
    }

    public EventBean assertOneGetOldAndReset() {
        Assert.assertTrue((boolean)this.isInvoked);
        Assert.assertEquals((int)1, (int)this.newDataList.size());
        Assert.assertEquals((int)1, (int)this.oldDataList.size());
        Assert.assertEquals((int)1, (int)this.lastOldData.length);
        Assert.assertNull((Object)this.lastNewData);
        EventBean lastNew = this.lastOldData[0];
        this.reset();
        return lastNew;
    }

    public EventBean[] getLastOldData() {
        return this.lastOldData;
    }

    public List<EventBean[]> getNewDataList() {
        return this.newDataList;
    }

    public List<EventBean[]> getOldDataList() {
        return this.oldDataList;
    }

    public boolean isInvoked() {
        return this.isInvoked;
    }

    public boolean getAndClearIsInvoked() {
        boolean invoked = this.isInvoked;
        this.isInvoked = false;
        return invoked;
    }

    public void setLastNewData(EventBean[] lastNewData) {
        this.lastNewData = lastNewData;
    }

    public void setLastOldData(EventBean[] lastOldData) {
        this.lastOldData = lastOldData;
    }

    public EventBean[] getNewDataListFlattened() {
        return this.flatten(this.newDataList);
    }

    public EventBean[] getOldDataListFlattened() {
        return this.flatten(this.oldDataList);
    }

    private EventBean[] flatten(List<EventBean[]> list) {
        int count = 0;
        for (EventBean[] events : list) {
            if (events == null) continue;
            count += events.length;
        }
        EventBean[] array = new EventBean[count];
        count = 0;
        for (EventBean[] events : list) {
            if (events == null) continue;
            for (int i = 0; i < events.length; ++i) {
                array[count++] = events[i];
            }
        }
        return array;
    }

    public void assertUnderlyingAndReset(Object[] expectedUnderlyingNew, Object[] expectedUnderlyingOld) {
        int i;
        Assert.assertEquals((int)1, (int)this.getNewDataList().size());
        Assert.assertEquals((int)1, (int)this.getOldDataList().size());
        EventBean[] newEvents = this.getLastNewData();
        EventBean[] oldEvents = this.getLastOldData();
        if (expectedUnderlyingNew != null) {
            Assert.assertEquals((int)expectedUnderlyingNew.length, (int)newEvents.length);
            for (i = 0; i < expectedUnderlyingNew.length; ++i) {
                Assert.assertSame((Object)expectedUnderlyingNew[i], (Object)newEvents[i].getUnderlying());
            }
        } else {
            Assert.assertNull((Object)newEvents);
        }
        if (expectedUnderlyingOld != null) {
            Assert.assertEquals((int)expectedUnderlyingOld.length, (int)oldEvents.length);
            for (i = 0; i < expectedUnderlyingOld.length; ++i) {
                Assert.assertSame((Object)expectedUnderlyingOld[i], (Object)oldEvents[i].getUnderlying());
            }
        } else {
            Assert.assertNull((Object)oldEvents);
        }
        this.reset();
    }

    public void assertFieldEqualsAndReset(String fieldName, Object[] expectedNew, Object[] expectedOld) {
        int i;
        Assert.assertEquals((int)1, (int)this.getNewDataList().size());
        Assert.assertEquals((int)1, (int)this.getOldDataList().size());
        EventBean[] newEvents = this.getLastNewData();
        EventBean[] oldEvents = this.getLastOldData();
        if (expectedNew != null) {
            Assert.assertEquals((int)expectedNew.length, (int)newEvents.length);
            for (i = 0; i < expectedNew.length; ++i) {
                Object result = newEvents[i].get(fieldName);
                Assert.assertEquals((Object)expectedNew[i], (Object)result);
            }
        } else {
            Assert.assertNull((Object)newEvents);
        }
        if (expectedOld != null) {
            Assert.assertEquals((int)expectedOld.length, (int)oldEvents.length);
            for (i = 0; i < expectedOld.length; ++i) {
                Assert.assertEquals((Object)expectedOld[i], (Object)oldEvents[i].get(fieldName));
            }
        } else {
            Assert.assertNull((Object)oldEvents);
        }
        this.reset();
    }

    public UniformPair<EventBean[]> getDataListsFlattened() {
        return new UniformPair<EventBean[]>(this.flatten(this.newDataList), this.flatten(this.oldDataList));
    }
}

