/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esperio.socket;

import com.espertech.esper.client.Configuration;
import com.espertech.esper.client.EPServiceProvider;
import com.espertech.esper.client.EPServiceProviderManager;
import com.espertech.esper.client.EPStatement;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.UpdateListener;
import com.espertech.esperio.socket.ArrayAssertionUtil;
import com.espertech.esperio.socket.EsperIOSocketAdapter;
import com.espertech.esperio.socket.SupportBean;
import com.espertech.esperio.socket.SupportSocketClientCSV;
import com.espertech.esperio.socket.SupportUpdateListener;
import com.espertech.esperio.socket.config.ConfigurationSocketAdapter;
import com.espertech.esperio.socket.config.DataType;
import com.espertech.esperio.socket.config.SocketConfig;
import junit.framework.TestCase;

public class TestSocketAdapterCSV
extends TestCase {
    public static String newline = System.getProperty("line.separator");
    private SupportUpdateListener listener;

    public void setUp() throws Exception {
        this.listener = new SupportUpdateListener();
    }

    public void testSendCSV() throws Exception {
        ConfigurationSocketAdapter adapterConfig = new ConfigurationSocketAdapter();
        int port = 7989;
        String engineURI = "TestSocketAdapterCSV";
        SocketConfig socket = new SocketConfig();
        socket.setDataType(DataType.CSV);
        socket.setPort(port);
        adapterConfig.getSockets().put("SocketService", socket);
        EsperIOSocketAdapter adapter = new EsperIOSocketAdapter(adapterConfig, engineURI);
        Configuration engineConfig = new Configuration();
        engineConfig.addEventType("SupportBean", SupportBean.class);
        EPServiceProvider provider = EPServiceProviderManager.getProvider(engineURI, engineConfig);
        adapter.start();
        EPStatement stmt = provider.getEPAdministrator().createEPL("select * from SupportBean");
        stmt.addListener((UpdateListener)this.listener);
        String[] fields = "stringProp,intProp".split(",");
        SupportSocketClientCSV client = new SupportSocketClientCSV(port);
        client.send("stream=SupportBean,stringProp=E1,intProp=20" + newline);
        Thread.sleep(200L);
        ArrayAssertionUtil.assertProps((EventBean)this.listener.assertOneGetNewAndReset(), (String[])fields, (Object[])new Object[]{"E1", 20});
        client.send("stream=SupportBean,stringProp=E2,intProp=20,xxxx,x=msdjdjdj,intProp=21" + newline);
        Thread.sleep(200L);
        ArrayAssertionUtil.assertProps((EventBean)this.listener.assertOneGetNewAndReset(), (String[])fields, (Object[])new Object[]{"E2", 21});
        client.close();
        adapter.destroy();
        provider.destroy();
    }
}

