/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esperio.socket;

import com.espertech.esper.client.Configuration;
import com.espertech.esper.client.EPServiceProvider;
import com.espertech.esper.client.EPServiceProviderManager;
import com.espertech.esper.client.EPStatement;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.UpdateListener;
import com.espertech.esperio.socket.ArrayAssertionUtil;
import com.espertech.esperio.socket.EsperIOSocketAdapterPlugin;
import com.espertech.esperio.socket.SupportBean;
import com.espertech.esperio.socket.SupportSocketClientObject;
import com.espertech.esperio.socket.SupportSocketUtil;
import com.espertech.esperio.socket.SupportUpdateListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSocketAdapterObject
extends TestCase {
    private SupportUpdateListener listener;

    public void setUp() throws Exception {
        this.listener = new SupportUpdateListener();
    }

    public void testSendObject() throws Exception {
        int port = 6800;
        String mapTypeName = "MyMapType";
        String esperIOConfig = "<esperio-socket-configuration>\n<socket name=\"service1\" port=\"" + port + "\" data=\"object\"/>" + "</esperio-socket-configuration>";
        Configuration engineConfig = new Configuration();
        engineConfig.addPluginLoader("EsperIOSocketAdapter", EsperIOSocketAdapterPlugin.class.getName(), new Properties(), esperIOConfig);
        engineConfig.addEventType("SupportBean", SupportBean.class);
        engineConfig.addEventType(mapTypeName, this.getMapType());
        EPServiceProvider provider = EPServiceProviderManager.getProvider("SocketAdapterTest", engineConfig);
        EPStatement stmt = provider.getEPAdministrator().createEPL("select * from SupportBean");
        stmt.addListener((UpdateListener)this.listener);
        stmt = provider.getEPAdministrator().createEPL("select * from " + mapTypeName);
        stmt.addListener((UpdateListener)this.listener);
        SupportSocketUtil.sendSingleObject((int)port, (Object)new SupportBean("E1", 10));
        String[] fields = "stringProp,intProp".split(",");
        Thread.sleep(200L);
        ArrayAssertionUtil.assertProps((EventBean)this.listener.assertOneGetNewAndReset(), (String[])fields, (Object[])new Object[]{"E1", 10});
        SupportSocketClientObject client = new SupportSocketClientObject(port);
        client.send((Object)new SupportBean("E2", 20));
        Thread.sleep(200L);
        ArrayAssertionUtil.assertProps((EventBean)this.listener.assertOneGetNewAndReset(), (String[])fields, (Object[])new Object[]{"E2", 20});
        client.send((Object)new SupportBean("E3", 30));
        Thread.sleep(200L);
        ArrayAssertionUtil.assertProps((EventBean)this.listener.assertOneGetNewAndReset(), (String[])fields, (Object[])new Object[]{"E3", 30});
        client.close();
        SupportSocketClientObject clientOne = new SupportSocketClientObject(port);
        SupportSocketClientObject clientTwo = new SupportSocketClientObject(port);
        clientTwo.send((Object)new SupportBean("E4", 40));
        Thread.sleep(200L);
        ArrayAssertionUtil.assertProps((EventBean)this.listener.assertOneGetNewAndReset(), (String[])fields, (Object[])new Object[]{"E4", 40});
        clientOne.send((Object)new SupportBean("E5", 50));
        Thread.sleep(200L);
        ArrayAssertionUtil.assertProps((EventBean)this.listener.assertOneGetNewAndReset(), (String[])fields, (Object[])new Object[]{"E5", 50});
        clientOne.send((Object)this.getMapEvent(mapTypeName, "E6", 60));
        Thread.sleep(200L);
        ArrayAssertionUtil.assertProps((EventBean)this.listener.assertOneGetNewAndReset(), (String[])fields, (Object[])new Object[]{"E6", 60});
        clientOne.close();
        clientTwo.close();
        provider.destroy();
    }

    private Map<String, Object> getMapType() {
        HashMap<String, Object> type = new HashMap<String, Object>();
        type.put("stringProp", String.class);
        type.put("intProp", Integer.TYPE);
        return type;
    }

    private Map<String, Object> getMapEvent(String typeName, String s, int v) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("stream", typeName);
        data.put("stringProp", s);
        data.put("intProp", v);
        return data;
    }
}

