/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esperio.socket.config;

import com.espertech.esperio.socket.config.ConfigurationSocketAdapterParser;
import com.espertech.esperio.socket.config.SocketConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ConfigurationSocketAdapter {
    private static Log log = LogFactory.getLog(ConfigurationSocketAdapter.class);
    private Map<String, SocketConfig> sockets = new HashMap();

    public Map<String, SocketConfig> getSockets() {
        return this.sockets;
    }

    public void setSockets(Map<String, SocketConfig> sockets) {
        this.sockets = sockets;
    }

    public ConfigurationSocketAdapter configure() throws RuntimeException {
        this.configure("/esperio.socket.cfg.xml");
        return this;
    }

    public ConfigurationSocketAdapter configure(String resource) throws RuntimeException {
        if (log.isInfoEnabled()) {
            log.info("Configuring from resource: " + resource);
        }
        InputStream stream = ConfigurationSocketAdapter.getConfigurationInputStream((String)resource);
        ConfigurationSocketAdapterParser.doConfigure((ConfigurationSocketAdapter)this, (InputStream)stream, (String)resource);
        return this;
    }

    protected static InputStream getConfigurationInputStream(String resource) throws RuntimeException {
        return ConfigurationSocketAdapter.getResourceAsStream((String)resource);
    }

    public ConfigurationSocketAdapter configureFromString(String xml) throws RuntimeException {
        if (log.isInfoEnabled()) {
            log.info("Configuring from string");
        }
        try {
            InputSource source = new InputSource(new StringReader(xml));
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            Document doc = builderFactory.newDocumentBuilder().parse(source);
            ConfigurationSocketAdapterParser.doConfigure((ConfigurationSocketAdapter)this, (Document)doc);
            return this;
        }
        catch (IOException ioe) {
            throw new RuntimeException("could not configure from String: " + ioe.getMessage(), ioe);
        }
        catch (SAXException e) {
            throw new RuntimeException("could not configure from String: " + e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("could not configure from String: " + e.getMessage(), e);
        }
    }

    public ConfigurationSocketAdapter configure(URL url) throws RuntimeException {
        if (log.isInfoEnabled()) {
            log.info("Configuring from url: " + url.toString());
        }
        try {
            ConfigurationSocketAdapterParser.doConfigure((ConfigurationSocketAdapter)this, (InputStream)url.openStream(), (String)url.toString());
            return this;
        }
        catch (IOException ioe) {
            throw new RuntimeException("could not configure from URL: " + url, ioe);
        }
    }

    protected static InputStream getResourceAsStream(String resource) {
        String stripped = resource.startsWith("/") ? resource.substring(1) : resource;
        InputStream stream = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            stream = classLoader.getResourceAsStream(stripped);
        }
        if (stream == null) {
            stream = ConfigurationSocketAdapter.class.getResourceAsStream(resource);
        }
        if (stream == null) {
            stream = ConfigurationSocketAdapter.class.getClassLoader().getResourceAsStream(stripped);
        }
        if (stream == null) {
            throw new RuntimeException(resource + " not found");
        }
        return stream;
    }

    public ConfigurationSocketAdapter configure(File configFile) throws RuntimeException {
        if (log.isDebugEnabled()) {
            log.debug("configuring from file: " + configFile.getName());
        }
        try {
            ConfigurationSocketAdapterParser.doConfigure((ConfigurationSocketAdapter)this, (InputStream)new FileInputStream(configFile), (String)configFile.toString());
        }
        catch (FileNotFoundException fnfe) {
            throw new RuntimeException("could not find file: " + configFile, fnfe);
        }
        return this;
    }
}

