/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esperio.socket.config;

import com.espertech.esper.client.ConfigurationException;
import com.espertech.esper.util.DOMElementIterator;
import com.espertech.esperio.socket.config.ConfigurationSocketAdapter;
import com.espertech.esperio.socket.config.DataType;
import com.espertech.esperio.socket.config.SocketConfig;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConfigurationSocketAdapterParser {
    private static Log log = LogFactory.getLog(ConfigurationSocketAdapterParser.class);

    protected static void doConfigure(ConfigurationSocketAdapter configuration, InputStream stream, String resourceName) throws RuntimeException {
        Document document = ConfigurationSocketAdapterParser.getDocument((InputStream)stream, (String)resourceName);
        ConfigurationSocketAdapterParser.doConfigure((ConfigurationSocketAdapter)configuration, (Document)document);
    }

    protected static Document getDocument(InputStream stream, String resourceName) throws RuntimeException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(stream);
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("Could not get a DOM parser configuration: " + resourceName, ex);
        }
        catch (SAXException ex) {
            throw new RuntimeException("Could not parse configuration: " + resourceName, ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not read configuration: " + resourceName, ex);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ioe) {
                log.warn("could not close input stream for: " + resourceName, ioe);
            }
        }
        return document;
    }

    protected static void doConfigure(ConfigurationSocketAdapter configuration, Document doc) throws RuntimeException {
        Element root = doc.getDocumentElement();
        DOMElementIterator eventTypeNodeIterator = new DOMElementIterator(root.getChildNodes());
        while (eventTypeNodeIterator.hasNext()) {
            Element element = eventTypeNodeIterator.next();
            String nodeName = element.getNodeName();
            if (!nodeName.equals("socket")) continue;
            ConfigurationSocketAdapterParser.handleSocket((ConfigurationSocketAdapter)configuration, (Node)element);
        }
    }

    private static void handleSocket(ConfigurationSocketAdapter configuration, Node node) {
        String name = ConfigurationSocketAdapterParser.getRequiredAttribute((Node)node, (String)"name");
        String port = ConfigurationSocketAdapterParser.getRequiredAttribute((Node)node, (String)"port");
        String dataType = ConfigurationSocketAdapterParser.getRequiredAttribute((Node)node, (String)"data");
        SocketConfig socketConfig = new SocketConfig();
        socketConfig.setPort(Integer.parseInt(port));
        socketConfig.setDataType(DataType.valueOf((String)dataType.toUpperCase()));
        configuration.getSockets().put(name, socketConfig);
    }

    protected static InputStream getResourceAsStream(String resource) {
        String stripped = resource.startsWith("/") ? resource.substring(1) : resource;
        InputStream stream = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            stream = classLoader.getResourceAsStream(stripped);
        }
        if (stream == null) {
            ConfigurationSocketAdapterParser.class.getResourceAsStream(resource);
        }
        if (stream == null) {
            stream = ConfigurationSocketAdapterParser.class.getClassLoader().getResourceAsStream(stripped);
        }
        if (stream == null) {
            throw new RuntimeException(resource + " not found");
        }
        return stream;
    }

    private static String getOptionalAttribute(Node node, String key) {
        Node valueNode = node.getAttributes().getNamedItem(key);
        if (valueNode != null) {
            return valueNode.getTextContent();
        }
        return null;
    }

    private static String getRequiredAttribute(Node node, String key) {
        Node valueNode = node.getAttributes().getNamedItem(key);
        if (valueNode == null) {
            throw new ConfigurationException("Required attribute by name '" + key + "' not found");
        }
        return valueNode.getTextContent();
    }
}

