/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esperio.socket.core;

import com.espertech.esper.core.EPServiceProviderSPI;
import com.espertech.esperio.socket.config.SocketConfig;
import com.espertech.esperio.socket.core.EsperSocketServiceRunnable;
import java.io.IOException;
import java.net.ServerSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EsperSocketService {
    private static Log log = LogFactory.getLog(EsperSocketService.class);
    private final String serviceName;
    private final SocketConfig serviceConfig;
    private ServerSocket serverSocket;
    private EsperSocketServiceRunnable runnable;
    private Thread socketThread;

    public EsperSocketService(String serviceName, SocketConfig serviceConfig) {
        this.serviceName = serviceName;
        this.serviceConfig = serviceConfig;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void start(String serviceName, EPServiceProviderSPI engineSPI) throws IOException {
        log.info("Esper socket adapter accepting connections on port " + this.serviceConfig.getPort() + " for socket named '" + serviceName + "'");
        this.serverSocket = new ServerSocket(this.serviceConfig.getPort());
        this.runnable = new EsperSocketServiceRunnable(this.getServiceName(), this.serviceConfig.getDataType(), this.serverSocket, engineSPI);
        this.socketThread = new Thread((Runnable)this.runnable);
        this.socketThread.setDaemon(true);
        this.socketThread.start();
    }

    public void destroy() {
        log.info("Closing existing workers for service '" + this.getServiceName() + "'");
        this.runnable.destroy();
        log.info("Closing server socket for service '" + this.getServiceName() + "' and port " + this.serviceConfig.getPort());
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            log.debug("Error closing server socket: " + e.getMessage(), e);
        }
        log.info("Stopping socket thread for service '" + this.getServiceName() + "'");
        this.socketThread.interrupt();
        try {
            this.socketThread.join(10000L);
        }
        catch (InterruptedException e) {
            log.debug("Interrupted", e);
        }
    }
}

