/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esperio.socket.core;

import com.espertech.esper.core.EPServiceProviderSPI;
import com.espertech.esperio.socket.config.DataType;
import com.espertech.esperio.socket.core.WorkerThread;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EsperSocketServiceRunnable
implements Runnable {
    private static Log log = LogFactory.getLog(EsperSocketServiceRunnable.class);
    private String serviceName;
    private DataType dataType;
    private ServerSocket serversocket;
    private EPServiceProviderSPI engine;
    private List<WorkerThread> workers = new CopyOnWriteArrayList();
    private boolean shutdown;

    public EsperSocketServiceRunnable(String serviceName, DataType dataType, ServerSocket serversocket, EPServiceProviderSPI engine) {
        this.serviceName = serviceName;
        this.serversocket = serversocket;
        this.dataType = dataType;
        this.engine = engine;
    }

    public void run() {
        log.info("For service '" + this.serviceName + "' listening on port " + this.serversocket.getLocalPort() + " expecting data type " + (this.dataType == null ? DataType.OBJECT : this.dataType));
        while (!Thread.interrupted()) {
            try {
                Socket socket = this.serversocket.accept();
                log.info("Incoming connection service '" + this.serviceName + "' from " + socket.getInetAddress());
                WorkerThread t = new WorkerThread(this.serviceName, this.engine, this, socket, this.dataType);
                t.setDaemon(true);
                t.start();
                this.workers.add(t);
            }
            catch (InterruptedIOException ex) {
                break;
            }
            catch (IOException e) {
                if (this.shutdown) break;
                log.error("I/O error initialising connection thread for service '" + this.serviceName + "' : " + e.getMessage());
                break;
            }
        }
        log.info("For service '" + this.serviceName + "' listening on port " + this.serversocket.getLocalPort() + " ended socket thread.");
    }

    public void destroy() {
        log.info("Stopping worker threads for service '" + this.serviceName + "'");
        this.shutdown = true;
        for (WorkerThread worker : this.workers) {
            worker.setShutdown(true);
            if (!worker.isAlive()) {
                worker.interrupt();
            }
            try {
                worker.join(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.workers.clear();
    }

    public void remove(WorkerThread workerThread) {
        this.workers.remove(workerThread);
    }
}

