/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esperio.socket.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.EPServiceProviderSPI;
import com.espertech.esper.epl.core.MethodResolutionServiceImpl;
import com.espertech.esper.event.EventBeanManufactureException;
import com.espertech.esper.event.EventBeanManufacturer;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.event.WriteablePropertyDescriptor;
import com.espertech.esper.util.SimpleTypeParser;
import com.espertech.esper.util.SimpleTypeParserFactory;
import com.espertech.esperio.socket.config.DataType;
import com.espertech.esperio.socket.core.EsperSocketServiceRunnable;
import com.espertech.esperio.socket.core.WStringTokenizer;
import com.espertech.esperio.socket.core.WriterCacheEntry;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WorkerThread
extends Thread {
    private static Log log = LogFactory.getLog(WorkerThread.class);
    private final EPServiceProviderSPI engine;
    private final EsperSocketServiceRunnable runnable;
    private final String serviceName;
    private final Socket socket;
    private final Map<String, WriterCacheEntry> streamCache = new HashMap();
    private final MethodResolutionServiceImpl methods;
    private ObjectInputStream ois;
    private BufferedReader br;
    private boolean isShutdown;

    public WorkerThread(String serviceName, EPServiceProviderSPI engine, EsperSocketServiceRunnable runnable, Socket socket, DataType dataType) throws IOException {
        this.serviceName = serviceName;
        this.engine = engine;
        this.runnable = runnable;
        this.socket = socket;
        this.methods = new MethodResolutionServiceImpl(engine.getEngineImportService(), engine.getTimeProvider(), false);
        if (dataType == null || dataType == DataType.OBJECT) {
            this.ois = new ObjectInputStream(socket.getInputStream());
        } else {
            this.br = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        }
    }

    public void setShutdown(boolean shutdown) {
        this.isShutdown = shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (!Thread.interrupted() && this.socket.isConnected()) {
                if (this.ois != null) {
                    Object object = this.ois.readObject();
                    this.handleObject(object);
                    continue;
                }
                String str = this.br.readLine();
                this.handleString(str);
            }
        }
        catch (EOFException ex) {
            log.debug("EOF received from connection");
        }
        catch (IOException ex) {
            if (!this.isShutdown) {
                log.error("I/O error: " + ex.getMessage(), ex);
            }
        }
        catch (ClassNotFoundException ex) {
            log.error("Class not found: " + ex.getMessage());
        }
        finally {
            try {
                this.socket.close();
                this.runnable.remove(this);
            }
            catch (IOException ignore) {}
        }
    }

    private void handleObject(Object input) {
        try {
            if (input instanceof Map) {
                Map map = (Map)input;
                String type = (String)map.get("stream");
                if (type == null) {
                    log.warn("Expected value for event type not found in map event provided to adapter");
                    return;
                }
                this.engine.getEPRuntime().sendEvent(map, type);
            } else {
                this.engine.getEPRuntime().sendEvent(input);
            }
        }
        catch (Throwable t) {
            log.error("Unexpected exception encountered sending event " + input + " service '" + this.serviceName + "' :" + t.getMessage(), t);
        }
    }

    private void handleString(String input) {
        if (input == null) {
            return;
        }
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            WStringTokenizer tokenizer = new WStringTokenizer(input, ",");
            while (tokenizer.hasMoreTokens()) {
                String item = tokenizer.nextToken();
                int index = item.indexOf("=");
                if (index == -1) continue;
                parameters.put(item.substring(0, index), item.substring(index + 1, item.length()));
            }
            String eventTypeName = (String)parameters.get("stream");
            WriterCacheEntry cacheEntry = (WriterCacheEntry)this.streamCache.get(eventTypeName);
            if (cacheEntry == null) {
                cacheEntry = this.makeCacheEntry(eventTypeName);
                this.streamCache.put(eventTypeName, cacheEntry);
            }
            if (cacheEntry == null) {
                return;
            }
            Object[] values = new Object[cacheEntry.getParsers().length];
            for (int i = 0; i < cacheEntry.getParsers().length; ++i) {
                String value = (String)parameters.get(cacheEntry.getWritableProperties()[i].getPropertyName());
                if (value == null) continue;
                values[i] = cacheEntry.getParsers()[i].parse(value);
            }
            EventBean event = cacheEntry.getEventBeanManufacturer().make(values);
            this.engine.getEPRuntime().sendEvent(event);
        }
        catch (Throwable t) {
            log.error("Unexpected exception encountered sending event " + input + " service '" + this.serviceName + "' :" + t.getMessage(), t);
        }
    }

    private WriterCacheEntry makeCacheEntry(String eventTypeName) {
        EventBeanManufacturer eventBeanManufacturer;
        EventType eventType = this.engine.getEventAdapterService().getExistsTypeByName(eventTypeName);
        if (eventType == null) {
            log.info("Event type by name '" + eventTypeName + "' not found.");
            return null;
        }
        if (!(eventType instanceof EventTypeSPI)) {
            log.info("Event type by name '" + eventTypeName + "' is not writable.");
            return null;
        }
        EventTypeSPI eventTypeSPI = (EventTypeSPI)eventType;
        Set<WriteablePropertyDescriptor> writablesSet = this.engine.getEventAdapterService().getWriteableProperties(eventTypeSPI);
        ArrayList<WriteablePropertyDescriptor> writablePropertiesList = new ArrayList<WriteablePropertyDescriptor>();
        ArrayList<SimpleTypeParser> parserList = new ArrayList<SimpleTypeParser>();
        for (WriteablePropertyDescriptor writableDesc : writablesSet) {
            SimpleTypeParser parser2 = SimpleTypeParserFactory.getParser(writableDesc.getType());
            if (parser2 == null) {
                log.debug("No parser found for type '" + writableDesc.getType() + "'");
                continue;
            }
            writablePropertiesList.add(writableDesc);
            parserList.add(parser2);
        }
        WriteablePropertyDescriptor[] writableProperties = writablePropertiesList.toArray(new WriteablePropertyDescriptor[writablePropertiesList.size()]);
        SimpleTypeParser[] parsers = parserList.toArray(new SimpleTypeParser[parserList.size()]);
        try {
            eventBeanManufacturer = this.engine.getEventAdapterService().getManufacturer(eventType, writableProperties, this.methods);
        }
        catch (EventBeanManufactureException e) {
            log.info("Unable to create manufacturer for event type: " + e.getMessage(), e);
            return null;
        }
        return new WriterCacheEntry(eventBeanManufacturer, writableProperties, parsers);
    }
}

