/*
 * Decompiled with CFR 0.152.
 */
package com.scalagent.joram.mom.dest.collector;

import com.scalagent.joram.mom.dest.collector.Collector;
import com.scalagent.joram.mom.dest.collector.CollectorDestination;
import com.scalagent.joram.mom.dest.collector.CollectorHelper;
import com.scalagent.joram.mom.dest.collector.CollectorQueueImplMBean;
import com.scalagent.joram.mom.dest.collector.CollectorWakeUpNot;
import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.agent.WakeUpTask;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.objectweb.joram.mom.dest.QueueImpl;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class CollectorQueueImpl
extends QueueImpl
implements CollectorDestination,
CollectorQueueImplMBean {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger(CollectorQueueImpl.class.getName());
    public static final String DEFAULT_COLLECTOR = "com.scalagent.joram.mom.dest.collector.URLCollector";
    private Properties prop = null;
    private Collector collector;
    private long messageExpiration = 0L;
    private boolean messagePersistent = true;
    private long count = 0L;
    private WakeUpTask task;

    public CollectorQueueImpl(AgentId adminId, Properties prop) {
        super(adminId, prop);
        this.prop = prop;
        this.setMessageExpiration(prop.getProperty("collector.expirationMessage"));
        this.setMessagePersistent(prop.getProperty("collector.persistentMessage"));
        String className = prop.getProperty("collector.ClassName", DEFAULT_COLLECTOR);
        try {
            Class<?> clazz = Class.forName(className);
            this.collector = (Collector)clazz.newInstance();
            this.collector.setCollectorDestination(this);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("CollectorQueueImpl.<init> prop = " + prop + ", collector = " + this.collector));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void initialize(boolean firstTime) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("CollectorQueueImpl.initialize(" + firstTime + ')'));
        }
        super.initialize(firstTime);
        if (firstTime) {
            this.task = new WakeUpTask(this.getId(), CollectorWakeUpNot.class);
            this.collectorWakeUp();
        }
    }

    public void setProperties(Properties prop) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("CollectorQueueImpl.setProperties(" + prop + ')'));
        }
        String period = this.prop.getProperty("collector.period");
        this.prop = prop;
        this.setMessageExpiration(prop.getProperty("collector.expirationMessage"));
        this.setMessagePersistent(prop.getProperty("collector.persistentMessage"));
        if (!period.equals(prop.getProperty("collector.period"))) {
            this.collectorWakeUp();
        }
    }

    public void setProperty(String key, String value) {
        if (this.prop == null) {
            return;
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("setProperty(" + key + ", " + value + ')'));
        }
        if (key.equals("collector.period")) {
            if (!value.equals(this.prop.getProperty("collector.period"))) {
                this.prop.setProperty(key, value);
                this.collectorWakeUp();
            }
        } else {
            this.prop.setProperty(key, value);
            this.setProperties(this.prop);
        }
    }

    public void setMessageExpiration(String expiration) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("CollectorQueueImpl.setMessageExpiration(" + expiration + ')'));
        }
        if (expiration != null) {
            this.messageExpiration = Long.valueOf(expiration);
        }
    }

    public void setMessagePersistent(String persistent) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("CollectorQueueImpl.setMessagePersistent(" + persistent + ')'));
        }
        if (persistent != null) {
            this.messagePersistent = Boolean.valueOf(persistent);
        }
    }

    public String getCollectorPeriod() {
        return this.prop.getProperty("collector.period");
    }

    public void collectorWakeUp() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"CollectorQueueImpl.collectorWakeUp()");
        }
        try {
            this.collector.check();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        CollectorHelper.scheduleTask(this.task, this.getCollectorPeriod());
    }

    public ClientMessages preProcess(AgentId from, ClientMessages msgs) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Change collector properties. preProcess(" + from + ", " + msgs + ')'));
        }
        Properties prop = new Properties();
        try {
            Message msg = (Message)msgs.getMessages().get(msgs.getMessages().size() - 1);
            if (msg.properties != null) {
                Enumeration enumProperties = msg.properties.keys();
                while (enumProperties.hasMoreElements()) {
                    String key = (String)enumProperties.nextElement();
                    Object value = msg.properties.get(key);
                    prop.put(key, value);
                }
            }
            if (prop != null && !prop.isEmpty()) {
                CollectorHelper.cancelTask(this.task);
                this.task = new WakeUpTask(this.getId(), CollectorWakeUpNot.class);
                this.setProperties(prop);
            }
            return null;
        }
        catch (Exception e) {
            return msgs;
        }
    }

    public void storeClientMessage(ClientMessages clientMsgs) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("CollectorQueueImpl.storeClientMessage(" + clientMsgs + ')'));
        }
        if (clientMsgs != null) {
            Enumeration msgs = clientMsgs.getMessages().elements();
            while (msgs.hasMoreElements()) {
                org.objectweb.joram.mom.messages.Message msg = new org.objectweb.joram.mom.messages.Message((Message)msgs.nextElement());
                ++this.arrivalsCounter;
                msg.order = msg.order;
                this.storeMessage(msg);
            }
        }
        this.deliverMessages(0);
    }

    public Properties getProperties() {
        return this.prop;
    }

    public void sendMessage(int type, byte[] body, org.objectweb.joram.shared.util.Properties properties) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("CollectorQueueImpl.sendMessage(" + type + ", " + body + ", " + properties + ')'));
        }
        Message msg = CollectorHelper.createMessage(type, body, properties, this.messageExpiration, this.messagePersistent, "collectorQueue_" + this.count);
        ++this.count;
        ClientMessages clientMsgs = CollectorHelper.createClientMessages(msg);
        this.storeClientMessage(clientMsgs);
    }
}

