/*
 * Decompiled with CFR 0.152.
 */
package com.scalagent.joram.mom.dest.ftp;

import com.scalagent.joram.mom.dest.ftp.FtpMessage;
import com.scalagent.joram.mom.dest.ftp.FtpNot;
import com.scalagent.joram.mom.dest.ftp.TransferItf;
import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.Debug;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import org.objectweb.joram.mom.util.DMQManager;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class FtpThread
extends Thread {
    public static Logger logger = Debug.getLogger(FtpThread.class.getName());
    private TransferItf transfer;
    private AgentId destId;
    private FtpMessage ftpMsg;
    private AgentId dmqId;
    private int clientContext;
    private int requestId;
    private String user;
    private String pass;
    private String path;
    public String ftpImplName;

    public FtpThread(TransferItf transfer, FtpMessage ftpMsg, AgentId destId, AgentId dmqId, int clientContext, int requestId, String user, String pass, String path) {
        this.transfer = transfer;
        this.ftpMsg = ftpMsg;
        this.destId = destId;
        this.dmqId = dmqId;
        this.clientContext = clientContext;
        this.requestId = requestId;
        this.user = user;
        this.pass = pass;
        this.path = path;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this));
        }
    }

    public void run() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"--- run()");
        }
        this.doFtp(this.ftpMsg);
    }

    protected void doFtp(FtpMessage msg) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("doFtp(" + msg + ')'));
        }
        String urlName = null;
        long crc = -1L;
        boolean ack = false;
        try {
            urlName = msg.getStringProperty("url");
            crc = msg.getLongProperty("crc");
            ack = msg.getBooleanProperty("ack");
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("doFtp urlName = " + urlName + ", crc = " + crc + ", ack = " + ack));
            }
            URL url = new URL(urlName);
            String urlFileName = url.getFile();
            String fileName = null;
            String type = null;
            String remotePath = null;
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("--- doFtp : url host = " + url.getHost() + ", urlFileName = " + urlFileName));
            }
            if (urlFileName.indexOf(";") > 1) {
                fileName = urlFileName.substring(urlFileName.lastIndexOf(47) + 1, urlFileName.indexOf(";"));
                type = urlFileName.substring(urlFileName.lastIndexOf("=") + 1, urlFileName.length());
            } else {
                fileName = urlFileName.substring(urlFileName.lastIndexOf(47) + 1, urlFileName.length());
            }
            if (urlFileName.indexOf(47) < urlFileName.lastIndexOf(47)) {
                remotePath = urlFileName.substring(urlFileName.indexOf(47) + 1, urlFileName.lastIndexOf(47));
            }
            String userInfo = url.getUserInfo();
            String remoteUser = this.user;
            String remotePass = this.pass;
            if (userInfo != null) {
                remoteUser = userInfo.substring(0, userInfo.indexOf(58));
                remotePass = userInfo.substring(userInfo.indexOf(58) + 1, userInfo.length());
            }
            String protocol = url.getProtocol();
            int port = url.getPort();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("doFtp : remoteUser = " + remoteUser + ", protocol = " + protocol + ", port = " + port));
            }
            String file = this.transfer.getFile(protocol, InetAddress.getByName(url.getHost()).getHostName(), port, remoteUser, remotePass, remotePath, this.path, fileName, fileName, type, crc);
            if (!(file = file.replace('\\', '/')).startsWith("/")) {
                file = "/" + file;
            }
            URI uri = new URI("file", null, file, null, null);
            uri = uri.normalize();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("--- doFtp : uri = " + uri));
            }
            FtpMessage clone = (FtpMessage)msg.clone();
            clone.clearProperties();
            Enumeration e = msg.getPropertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                clone.setObjectProperty(key, msg.getObjectProperty(key));
            }
            clone.setStringProperty("url", uri.toString());
            Channel.sendTo(this.destId, new FtpNot(this.clientContext, this.requestId, clone.getSharedMessage()));
        }
        catch (Exception exc) {
            DMQManager dmqManager = new DMQManager(this.dmqId, this.destId);
            dmqManager.addDeadMessage(msg.getSharedMessage(), (short)6);
            dmqManager.sendToDMQ();
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("FtpThread (");
        buf.append("transfer=");
        buf.append(this.transfer);
        buf.append(", ftpMsg=");
        buf.append(this.ftpMsg);
        buf.append(", destId=");
        buf.append(this.destId);
        buf.append(", dmqId=");
        buf.append(this.dmqId);
        buf.append(", clientContext=");
        buf.append(this.clientContext);
        buf.append(", requestId=");
        buf.append(this.requestId);
        buf.append(", user=");
        buf.append(this.user);
        buf.append(", pass=***");
        buf.append(", path=");
        buf.append(this.path);
        buf.append(")");
        return buf.toString();
    }
}

