/*
 * Decompiled with CFR 0.152.
 */
package com.scalagent.joram.mom.dest.scheduler;

import com.scalagent.joram.mom.dest.scheduler.SchedulerQueueNot;
import com.scalagent.joram.mom.dest.scheduler.SchedulerQueueTask;
import com.scalagent.scheduler.ScheduleEvent;
import com.scalagent.scheduler.Scheduler;
import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Debug;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import org.objectweb.joram.mom.dest.QueueImpl;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class SchedulerQueueImpl
extends QueueImpl {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger("com.scalagent.joram.scheduler.SchedulerQueueImpl");
    public static final String SCHEDULE_DATE = "scheduleDate";
    public static final String SCHEDULED = "scheduled";
    private Scheduler scheduler = null;

    public SchedulerQueueImpl(AgentId adminId, Properties prop) {
        super(adminId, prop);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("SchedulerQueueImpl.<init>(" + this.getId() + ',' + adminId + ')'));
        }
    }

    public void postProcess(ClientMessages not) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("SchedulerQueueImpl.postProcess(" + not + ')'));
        }
        Enumeration msgs = not.getMessages().elements();
        while (msgs.hasMoreElements()) {
            Message msg = (Message)msgs.nextElement();
            long scheduleDate = SchedulerQueueImpl.getScheduleDate(msg);
            if (scheduleDate < 0L) {
                return;
            }
            try {
                if (this.scheduler == null) {
                    this.scheduler = new Scheduler(AgentServer.getTimer());
                }
                this.scheduler.scheduleEvent(new ScheduleEvent(msg.id, new Date(scheduleDate)), new SchedulerQueueTask(this.getId()));
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.ERROR)) continue;
                logger.log(BasicLevel.ERROR, (Object)("EXCEPTION :: SchedulerQueueImpl.postProcess(" + not + ')'), (Throwable)e);
            }
        }
    }

    private static long getScheduleDate(Message msg) {
        Object scheduleDateValue = msg.getProperty(SCHEDULE_DATE);
        if (scheduleDateValue == null) {
            return -1L;
        }
        try {
            return (Long)scheduleDateValue;
        }
        catch (Exception exc) {
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, (Object)"Scheduled message error", (Throwable)exc);
            }
            return -1L;
        }
    }

    public void condition(SchedulerQueueNot not) {
        String msgId = not.name;
        for (int i = 0; i < this.messages.size(); ++i) {
            org.objectweb.joram.mom.messages.Message msg = (org.objectweb.joram.mom.messages.Message)this.messages.elementAt(i);
            if (!msg.getIdentifier().equals(msgId)) continue;
            try {
                msg.setObjectProperty(SCHEDULED, "" + System.currentTimeMillis());
            }
            catch (Exception exc) {}
            break;
        }
        this.deliverMessages(0);
    }

    protected boolean checkDelivery(Message msg) {
        long scheduleDate;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("SchedulerQueueImpl.checkDelivery(" + msg + ')'));
        }
        if ((scheduleDate = SchedulerQueueImpl.getScheduleDate(msg)) < 0L) {
            return true;
        }
        long currentTime = System.currentTimeMillis();
        return scheduleDate <= currentTime;
    }
}

