/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime;

import org.antlr.runtime.BaseRecognizer;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.EarlyExitException;
import org.antlr.runtime.MismatchedNotSetException;
import org.antlr.runtime.MismatchedRangeException;
import org.antlr.runtime.MismatchedSetException;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;

public abstract class Lexer
extends BaseRecognizer
implements TokenSource {
    protected CharStream input;

    public Lexer() {
    }

    public Lexer(CharStream charStream) {
        this.input = charStream;
    }

    public Lexer(CharStream charStream, RecognizerSharedState recognizerSharedState) {
        super(recognizerSharedState);
        this.input = charStream;
    }

    public void reset() {
        super.reset();
        if (this.input != null) {
            this.input.seek(0);
        }
        if (this.state == null) {
            return;
        }
        this.state.token = null;
        this.state.type = 0;
        this.state.channel = 0;
        this.state.tokenStartCharIndex = -1;
        this.state.tokenStartCharPositionInLine = -1;
        this.state.tokenStartLine = -1;
        this.state.text = null;
    }

    public Token nextToken() {
        while (true) {
            this.state.token = null;
            this.state.channel = 0;
            this.state.tokenStartCharIndex = this.input.index();
            this.state.tokenStartCharPositionInLine = this.input.getCharPositionInLine();
            this.state.tokenStartLine = this.input.getLine();
            this.state.text = null;
            if (this.input.LA(1) == -1) {
                return Token.EOF_TOKEN;
            }
            try {
                this.mTokens();
                if (this.state.token == null) {
                    this.emit();
                } else if (this.state.token == Token.SKIP_TOKEN) continue;
                return this.state.token;
            }
            catch (NoViableAltException noViableAltException) {
                this.reportError(noViableAltException);
                this.recover(noViableAltException);
                continue;
            }
            catch (RecognitionException recognitionException) {
                this.reportError(recognitionException);
                continue;
            }
            break;
        }
    }

    public void skip() {
        this.state.token = Token.SKIP_TOKEN;
    }

    public abstract void mTokens() throws RecognitionException;

    public void setCharStream(CharStream charStream) {
        this.input = null;
        this.reset();
        this.input = charStream;
    }

    public CharStream getCharStream() {
        return this.input;
    }

    public String getSourceName() {
        return this.input.getSourceName();
    }

    public void emit(Token token2) {
        this.state.token = token2;
    }

    public Token emit() {
        CommonToken commonToken = new CommonToken(this.input, this.state.type, this.state.channel, this.state.tokenStartCharIndex, this.getCharIndex() - 1);
        commonToken.setLine(this.state.tokenStartLine);
        commonToken.setText(this.state.text);
        commonToken.setCharPositionInLine(this.state.tokenStartCharPositionInLine);
        this.emit(commonToken);
        return commonToken;
    }

    public void match(String string) throws MismatchedTokenException {
        for (int i = 0; i < string.length(); ++i) {
            if (this.input.LA(1) != string.charAt(i)) {
                if (this.state.backtracking > 0) {
                    this.state.failed = true;
                    return;
                }
                MismatchedTokenException mismatchedTokenException = new MismatchedTokenException(string.charAt(i), this.input);
                this.recover(mismatchedTokenException);
                throw mismatchedTokenException;
            }
            this.input.consume();
            this.state.failed = false;
        }
    }

    public void matchAny() {
        this.input.consume();
    }

    public void match(int n) throws MismatchedTokenException {
        if (this.input.LA(1) != n) {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            MismatchedTokenException mismatchedTokenException = new MismatchedTokenException(n, this.input);
            this.recover(mismatchedTokenException);
            throw mismatchedTokenException;
        }
        this.input.consume();
        this.state.failed = false;
    }

    public void matchRange(int n, int n2) throws MismatchedRangeException {
        if (this.input.LA(1) < n || this.input.LA(1) > n2) {
            if (this.state.backtracking > 0) {
                this.state.failed = true;
                return;
            }
            MismatchedRangeException mismatchedRangeException = new MismatchedRangeException(n, n2, this.input);
            this.recover(mismatchedRangeException);
            throw mismatchedRangeException;
        }
        this.input.consume();
        this.state.failed = false;
    }

    public int getLine() {
        return this.input.getLine();
    }

    public int getCharPositionInLine() {
        return this.input.getCharPositionInLine();
    }

    public int getCharIndex() {
        return this.input.index();
    }

    public String getText() {
        if (this.state.text != null) {
            return this.state.text;
        }
        return this.input.substring(this.state.tokenStartCharIndex, this.getCharIndex() - 1);
    }

    public void setText(String string) {
        this.state.text = string;
    }

    public void reportError(RecognitionException recognitionException) {
        this.displayRecognitionError(this.getTokenNames(), recognitionException);
    }

    public String getErrorMessage(RecognitionException recognitionException, String[] stringArray) {
        String string = null;
        if (recognitionException instanceof MismatchedTokenException) {
            MismatchedTokenException mismatchedTokenException = (MismatchedTokenException)recognitionException;
            string = "mismatched character " + this.getCharErrorDisplay(recognitionException.c) + " expecting " + this.getCharErrorDisplay(mismatchedTokenException.expecting);
        } else if (recognitionException instanceof NoViableAltException) {
            NoViableAltException noViableAltException = (NoViableAltException)recognitionException;
            string = "no viable alternative at character " + this.getCharErrorDisplay(recognitionException.c);
        } else if (recognitionException instanceof EarlyExitException) {
            EarlyExitException earlyExitException = (EarlyExitException)recognitionException;
            string = "required (...)+ loop did not match anything at character " + this.getCharErrorDisplay(recognitionException.c);
        } else if (recognitionException instanceof MismatchedNotSetException) {
            MismatchedNotSetException mismatchedNotSetException = (MismatchedNotSetException)recognitionException;
            string = "mismatched character " + this.getCharErrorDisplay(recognitionException.c) + " expecting set " + mismatchedNotSetException.expecting;
        } else if (recognitionException instanceof MismatchedSetException) {
            MismatchedSetException mismatchedSetException = (MismatchedSetException)recognitionException;
            string = "mismatched character " + this.getCharErrorDisplay(recognitionException.c) + " expecting set " + mismatchedSetException.expecting;
        } else if (recognitionException instanceof MismatchedRangeException) {
            MismatchedRangeException mismatchedRangeException = (MismatchedRangeException)recognitionException;
            string = "mismatched character " + this.getCharErrorDisplay(recognitionException.c) + " expecting set " + this.getCharErrorDisplay(mismatchedRangeException.a) + ".." + this.getCharErrorDisplay(mismatchedRangeException.b);
        } else {
            string = super.getErrorMessage(recognitionException, stringArray);
        }
        return string;
    }

    public String getCharErrorDisplay(int n) {
        String string = String.valueOf((char)n);
        switch (n) {
            case -1: {
                string = "<EOF>";
                break;
            }
            case 10: {
                string = "\\n";
                break;
            }
            case 9: {
                string = "\\t";
                break;
            }
            case 13: {
                string = "\\r";
            }
        }
        return "'" + string + "'";
    }

    public void recover(RecognitionException recognitionException) {
        this.input.consume();
    }

    public void traceIn(String string, int n) {
        String string2 = (char)this.input.LT(1) + " line=" + this.getLine() + ":" + this.getCharPositionInLine();
        super.traceIn(string, n, string2);
    }

    public void traceOut(String string, int n) {
        String string2 = (char)this.input.LT(1) + " line=" + this.getLine() + ":" + this.getCharPositionInLine();
        super.traceOut(string, n, string2);
    }
}

