/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.debug;

import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.debug.DebugEventListener;
import org.antlr.runtime.tree.TreeAdaptor;

public class DebugTreeAdaptor
implements TreeAdaptor {
    protected DebugEventListener dbg;
    protected TreeAdaptor adaptor;

    public DebugTreeAdaptor(DebugEventListener debugEventListener, TreeAdaptor treeAdaptor) {
        this.dbg = debugEventListener;
        this.adaptor = treeAdaptor;
    }

    public Object create(Token token2) {
        if (token2.getTokenIndex() < 0) {
            return this.create(token2.getType(), token2.getText());
        }
        Object object = this.adaptor.create(token2);
        this.dbg.createNode(object, token2);
        return object;
    }

    public Object errorNode(TokenStream tokenStream, Token token2, Token token3, RecognitionException recognitionException) {
        Object object = this.adaptor.errorNode(tokenStream, token2, token3, recognitionException);
        if (object != null) {
            this.dbg.errorNode(object);
        }
        return object;
    }

    public Object dupTree(Object object) {
        Object object2 = this.adaptor.dupTree(object);
        this.simulateTreeConstruction(object2);
        return object2;
    }

    protected void simulateTreeConstruction(Object object) {
        this.dbg.createNode(object);
        int n = this.adaptor.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = this.adaptor.getChild(object, i);
            this.simulateTreeConstruction(object2);
            this.dbg.addChild(object, object2);
        }
    }

    public Object dupNode(Object object) {
        Object object2 = this.adaptor.dupNode(object);
        this.dbg.createNode(object2);
        return object2;
    }

    public Object nil() {
        Object object = this.adaptor.nil();
        this.dbg.nilNode(object);
        return object;
    }

    public boolean isNil(Object object) {
        return this.adaptor.isNil(object);
    }

    public void addChild(Object object, Object object2) {
        if (object == null || object2 == null) {
            return;
        }
        this.adaptor.addChild(object, object2);
        this.dbg.addChild(object, object2);
    }

    public Object becomeRoot(Object object, Object object2) {
        Object object3 = this.adaptor.becomeRoot(object, object2);
        this.dbg.becomeRoot(object, object2);
        return object3;
    }

    public Object rulePostProcessing(Object object) {
        return this.adaptor.rulePostProcessing(object);
    }

    public void addChild(Object object, Token token2) {
        Object object2 = this.create(token2);
        this.addChild(object, object2);
    }

    public Object becomeRoot(Token token2, Object object) {
        Object object2 = this.create(token2);
        this.adaptor.becomeRoot(object2, object);
        this.dbg.becomeRoot(token2, object);
        return object2;
    }

    public Object create(int n, Token token2) {
        Object object = this.adaptor.create(n, token2);
        this.dbg.createNode(object);
        return object;
    }

    public Object create(int n, Token token2, String string) {
        Object object = this.adaptor.create(n, token2, string);
        this.dbg.createNode(object);
        return object;
    }

    public Object create(int n, String string) {
        Object object = this.adaptor.create(n, string);
        this.dbg.createNode(object);
        return object;
    }

    public int getType(Object object) {
        return this.adaptor.getType(object);
    }

    public void setType(Object object, int n) {
        this.adaptor.setType(object, n);
    }

    public String getText(Object object) {
        return this.adaptor.getText(object);
    }

    public void setText(Object object, String string) {
        this.adaptor.setText(object, string);
    }

    public Token getToken(Object object) {
        return this.adaptor.getToken(object);
    }

    public void setTokenBoundaries(Object object, Token token2, Token token3) {
        this.adaptor.setTokenBoundaries(object, token2, token3);
        if (object != null && token2 != null && token3 != null) {
            this.dbg.setTokenBoundaries(object, token2.getTokenIndex(), token3.getTokenIndex());
        }
    }

    public int getTokenStartIndex(Object object) {
        return this.adaptor.getTokenStartIndex(object);
    }

    public int getTokenStopIndex(Object object) {
        return this.adaptor.getTokenStopIndex(object);
    }

    public Object getChild(Object object, int n) {
        return this.adaptor.getChild(object, n);
    }

    public void setChild(Object object, int n, Object object2) {
        this.adaptor.setChild(object, n, object2);
    }

    public Object deleteChild(Object object, int n) {
        return this.deleteChild(object, n);
    }

    public int getChildCount(Object object) {
        return this.adaptor.getChildCount(object);
    }

    public int getUniqueID(Object object) {
        return this.adaptor.getUniqueID(object);
    }

    public Object getParent(Object object) {
        return this.adaptor.getParent(object);
    }

    public int getChildIndex(Object object) {
        return this.adaptor.getChildIndex(object);
    }

    public void setParent(Object object, Object object2) {
        this.adaptor.setParent(object, object2);
    }

    public void setChildIndex(Object object, int n) {
        this.adaptor.setChildIndex(object, n);
    }

    public void replaceChildren(Object object, int n, int n2, Object object2) {
        this.adaptor.replaceChildren(object, n, n2, object2);
    }

    public DebugEventListener getDebugListener() {
        return this.dbg;
    }

    public void setDebugListener(DebugEventListener debugEventListener) {
        this.dbg = debugEventListener;
    }

    public TreeAdaptor getTreeAdaptor() {
        return this.adaptor;
    }
}

