/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.net;

import java.util.Date;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.apache.log.format.Formatter;
import org.apache.log.output.AbstractOutputTarget;

public class SMTPOutputLogTarget
extends AbstractOutputTarget {
    private final Session m_session;
    private Message m_message;
    private final Address[] m_toAddresses;
    private final Address m_fromAddress;
    private final String m_subject;
    private int m_msgSize;
    private final int m_maxMsgSize;
    private StringBuffer m_buffer;

    public SMTPOutputLogTarget(Session session, Address[] toAddresses, Address fromAddress, String subject, int maxMsgSize, Formatter formatter) {
        super(formatter);
        this.m_maxMsgSize = maxMsgSize;
        this.m_toAddresses = toAddresses;
        this.m_fromAddress = fromAddress;
        this.m_subject = subject;
        this.m_session = session;
        this.open();
    }

    protected void write(String data) {
        try {
            if (this.m_message == null) {
                this.m_message = new MimeMessage(this.m_session);
                this.m_message.setFrom(this.m_fromAddress);
                this.m_message.setRecipients(Message.RecipientType.TO, this.m_toAddresses);
                this.m_message.setSubject(this.m_subject);
                this.m_message.setSentDate(new Date());
                this.m_msgSize = 0;
                this.m_buffer = new StringBuffer();
            }
            this.m_buffer.append(data);
            this.m_buffer.append('\n');
            ++this.m_msgSize;
            if (this.m_msgSize >= this.m_maxMsgSize) {
                this.send();
            }
        }
        catch (MessagingException e) {
            this.getErrorHandler().error("Error creating message", e, null);
        }
    }

    public synchronized void close() {
        super.close();
        this.send();
    }

    public void setDebug(boolean flag) {
        this.m_session.setDebug(flag);
    }

    private void send() {
        try {
            if (this.m_message != null && this.m_buffer != null) {
                this.m_message.setText(this.m_buffer.toString());
                Transport.send(this.m_message);
                this.m_message = null;
            }
        }
        catch (MessagingException e) {
            this.getErrorHandler().error("Error sending message", e, null);
        }
    }
}

