/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.admin;

import java.util.Hashtable;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.objectweb.joram.client.jms.FactoryParameters;
import org.objectweb.joram.client.jms.admin.AdministeredObject;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.joram.shared.security.Identity;
import org.objectweb.joram.shared.security.SimpleIdentity;
import org.objectweb.util.monolog.api.BasicLevel;

public abstract class AbstractConnectionFactory
extends AdministeredObject {
    protected FactoryParameters params;
    protected String reliableClass = null;
    protected Identity identity = null;
    protected String identityClassName = SimpleIdentity.class.getName();
    private boolean isSetIdentityClassName = false;
    static final String dfltRootLogin = "root";
    static final String dfltRootPassword = "root";
    static final String dfltLogin = "anonymous";
    static final String dfltPassword = "anonymous";

    public AbstractConnectionFactory(String host, int port) {
        this.params = new FactoryParameters(host, port);
        if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)(this + ": created."));
        }
    }

    public AbstractConnectionFactory(String url) {
        this.params = new FactoryParameters(url);
        if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)(this + ": created."));
        }
    }

    public AbstractConnectionFactory() {
        this.params = new FactoryParameters();
    }

    public void setIdentityClassName(String identityClassName) {
        this.identityClassName = identityClassName;
        this.isSetIdentityClassName = true;
    }

    protected void initIdentity(String user, String passwd) throws JMSException {
        if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)("initIdentity(" + user + ", ****)"));
        }
        try {
            if (!this.isSetIdentityClassName) {
                this.identityClassName = System.getProperty("org.objectweb.joram.Identity", SimpleIdentity.class.getName());
            }
            Class<?> clazz = Class.forName(this.identityClassName);
            this.identity = (Identity)clazz.newInstance();
            this.identity.setIdentity(user, passwd);
            if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)("initIdentity : identity = " + this.identity));
            }
        }
        catch (ClassNotFoundException e) {
            if (JoramTracing.dbgClient.isLoggable(BasicLevel.ERROR)) {
                JoramTracing.dbgClient.log(BasicLevel.ERROR, (Object)"EXCEPTION:: initIdentity", (Throwable)e);
            }
            throw new JMSException(e.getClass() + ":: " + e.getMessage());
        }
        catch (InstantiationException e) {
            if (JoramTracing.dbgClient.isLoggable(BasicLevel.ERROR)) {
                JoramTracing.dbgClient.log(BasicLevel.ERROR, (Object)"EXCEPTION:: initIdentity", (Throwable)e);
            }
            throw new JMSException(e.getClass() + ":: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            if (JoramTracing.dbgClient.isLoggable(BasicLevel.ERROR)) {
                JoramTracing.dbgClient.log(BasicLevel.ERROR, (Object)"EXCEPTION:: initIdentity", (Throwable)e);
            }
            throw new JMSException(e.getClass() + ":: " + e.getMessage());
        }
        catch (Exception e) {
            if (JoramTracing.dbgClient.isLoggable(BasicLevel.ERROR)) {
                JoramTracing.dbgClient.log(BasicLevel.ERROR, (Object)"EXCEPTION:: initIdentity", (Throwable)e);
            }
            throw new JMSException(e.getClass() + ":: " + e.getMessage());
        }
    }

    public void setReliableClass(String reliableClass) {
        this.reliableClass = reliableClass;
    }

    public static String getDefaultRootLogin() {
        return System.getProperty("JoramDfltRootLogin", "root");
    }

    public static String getDefaultRootPassword() {
        return System.getProperty("JoramDfltRootPassword", "root");
    }

    public static String getDefaultLogin() {
        return System.getProperty("JoramDfltLogin", "anonymous");
    }

    public static String getDefaultPassword() {
        return System.getProperty("JoramDfltPassword", "anonymous");
    }

    public FactoryParameters getParameters() {
        return this.params;
    }

    public final void toReference(Reference ref) throws NamingException {
        this.toReference(ref, "cf");
    }

    public void toReference(Reference ref, String prefix) {
        if (prefix == null) {
            prefix = "cf";
        }
        this.params.toReference(ref, prefix);
        ref.add(new StringRefAddr(prefix + ".reliableClass", this.reliableClass));
        ref.add(new StringRefAddr(prefix + ".identityClassName", this.identityClassName));
    }

    public final void fromReference(Reference ref) throws NamingException {
        this.fromReference(ref, "cf");
    }

    public void fromReference(Reference ref, String prefix) {
        if (prefix == null) {
            prefix = "cf";
        }
        this.reliableClass = (String)ref.get(prefix + ".reliableClass").getContent();
        this.setIdentityClassName((String)ref.get(prefix + ".identityClassName").getContent());
        this.params.fromReference(ref, prefix);
    }

    public Hashtable code() {
        return this.code(new Hashtable(), "cf");
    }

    public Hashtable code(Hashtable h, String prefix) {
        if (this.reliableClass != null) {
            h.put(prefix + ".reliableClass", this.reliableClass);
        }
        h.put(prefix + ".identityClassName", this.identityClassName);
        return this.params.code(h, prefix);
    }

    public void decode(Hashtable h) {
        this.decode(h, "cf");
    }

    public void decode(Hashtable h, String prefix) {
        this.reliableClass = (String)h.get(prefix + ".reliableClass");
        this.identityClassName = (String)h.get(prefix + ".identityClassName");
        this.params.decode(h, prefix);
    }
}

