/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.tcp;

import java.util.Timer;
import javax.jms.JMSException;
import org.objectweb.joram.client.jms.FactoryParameters;
import org.objectweb.joram.client.jms.connection.RequestChannel;
import org.objectweb.joram.client.jms.tcp.ReliableTcpClient;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.security.Identity;
import org.objectweb.util.monolog.api.BasicLevel;

public class TcpConnection
implements RequestChannel {
    private ReliableTcpClient tcpClient = null;

    public TcpConnection(FactoryParameters params, Identity identity) throws JMSException {
        this(params, identity, "org.objectweb.joram.client.jms.tcp.ReliableTcpClient");
    }

    public TcpConnection(FactoryParameters params, Identity identity, String reliableClass) throws JMSException {
        if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)("TcpConnection.<init>(" + params + ',' + identity + ',' + reliableClass + ')'));
        }
        if (reliableClass == null || reliableClass.equals("") || reliableClass.length() < 1) {
            reliableClass = "org.objectweb.joram.client.jms.tcp.ReliableTcpClient";
        }
        try {
            this.tcpClient = (ReliableTcpClient)Class.forName(reliableClass).newInstance();
        }
        catch (ClassNotFoundException exc) {
            JMSException jmsExc = new JMSException("TcpConnection: ClassNotFoundException : " + reliableClass);
            jmsExc.setLinkedException(exc);
            throw jmsExc;
        }
        catch (InstantiationException exc) {
            JMSException jmsExc = new JMSException("TcpConnection: InstantiationException : " + reliableClass);
            jmsExc.setLinkedException(exc);
            throw jmsExc;
        }
        catch (IllegalAccessException exc) {
            JMSException jmsExc = new JMSException("TcpConnection: IllegalAccessException : " + reliableClass);
            jmsExc.setLinkedException(exc);
            throw jmsExc;
        }
        this.tcpClient.init(params, identity, params.cnxPendingTimer > 0);
        this.tcpClient.addServerAddress(params.getHost(), params.getPort());
    }

    public void setTimer(Timer timer) {
        this.tcpClient.setTimer(timer);
    }

    public void connect() throws Exception {
        this.tcpClient.connect();
    }

    public synchronized void send(AbstractJmsRequest request) throws Exception {
        this.tcpClient.send(request);
    }

    public AbstractJmsReply receive() throws Exception {
        return (AbstractJmsReply)this.tcpClient.receive();
    }

    public void close() {
        this.tcpClient.close();
    }

    public String toString() {
        return '(' + super.toString() + ",tcpClient=" + this.tcpClient + ')';
    }
}

