/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.util.management.MXWrapper;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.MBeanAttributeInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.objectweb.joram.mom.dest.MonitoringTopicImplMBean;
import org.objectweb.joram.mom.dest.TopicImpl;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.mom.notifications.WakeUpNot;
import org.objectweb.joram.shared.excepts.MessageValueException;
import org.objectweb.joram.shared.messages.ConversionHelper;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.util.monolog.api.BasicLevel;

public class MonitoringTopicImpl
extends TopicImpl
implements MonitoringTopicImplMBean {
    private static final long serialVersionUID = 1L;
    private static final String monitoringPrefix = "MBeanMonitoring:";
    protected long period = 60000L;
    private long msgCounter = 0L;
    private Properties monitoringProperties = new Properties();
    private boolean isPersistent = false;
    private int priority = 4;
    private long expiration = -1L;
    private int receivedMessagesCount = 0;

    public MonitoringTopicImpl(AgentId adminId, Properties prop) {
        super(adminId, prop);
        if (prop != null) {
            Enumeration<Object> enumProperties = prop.keys();
            while (enumProperties.hasMoreElements()) {
                String propName = (String)enumProperties.nextElement();
                Object property = prop.get(propName);
                if (!(property instanceof String) || !propName.startsWith(monitoringPrefix)) continue;
                this.monitoringProperties.put(propName.substring(monitoringPrefix.length()), property);
            }
            try {
                if (prop.get("period") != null) {
                    this.period = ConversionHelper.toLong(prop.get("period"));
                }
                if (prop.get("persistent") != null) {
                    this.isPersistent = ConversionHelper.toBoolean(prop.get("persistent"));
                }
                if (prop.get("priority") != null) {
                    this.priority = ConversionHelper.toInt(prop.get("priority"));
                }
                if (prop.get("expiration") != null) {
                    this.expiration = ConversionHelper.toLong(prop.get("expiration"));
                }
            }
            catch (MessageValueException exc) {
                logger.log(BasicLevel.ERROR, (Object)exc);
            }
        } else {
            this.monitoringProperties.put("Joram#" + AgentServer.getServerId() + ":type=User,*", "NbMsgsDeliveredSinceCreation, NbMsgsSentToDMQSinceCreation, PendingMessageCount");
            this.monitoringProperties.put("Joram#" + AgentServer.getServerId() + ":type=Destination,*", "NbMsgsDeliverSinceCreation, NbMsgsReceiveSinceCreation, NbMsgsSentToDMQSinceCreation");
        }
    }

    public void initialize(boolean firstTime) {
        super.initialize(firstTime);
    }

    public long getPeriod() {
        return this.period;
    }

    public ClientMessages preProcess(AgentId from, ClientMessages msgs) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Change monitoring properties.");
        }
        this.monitoringProperties.clear();
        Message msg = (Message)msgs.getMessages().get(msgs.getMessages().size() - 1);
        if (msg.properties != null) {
            Enumeration enumProperties = msg.properties.keys();
            while (enumProperties.hasMoreElements()) {
                String propName = (String)enumProperties.nextElement();
                Object property = msg.properties.get(propName);
                if (!(property instanceof String) || !propName.startsWith(monitoringPrefix)) continue;
                this.monitoringProperties.put(propName.substring(monitoringPrefix.length()), property);
            }
            try {
                if (msg.properties.get("period") != null) {
                    this.period = ConversionHelper.toLong(msg.properties.get("period"));
                }
                if (msg.properties.get("persistent") != null) {
                    this.isPersistent = ConversionHelper.toBoolean(msg.properties.get("persistent"));
                }
                if (msg.properties.get("priority") != null) {
                    this.priority = ConversionHelper.toInt(msg.properties.get("priority"));
                }
                if (msg.properties.get("expiration") != null) {
                    this.expiration = ConversionHelper.toLong(msg.properties.get("expiration"));
                }
            }
            catch (MessageValueException exc) {
                logger.log(BasicLevel.ERROR, (Object)exc);
            }
        }
        this.receivedMessagesCount += msgs.getMessages().size();
        return null;
    }

    public void setPeriod(long period) {
        if (this.period == -1L && period != -1L) {
            this.forward(this.getId(), new WakeUpNot());
        }
        this.period = period;
    }

    private String createMessageId() {
        ++this.msgCounter;
        return "ID:" + this.getId().toString() + '_' + this.msgCounter;
    }

    public void wakeUpNot(WakeUpNot not) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " MonitoringTopicImpl.wakeUpNot(" + not + ")"));
        }
        long currentTime = System.currentTimeMillis();
        Message message = new Message();
        message.id = this.createMessageId();
        message.timestamp = currentTime;
        message.persistent = this.isPersistent;
        message.setDestination(this.getId().toString(), "topic");
        message.priority = this.priority;
        message.expiration = this.expiration > -1L ? currentTime + this.expiration : currentTime + 2L * this.period;
        Enumeration<Object> enumMBeans = this.monitoringProperties.keys();
        while (enumMBeans.hasMoreElements()) {
            String mbeanName = (String)enumMBeans.nextElement();
            String mbeanAttr = (String)this.monitoringProperties.get(mbeanName);
            try {
                Set mBeans = MXWrapper.queryNames(new ObjectName(mbeanName));
                if (mBeans == null) continue;
                Iterator iterator = mBeans.iterator();
                while (iterator.hasNext()) {
                    ObjectName mBean = (ObjectName)iterator.next();
                    StringTokenizer st = new StringTokenizer(mbeanAttr, ",");
                    while (st.hasMoreTokens()) {
                        String token2 = st.nextToken();
                        if (token2.equals("*")) {
                            try {
                                MBeanAttributeInfo[] attributes = MXWrapper.getAttributes(mBean);
                                if (attributes == null) continue;
                                for (int i = 0; i < attributes.length; ++i) {
                                    this.setMessageProperty(message, mBean, attributes[i].getName());
                                }
                                continue;
                            }
                            catch (Exception exc) {
                                if (!logger.isLoggable(BasicLevel.WARN)) continue;
                                logger.log(BasicLevel.ERROR, (Object)(" getAttributes  on " + mBean + " error."), (Throwable)exc);
                                continue;
                            }
                        }
                        this.setMessageProperty(message, mBean, token2.trim());
                    }
                }
            }
            catch (MalformedObjectNameException exc) {
                logger.log(BasicLevel.ERROR, (Object)("Invalid MBean name : " + mbeanName), (Throwable)exc);
            }
        }
        ClientMessages clientMessages = new ClientMessages(-1, -1, message);
        this.processMessages(clientMessages);
    }

    private void setMessageProperty(Message message, ObjectName mbeanName, String attrName) {
        block5: {
            try {
                Object monit = MXWrapper.getAttribute(mbeanName, attrName);
                if (monit != null) {
                    if (monit instanceof Boolean || monit instanceof Byte || monit instanceof Short || monit instanceof Integer || monit instanceof Long || monit instanceof Float || monit instanceof Double || monit instanceof String) {
                        message.setProperty(mbeanName + "," + attrName, monit);
                    } else {
                        message.setProperty(mbeanName + "," + attrName, monit.toString());
                    }
                }
            }
            catch (Exception exc) {
                if (!logger.isLoggable(BasicLevel.WARN)) break block5;
                logger.log(BasicLevel.WARN, (Object)(" getAttribute " + attrName + " on " + mbeanName + " error."), (Throwable)exc);
            }
        }
    }

    public long getNbMsgsReceiveSinceCreation() {
        return this.receivedMessagesCount;
    }
}

