/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.wrapper.log4j;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.objectweb.util.monolog.Monolog;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.MonologFactory;
import org.objectweb.util.monolog.wrapper.common.LevelImpl;
import org.objectweb.util.monolog.wrapper.common.RelatifEnvironmentPathGetter;
import org.objectweb.util.monolog.wrapper.log4j.PatternConverter;

public class RollingFileHandler
extends RollingFileAppender
implements Handler {
    protected HashMap prop = null;

    public RollingFileHandler() {
    }

    public RollingFileHandler(String name) {
        this.setName(name);
        this.prop = new HashMap();
    }

    public Map getAttributes() {
        return this.prop;
    }

    public void setAttributes(Map attributes) {
        this.prop.clear();
        this.prop.putAll(attributes);
        Object mf = this.prop.get("activation");
        if (mf != null) {
            this.prop.remove("activation");
            this.setAttribute("activation", mf);
        }
    }

    public String getType() {
        return "rollingfile";
    }

    public String[] getAttributeNames() {
        return this.prop.keySet().toArray(new String[0]);
    }

    public Object getAttribute(String key) {
        return this.prop.get(key);
    }

    public Object setAttribute(String key, Object value) {
        String buffersize;
        String nbFile;
        if (this.prop == null) {
            this.prop = new HashMap();
        }
        if (!key.equalsIgnoreCase("activation")) {
            return this.prop.put(key, value);
        }
        if (this.prop.containsKey(key)) {
            return null;
        }
        MonologFactory mf = (MonologFactory)value;
        String append = (String)this.prop.get("appendMode");
        this.fileAppend = append != null && append.length() > 0 ? Boolean.getBoolean(append) : true;
        String maxSize = (String)this.prop.get("maxSize");
        if (maxSize != null && maxSize.length() > 0) {
            this.setMaxFileSize(maxSize);
        }
        if ((nbFile = (String)this.prop.get("fileNumber")) != null && nbFile.length() > 0) {
            this.setMaxBackupIndex(Integer.valueOf(nbFile));
        }
        if ((buffersize = (String)this.prop.get("bufferSize")) != null && buffersize.length() > 0) {
            try {
                this.setBufferSize(Integer.valueOf(buffersize));
            }
            catch (NumberFormatException e) {
                Monolog.error("Bad specified buffer size for the handler '" + this.name + "': " + buffersize, e);
            }
        }
        String output = (String)this.prop.get("output");
        output = RelatifEnvironmentPathGetter.getRealPath(output);
        try {
            this.setFile(output, this.fileAppend, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            Monolog.error("Error during the creation of the handler '" + this.name + "': ", e);
        }
        String pattern = (String)this.prop.get("pattern");
        this.setLayout(new PatternLayout(PatternConverter.monolog2log4j(pattern)));
        String level = (String)this.prop.get("level");
        if (level != null && level.length() > 0) {
            int levelVal = LevelImpl.evaluate(level, mf);
            this.setThreshold(Level.toLevel(levelVal));
        }
        super.activateOptions();
        return null;
    }
}

