/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.jndi.ns;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TRANSIENT;
import org.ow2.carol.jndi.ns.AbsRegistry;
import org.ow2.carol.jndi.ns.NameService;
import org.ow2.carol.jndi.ns.NameServiceException;
import org.ow2.carol.rmi.util.PortNumber;
import org.ow2.carol.util.configuration.TraceCarol;

public class JacORBCosNaming
extends AbsRegistry
implements NameService {
    private static final String JACORB_NAMESERVER_CLASS = "org.jacorb.naming.NameServer";
    private static final int SLEEP_TIME = 2000;
    private static final int DEFAULT_PORT_NUMBER = 38693;
    private Process jacORBNameServerProcess = null;
    private static ORB orb = null;
    private static final String DEFAULT_DEBUG_OPTS = " -Xint -Xdebug -Xnoagent -Xrunjdwp:transport=dt_socket,server=y,address=1144,suspend=n ";
    private static String currentDebugOpts = " -Xint -Xdebug -Xnoagent -Xrunjdwp:transport=dt_socket,server=y,address=1144,suspend=n ";
    private static final String DEFAULT_LOGLEVEL_PROPERTY = " -Djacorb.log.default.verbosity=2 ";
    private static String currentLogProperty = " -Djacorb.log.default.verbosity=2 ";

    public JacORBCosNaming() {
        super(38693);
    }

    public void start() throws NameServiceException {
        String propertyName;
        String hostCorbaLoc;
        String ipAddr;
        block26: {
            if (this.isStarted()) {
                throw new IllegalStateException("Cannot start the server as the service is already running.");
            }
            if (TraceCarol.isDebugJndiCarol()) {
                TraceCarol.debugJndiCarol("start() on port : '" + this.getPort() + "'");
            }
            ipAddr = null;
            hostCorbaLoc = "localhost";
            if (!this.getHost().equalsIgnoreCase("localhost")) {
                try {
                    ipAddr = InetAddress.getByName(this.getHost()).getHostAddress();
                    System.setProperty("OAIAddr", ipAddr);
                }
                catch (UnknownHostException uhe) {
                    if (!TraceCarol.isDebugJndiCarol()) break block26;
                    TraceCarol.debugJndiCarol("Could net get ip address from host '" + this.getHost() + "' : " + uhe.getMessage());
                    uhe.printStackTrace();
                }
            }
        }
        if (Boolean.getBoolean("carol.server.mode")) {
            if (this.getConfigProperties() != null) {
                propertyName = "carol.iiop.server.port";
                int iiopPort = PortNumber.strToint(this.getConfigProperties().getProperty(propertyName, "0"), propertyName);
                if (iiopPort > 0) {
                    TraceCarol.infoCarol("Using IIOP fixed server port number '" + iiopPort + "'.");
                    System.setProperty("OAPort", String.valueOf(iiopPort));
                }
            } else {
                TraceCarol.debugCarol("No properties 'carol.iiop.server.port' defined in carol.properties file.");
            }
        }
        if (Boolean.getBoolean("carol.server.mode")) {
            if (this.getConfigProperties() != null) {
                propertyName = "carol.iiop.server.sslport";
                int iiopSslPort = PortNumber.strToint(this.getConfigProperties().getProperty(propertyName, String.valueOf(2003)), propertyName);
                if (iiopSslPort > 0) {
                    TraceCarol.debugCarol("Using SSL IIOP port number '" + iiopSslPort + "'.");
                    System.setProperty("OASSLPort", String.valueOf(iiopSslPort));
                }
            } else {
                TraceCarol.debugCarol("No properties 'carol.iiop.server.sslport' defined in carol.properties file.");
            }
        }
        try {
            if (!this.isRemoteNameServiceStarted()) {
                String logLevel;
                String debugOpts;
                String jvmProperties = "-Djava.endorsed.dirs=" + System.getProperty("java.endorsed.dirs") + " " + "-Djacorb.orb.print_version=off " + "-Djava.ext.dirs=" + System.getProperty("java.ext.dirs") + " " + "-Dorg.omg.CORBA.ORBClass=org.jacorb.orb.ORB " + "-Dorg.omg.CORBA.ORBSingletonClass=org.jacorb.orb.ORBSingleton " + "-DOAPort=";
                jvmProperties = jvmProperties + Integer.toString(this.getPort());
                jvmProperties = jvmProperties + " -DORBInitRef.NameService=corbaloc:iiop:" + hostCorbaLoc + ":" + Integer.toString(this.getPort()) + "/NameService";
                if (ipAddr != null) {
                    jvmProperties = jvmProperties + " -DOAIAddr=" + ipAddr;
                }
                if ((debugOpts = System.getProperty("jonas.cosnaming.debug")) != null) {
                    String server;
                    String suspend;
                    String debugPort = System.getProperty("jonas.cosnaming.debug.port");
                    if (debugPort != null) {
                        currentDebugOpts = currentDebugOpts.replace("1144", debugPort);
                    }
                    if ((suspend = System.getProperty("jonas.cosnaming.debug.suspend")) != null) {
                        currentDebugOpts = currentDebugOpts.replace("suspend=n", "suspend=" + suspend);
                    }
                    if ((server = System.getProperty("jonas.cosnaming.debug.server")) != null) {
                        currentDebugOpts = currentDebugOpts.replace("server=y", "server=" + server);
                    }
                    jvmProperties = jvmProperties + currentDebugOpts;
                }
                if ((logLevel = System.getProperty("jonas.cosnaming.loglevel")) != null) {
                    currentLogProperty = currentLogProperty.replace("2", logLevel);
                }
                jvmProperties = jvmProperties + currentLogProperty;
                String confDir = this.getConfigDir();
                String classpathOpts = null;
                String debugMsg = "Launching NS with JVM properties: '" + jvmProperties + "'";
                String command = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java " + jvmProperties + " " + JACORB_NAMESERVER_CLASS;
                if (confDir != null) {
                    classpathOpts = "-cp " + confDir + " ";
                    debugMsg = "Launching NS with classpath '" + classpathOpts + "' and JVM properties: '" + jvmProperties + "'";
                    command = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java " + classpathOpts + jvmProperties + " " + JACORB_NAMESERVER_CLASS;
                }
                if (TraceCarol.isDebugJndiCarol()) {
                    TraceCarol.debugJndiCarol(debugMsg);
                }
                this.jacORBNameServerProcess = Runtime.getRuntime().exec(command);
                Thread.sleep(2000L);
                InputStream cosError = this.jacORBNameServerProcess.getErrorStream();
                InputStream cosOut = this.jacORBNameServerProcess.getInputStream();
                Thread err = new Thread(new CosReader(cosError, true));
                Thread out = new Thread(new CosReader(cosOut, false));
                out.start();
                err.start();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        try {
                            if (JacORBCosNaming.this.isStarted()) {
                                JacORBCosNaming.this.stop();
                            }
                        }
                        catch (Exception e) {
                            TraceCarol.error("JacORBCosNaming ShutdownHook problem", e);
                        }
                    }
                });
            } else if (TraceCarol.isDebugJndiCarol()) {
                TraceCarol.debugJndiCarol("JacORBCosNaming is already start on port : '" + this.getPort() + "'.");
            }
        }
        catch (Exception e) {
            TraceCarol.error("Cannot start JacORBCosNaming for an unknown reason", e);
            throw new NameServiceException("cannot start cosnaming daemon: " + e);
        }
        this.setStarted();
    }

    private String getConfigDir() {
        URL ret;
        block4: {
            ret = null;
            try {
                ret = Thread.currentThread().getContextClassLoader().getResource("jacorb.properties");
                if (TraceCarol.isDebugJndiCarol()) {
                    TraceCarol.debugJndiCarol("Got jacorb configuration file from Thread ClassLoader " + this.getClass().getClassLoader());
                }
            }
            catch (Exception e) {
                if (!TraceCarol.isDebugJndiCarol()) break block4;
                TraceCarol.debugJndiCarol("Unable to get jacorb configuration file from Thread ClassLoader");
            }
        }
        if (ret != null) {
            return ret.getPath().replace(File.separator + "jacorb.properties", "");
        }
        return null;
    }

    public void stop() throws NameServiceException {
        if (!this.isStarted()) {
            throw new IllegalStateException("Cannot stop the server as the service is not running.");
        }
        try {
            if (this.jacORBNameServerProcess != null) {
                this.jacORBNameServerProcess.destroy();
            }
            this.jacORBNameServerProcess = null;
        }
        catch (Exception e) {
            TraceCarol.error("Cannot stop JacORBCosNaming for an unknown reason", e);
            throw new NameServiceException("cannot start cosnaming daemon: " + e);
        }
        this.resetStarted();
    }

    private boolean isRemoteNameServiceStarted() {
        Properties prop = new Properties();
        prop.put("java.naming.factory.initial", "org.ow2.carol.jndi.spi.URLInitialContextFactory");
        prop.put("java.naming.provider.url", "iiop://localhost:" + this.getPort());
        if (orb == null) {
            JacORBCosNaming.initORB();
        }
        prop.put("java.naming.corba.orb", orb);
        try {
            new InitialContext(prop);
        }
        catch (NamingException ne) {
            return false;
        }
        catch (TRANSIENT ct) {
            return false;
        }
        return true;
    }

    public static ORB getOrb() {
        if (orb == null) {
            JacORBCosNaming.initORB();
        }
        return orb;
    }

    private static void initORB() {
        orb = ORB.init(new String[0], null);
    }

    class CosReader
    implements Runnable {
        private InputStream is;
        private boolean isErrorMessage = false;

        public CosReader(InputStream is, boolean isErrorMessage) {
            this.is = is;
            this.isErrorMessage = isErrorMessage;
        }

        public void run() {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(this.is));
                String str = null;
                while ((str = br.readLine()) != null) {
                    if (this.isErrorMessage) {
                        if (!TraceCarol.isDebugJndiCarol()) continue;
                        TraceCarol.debugJndiCarol("JacORBCosNaming error :");
                        TraceCarol.debugJndiCarol(str);
                        continue;
                    }
                    if (!TraceCarol.isDebugJndiCarol()) continue;
                    TraceCarol.debugJndiCarol("JacORBCosNaming:");
                    TraceCarol.debugJndiCarol(str);
                }
                this.is.close();
            }
            catch (Exception e) {
                TraceCarol.error(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

