/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.controller.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJBObject;
import javax.management.remote.JMXServiceURL;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import net.jcip.annotations.ThreadSafe;
import org.ow2.cmi.admin.CMIAdminConnectorManager;
import org.ow2.cmi.admin.CMIMBeanConfigException;
import org.ow2.cmi.config.JmxConnectors;
import org.ow2.cmi.config.UpdatedClientConfig;
import org.ow2.cmi.controller.client.IUpdatedClientConfig;
import org.ow2.cmi.controller.common.AbsClusterViewManager;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.controller.common.ClusteredDummyRegistry;
import org.ow2.cmi.controller.common.ImmutableClusteredObjectInfos;
import org.ow2.cmi.controller.provider.ClientClusterViewProvider;
import org.ow2.cmi.controller.provider.ClusteredClientClusterViewProvider;
import org.ow2.cmi.controller.server.DistributedObjectInfo;
import org.ow2.cmi.controller.server.IPolicyStrategyManager;
import org.ow2.cmi.controller.server.IServerConfig;
import org.ow2.cmi.controller.server.Protocol;
import org.ow2.cmi.controller.server.ProtocolNotFoundException;
import org.ow2.cmi.controller.server.ServerClusterViewManager;
import org.ow2.cmi.controller.server.ServerClusterViewManagerException;
import org.ow2.cmi.controller.server.ServerConfig;
import org.ow2.cmi.controller.server.filter.BlacklistFilter;
import org.ow2.cmi.controller.server.filter.IFilter;
import org.ow2.cmi.controller.server.manager.DefaultPolicyStrategyManager;
import org.ow2.cmi.event.CMIEventComponent;
import org.ow2.cmi.event.EventObjectRemoved;
import org.ow2.cmi.info.CMIInfoExtractor;
import org.ow2.cmi.info.CMIInfoExtractorException;
import org.ow2.cmi.info.CMIInfoRepository;
import org.ow2.cmi.info.ClusteredObjectInfo;
import org.ow2.cmi.lb.data.PolicyData;
import org.ow2.cmi.lb.policy.FirstAvailable;
import org.ow2.cmi.lb.policy.IPolicy;
import org.ow2.cmi.lb.strategy.IStrategy;
import org.ow2.cmi.lb.strategy.NoStrategy;
import org.ow2.cmi.lb.util.PolicyFactory;
import org.ow2.cmi.loader.IDefaultPolicyStrategyLoader;
import org.ow2.cmi.loader.IPolicyStrategyLoader;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.ObjectNotFoundException;
import org.ow2.cmi.reference.ServerId;
import org.ow2.cmi.reference.ServerRef;
import org.ow2.util.execution.ExecutionResult;
import org.ow2.util.execution.IExecution;
import org.ow2.util.execution.helper.RunnableHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.IPoolConfiguration;
import org.ow2.util.pool.impl.PoolConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class AbsServerClusterViewManager
extends AbsClusterViewManager
implements ServerClusterViewManager {
    private static final Log LOGGER = LogFactory.getLog(AbsServerClusterViewManager.class);
    private static final String CONTEXT_FACTORY = "org.ow2.cmi.jndi.context.CMIInitialContextFactory";
    private final Map<String, Protocol> protocols = new HashMap<String, Protocol>();
    private InetAddress inetAddress = null;
    private ClusteredObjectInfo clusteredObjectInfoForDummyRegistry;
    private boolean replicationManagerStarted = false;
    private final Map<String, Class<?>> interfaces = new HashMap();
    private IPolicyStrategyManager policyStrategyManager = null;
    protected IPolicyStrategyLoader policyStrategyLoader = null;
    private final List<IFilter> localFilters = new ArrayList<IFilter>();
    private boolean implementationAvailable = false;
    private boolean registrationOpened;

    protected AbsServerClusterViewManager() {
        this.localFilters.add(new BlacklistFilter(this));
    }

    @Override
    protected final boolean starting() throws ServerClusterViewManagerException {
        try {
            this.clusteredObjectInfoForDummyRegistry = CMIInfoExtractor.extractClusteringInfoFromAnnotatedPOJO(this.getConfig().getDummyRegistryName(), null, ClusteredDummyRegistry.class, false, null);
        }
        catch (CMIInfoExtractorException e) {
            LOGGER.error("Cannot get infos for dummy registry", e);
            throw new ServerClusterViewManagerException("Cannot get infos for dummy registry", e);
        }
        IPolicyStrategyManager policStrategyManager = this.registerPolicyStrategyManager();
        this.registerPolicyStrategyLoader(policStrategyManager);
        this.policyStrategyManager.loadEmbeddedLBClasses();
        this.doStart();
        if (this.implementationAvailable) {
            this.setState(ClusterViewManager.State.AVAILABLE);
        } else {
            this.setState(ClusterViewManager.State.STARTED);
        }
        if (((IServerConfig)this.getConfig()).isProtocolAdded() && this.isRegistrationOpened()) {
            if (System.getProperty("java.naming.factory.initial") == null) {
                System.setProperty("java.naming.factory.initial", CONTEXT_FACTORY);
            }
            try {
                new InitialContext();
            }
            catch (NamingException e) {
                LOGGER.warn("Unable to create a cmi context", e);
            }
        }
        LOGGER.info("CMI server started.", new Object[0]);
        return this.implementationAvailable;
    }

    protected final boolean isImplementationAvailable() {
        return this.implementationAvailable;
    }

    protected final void setImplementationAvailable(boolean implementationAvailable) {
        if (this.getState().equals((Object)ClusterViewManager.State.STARTED) && implementationAvailable) {
            this.implementationAvailable = true;
            this.setState(ClusterViewManager.State.AVAILABLE);
        } else if (this.getState().equals((Object)ClusterViewManager.State.AVAILABLE) && !implementationAvailable) {
            this.implementationAvailable = false;
            this.setState(ClusterViewManager.State.STARTED);
        } else if (this.getState().equals((Object)ClusterViewManager.State.STARTING) && implementationAvailable) {
            this.implementationAvailable = true;
        } else if (this.getState().equals((Object)ClusterViewManager.State.STOPPING) && !implementationAvailable) {
            this.implementationAvailable = false;
        }
    }

    @Override
    public boolean isRegistrationOpened() {
        return this.registrationOpened;
    }

    protected void setRegistrationOpened(boolean registrationOpened) {
        this.registrationOpened = registrationOpened;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void stopping() {
        Map<String, Protocol> map = this.protocols;
        synchronized (map) {
            for (Map.Entry<String, Protocol> protocol : this.protocols.entrySet()) {
                Remote clientProvider;
                Context ctxt;
                JmxConnectors jmxConnectors = ((ServerConfig)this.getConfig()).getJmxConnectors();
                if (this.getConfig().isAdminEnabled() && jmxConnectors != null && jmxConnectors.getProtocols().contains(protocol)) {
                    try {
                        CMIAdminConnectorManager.stopConnector(protocol.getKey());
                    }
                    catch (CMIMBeanConfigException e) {
                        LOGGER.warn("The connector for the protocol {0} cannot be removed", protocol, e);
                    }
                }
                if ((ctxt = protocol.getValue().getCmiContext()) != null) {
                    try {
                        ctxt.unbind(this.getConfig().getClientProviderName());
                    }
                    catch (NamingException e) {
                        LOGGER.warn("Cannot unbind the instance of ClientClusterViewProvider for the protocol {0}", protocol.getKey(), e);
                    }
                }
                if ((clientProvider = protocol.getValue().getClientClusterViewProvider()) == null) continue;
                System.setProperty("carol.multipro.protocol", protocol.getKey());
                try {
                    PortableRemoteObject.unexportObject((Remote)clientProvider);
                }
                catch (NoSuchObjectException e) {
                    LOGGER.warn("Cannot unexport the instance of ClientClusterViewProvider for the protocol {0}", protocol.getKey(), e);
                }
                finally {
                    System.setProperty("carol.multipro.protocol", "any");
                }
            }
            this.protocols.clear();
            this.getEventDispatcher().stop();
            CMIEventComponent eventComponent = this.getComponent(CMIEventComponent.class);
            if (eventComponent != null) {
                eventComponent.unregisterCMIManagedObject(this);
            }
            this.getComponentManager().stopComponents();
            this.interfaces.clear();
            try {
                this.doStop();
            }
            catch (ServerClusterViewManagerException e) {
                LOGGER.warn("Error when stopping the implementation of cmi server", e);
            }
        }
    }

    public abstract void doStart() throws ServerClusterViewManagerException;

    public abstract void doStop() throws ServerClusterViewManagerException;

    private IPolicyStrategyManager registerPolicyStrategyManager() throws ServerClusterViewManagerException {
        String managerClassname = ((ServerConfig)this.getConfig()).getPolicyStrategyManagerClassname();
        if (managerClassname == null) {
            LOGGER.debug("Policy/strategy manager set to default 'org.ow2.cmi.controller.server.manager.DefaultPolicyStrategyManager'", new Object[0]);
            managerClassname = "org.ow2.cmi.controller.server.manager.DefaultPolicyStrategyManager";
        }
        Class<?> poliStrategyManager = null;
        try {
            poliStrategyManager = this.getClass().getClassLoader().loadClass(managerClassname);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Cannot load the class implementing a policy/strategy manager.", new Object[0]);
            throw new ServerClusterViewManagerException("Cannot load the class implementing a policy/strategy manager.", e);
        }
        LOGGER.debug("The Manager for policies and strategies is: {0}", poliStrategyManager.getName());
        try {
            if (poliStrategyManager.getName().equals("org.ow2.cmi.controller.server.manager.DefaultPolicyStrategyManager")) {
                this.policyStrategyManager = (IPolicyStrategyManager)poliStrategyManager.newInstance();
                this.setPolicyStrategyManager(this.policyStrategyManager);
                ((DefaultPolicyStrategyManager)this.policyStrategyManager).setServerClusterViewManager(this);
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot instantiate default class implementing a policy/strategy manager.", new Object[0]);
            throw new ServerClusterViewManagerException("Cannot instantiate default class implementing a policy/strategy manager.", e);
        }
        return this.policyStrategyManager;
    }

    private void registerPolicyStrategyLoader(IPolicyStrategyManager policStrategyManager) throws ServerClusterViewManagerException {
        String loaderClassname = ((ServerConfig)this.getConfig()).getPolicyStrategyLoaderClassname();
        if (loaderClassname == null) {
            LOGGER.debug("Policy/strategy loader set to default 'org.ow2.cmi.osgi.loader.DefaultPolicyStrategyLoader'", new Object[0]);
            loaderClassname = "org.ow2.cmi.osgi.loader.DefaultPolicyStrategyLoader";
        }
        Class<?> poliStrategyLoader = null;
        try {
            poliStrategyLoader = this.getClass().getClassLoader().loadClass(loaderClassname);
        }
        catch (ClassNotFoundException e) {
            LOGGER.debug("Standalone mode. No policy/strategy loading.", new Object[0]);
            return;
        }
        LOGGER.debug("The Loader for policies and stretgies is: {0}", poliStrategyLoader.getName());
        try {
            if ("org.ow2.cmi.osgi.loader.DefaultPolicyStrategyLoader".equals(poliStrategyLoader.getName())) {
                this.policyStrategyLoader = (IPolicyStrategyLoader)poliStrategyLoader.newInstance();
                this.setPolicyStrategyLoader(this.policyStrategyLoader);
                ((IDefaultPolicyStrategyLoader)this.policyStrategyLoader).setPolicyStrategyManager(policStrategyManager);
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot instantiate default class implementing a policy/strategy loader.", new Object[0]);
            throw new ServerClusterViewManagerException("Cannot instantiate default class implementing a policy/strategy loader.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean addProtocol(final String initialContextFactoryName, final ServerId serverRef, final Context cmiContext) throws ServerClusterViewManagerException {
        Map<String, Protocol> map = this.protocols;
        synchronized (map) {
            IExecution<Void> exec = new IExecution<Void>(){

                @Override
                public Void execute() throws Exception {
                    String protocol = serverRef.getProtocol();
                    String providerURL = serverRef.getProviderURL();
                    if (!AbsServerClusterViewManager.this.protocols.containsKey(protocol)) {
                        LOGGER.debug("New protocol {0} added", protocol);
                        AbsServerClusterViewManager.this.initServerConfig(initialContextFactoryName, serverRef, cmiContext);
                        ClientClusterViewProvider clientClusterViewProvider = null;
                        if (((ServerConfig)AbsServerClusterViewManager.this.getConfig()).isProviderBound()) {
                            LOGGER.debug("Binds a provider of the cluster view for protocol {0}", protocol);
                            clientClusterViewProvider = AbsServerClusterViewManager.this.bindClientClusterViewProvider(cmiContext, protocol);
                        }
                        AbsServerClusterViewManager.this.protocols.put(protocol, new Protocol(initialContextFactoryName, serverRef, clientClusterViewProvider, cmiContext));
                        if (((ServerConfig)AbsServerClusterViewManager.this.getConfig()).isRegistryBound()) {
                            LOGGER.debug("Binds a dummy object that represents the registry for protocol {0}", protocol);
                            AbsServerClusterViewManager.this.bindDummyRegistry(serverRef);
                        }
                        InetAddress newInetAddress = serverRef.getInetAddress();
                        try {
                            if (NetworkInterface.getByInetAddress(newInetAddress) == null) {
                                LOGGER.error("The referenced server is not local", new Object[0]);
                                throw new ServerClusterViewManagerException("The referenced server is not local");
                            }
                        }
                        catch (SocketException e) {
                            LOGGER.error("Cannot know if the IP is local", e);
                            throw new ServerClusterViewManagerException("Cannot know if the IP is local", e);
                        }
                        if (AbsServerClusterViewManager.this.inetAddress == null) {
                            LOGGER.debug("InetAdress of manager is {0}", newInetAddress);
                            AbsServerClusterViewManager.this.inetAddress = newInetAddress;
                        } else if (!newInetAddress.equals(AbsServerClusterViewManager.this.inetAddress)) {
                            LOGGER.error("Host name expected: {0} - Host name found : {1}. All the protocol have to use the same host name !", AbsServerClusterViewManager.this.inetAddress, newInetAddress);
                            throw new ServerClusterViewManagerException("Host name expected: " + AbsServerClusterViewManager.this.inetAddress.getHostName() + " - Host name found : " + newInetAddress.getHostName() + ". All the protocol have to use the same host name !");
                        }
                        JmxConnectors jmxConnectors = ((ServerConfig)AbsServerClusterViewManager.this.getConfig()).getJmxConnectors();
                        if (AbsServerClusterViewManager.this.getConfig().isAdminEnabled() && jmxConnectors != null && jmxConnectors.getProtocols().contains(protocol)) {
                            try {
                                CMIAdminConnectorManager.startConnector(protocol, providerURL);
                            }
                            catch (CMIMBeanConfigException e) {
                                LOGGER.error("The connector for the protocol {0} cannot be added", protocol, e);
                                throw new ServerClusterViewManagerException("The connector for the protocol " + protocol + " cannot be added", e);
                            }
                        }
                    }
                    return null;
                }
            };
            RunnableHelper<Void> helper = new RunnableHelper<Void>();
            ExecutionResult<Void> execResult = helper.execute(this.getClass().getClassLoader(), exec);
            if (execResult.hasException()) {
                LOGGER.error("Unable to add protocol ", execResult.getException());
                return false;
            }
            return true;
        }
    }

    protected void initServerConfig(String initialContextFactoryName, ServerId serverId, Context context) throws ServerClusterViewManagerException {
        this.setLoadFactor(serverId, ((ServerConfig)this.getConfig()).getLoadFactor());
        this.initDelayToRefresh(((ServerConfig)this.getConfig()).getDelayToRefresh());
        this.initStats();
    }

    protected abstract void initDelayToRefresh(int var1);

    private ClientClusterViewProvider bindClientClusterViewProvider(Context cmiContext, String protocol) throws ServerClusterViewManagerException {
        ClusteredObjectInfo clusteredObjectInfo;
        ClusteredClientClusterViewProvider clientClusterViewProvider = null;
        System.setProperty("carol.multipro.protocol", protocol);
        try {
            clientClusterViewProvider = new ClusteredClientClusterViewProvider(this);
        }
        catch (RemoteException e) {
            LOGGER.error("Cannot export the instance of ClientClusterViewProvider for the protocol {0}", protocol, e);
            throw new ServerClusterViewManagerException("Cannot export the instance of ClientClusterViewProvider for the protocol " + protocol, e);
        }
        finally {
            System.setProperty("carol.multipro.protocol", "any");
        }
        String bindName = this.getConfig().getClientProviderName();
        try {
            clusteredObjectInfo = CMIInfoExtractor.extractClusteringInfoFromAnnotatedPOJO(bindName, ClientClusterViewProvider.class, ClusteredClientClusterViewProvider.class, false, null);
        }
        catch (CMIInfoExtractorException e) {
            LOGGER.error("Cannot get infos for client provider", e);
            throw new ServerClusterViewManagerException("Cannot get infos for client provider", e);
        }
        CMIInfoRepository.addClusteredObjectInfo(bindName, clusteredObjectInfo);
        try {
            cmiContext.rebind(bindName, (Object)clientClusterViewProvider);
        }
        catch (NamingException e) {
            LOGGER.error("Cannot rebind a ClientClusterViewProvider for protocol {0}", protocol, e);
            throw new ServerClusterViewManagerException("Cannot rebind a ClientClusterViewProvider " + protocol, e);
        }
        LOGGER.debug("ClientClusterViewProvider has been rebound for the protocol {0} with the name {1}", protocol, bindName);
        return clientClusterViewProvider;
    }

    private void bindDummyRegistry(ServerId serverRef) {
        String bindName = this.getConfig().getDummyRegistryName();
        CMIReference cmiReference = new CMIReference(serverRef, bindName);
        this.addObjectInstance(this.clusteredObjectInfoForDummyRegistry, cmiReference);
    }

    @Override
    public final synchronized void addObjectToWatch(String objectName) throws ObjectNotFoundException, ServerClusterViewManagerException {
        if (!this.isWatched(objectName)) {
            String businessName;
            LOGGER.debug("Adding {0} to the set of watched object", objectName);
            DistributedObjectInfo distributedObjectInfo = this.getDistributedObjectInfo(objectName);
            String itfName = distributedObjectInfo.getItfName();
            if (!this.interfaces.containsKey(itfName)) {
                Class<?> itfClass;
                ClassLoader currentCLoader = Thread.currentThread().getContextClassLoader();
                try {
                    itfClass = Class.forName(itfName, true, currentCLoader);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Unable to load the interface {0} of object {1}", itfName, objectName, e);
                    throw new ServerClusterViewManagerException("Unable to load the interface " + itfName + " of object " + objectName, e);
                }
                this.interfaces.put(itfName, itfClass);
            }
            if ((businessName = distributedObjectInfo.getBusinessName()) != null && !this.interfaces.containsKey(businessName)) {
                Class<?> businessClass;
                ClassLoader currentCLoader = Thread.currentThread().getContextClassLoader();
                try {
                    businessClass = Class.forName(businessName, true, currentCLoader);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Unable to load the business interface {0} of object {1}", businessName, objectName, e);
                    throw new ServerClusterViewManagerException("Unable to load the business interface " + businessName + " of object " + objectName, e);
                }
                this.interfaces.put(businessName, businessClass);
            }
            this.watch(objectName);
            this.updatePolicy(objectName);
        }
    }

    @Override
    public final synchronized void addObjectInstance(ClusteredObjectInfo clusteredObjectInfo, CMIReference cmiReference) {
        Class<IStrategy<Object>> strategyClass;
        Class<IPolicy<Object>> policyClass;
        Class<?> itfClass = clusteredObjectInfo.getItfClass();
        String businessName = null;
        String itfName = null;
        if (itfClass != null) {
            Class<? extends EJBObject> businessClass = clusteredObjectInfo.getBusinessClass();
            itfName = itfClass.getName();
            this.interfaces.put(itfName, itfClass);
            if (businessClass != null) {
                businessName = businessClass.getName();
                this.interfaces.put(businessName, businessClass);
            }
        }
        if ((policyClass = clusteredObjectInfo.getPolicyType()) == null) {
            policyClass = FirstAvailable.class;
        }
        if ((strategyClass = clusteredObjectInfo.getStrategyType()) == null) {
            strategyClass = NoStrategy.class;
        }
        String clusterName = clusteredObjectInfo.getClusterName();
        boolean proxyEnabled = clusteredObjectInfo.isProxyEnabled();
        IPoolConfiguration poolConfiguration = clusteredObjectInfo.getPoolConfiguration();
        if (poolConfiguration == null) {
            poolConfiguration = new PoolConfiguration();
        }
        String policyType = policyClass.getName();
        String strategyType = strategyClass.getName();
        Map<String, Object> properties = clusteredObjectInfo.getProperties();
        boolean hasState = clusteredObjectInfo.hasState();
        boolean replicated = clusteredObjectInfo.isReplicated();
        Set<String> applicationExceptionNames = clusteredObjectInfo.getApplicationExceptionNames();
        applicationExceptionNames = applicationExceptionNames == null ? new HashSet<String>() : new HashSet<String>(applicationExceptionNames);
        new PolicyFactory(this).getPolicy(policyClass, strategyClass, properties);
        PolicyData policyData = new PolicyData(policyType, strategyType, properties);
        String objectName = cmiReference.getObjectName();
        DistributedObjectInfo distributedObjectInfo = new DistributedObjectInfo(clusterName, proxyEnabled, objectName, itfName, businessName, policyData, hasState, replicated, applicationExceptionNames, poolConfiguration);
        this.addDefaultPolicyStrategy(objectName, policyType, strategyType);
        this.addDistributedObjectInfo(objectName, distributedObjectInfo);
        LOGGER.debug("Adding {0}...", cmiReference);
        this.addCMIReference(cmiReference);
    }

    private void addDefaultPolicyStrategy(String objectName, String policyType, String strategyType) {
        this.policyStrategyManager.addDefaultPolicyClassName(objectName, policyType);
        this.policyStrategyManager.addDefaultStrategyClassName(objectName, strategyType);
    }

    protected abstract boolean containObject(String var1);

    protected abstract DistributedObjectInfo getDistributedObjectInfo(String var1) throws ObjectNotFoundException;

    protected abstract void addDistributedObjectInfo(String var1, DistributedObjectInfo var2);

    protected abstract void setDistributedObjectInfo(String var1, DistributedObjectInfo var2);

    @Override
    public final String getItfName(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getItfName();
    }

    @Override
    public final Class<?> getInterface(String objectName) throws ObjectNotFoundException {
        return this.interfaces.get(this.getItfName(objectName));
    }

    @Override
    public final String getBusinessName(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getBusinessName();
    }

    @Override
    public final Class<? extends EJBObject> getRemoteClass(String objectName) throws ObjectNotFoundException {
        return this.interfaces.get(this.getBusinessName(objectName));
    }

    @Override
    public final List<String> getProviderURLs(String protocolName) throws ServerClusterViewManagerException {
        String providerName = this.getConfig().getClientProviderName();
        ArrayList<String> providerURLs = new ArrayList<String>();
        try {
            for (CMIReference cmiReference : this.getCMIReferences(providerName, protocolName)) {
                providerURLs.add(cmiReference.getServerRef().getProviderURL());
            }
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error("Cannot get CMIReferences for the provider whith name {0}", providerName, e);
            throw new ServerClusterViewManagerException("Cannot get CMIReferences for the provider whith name " + providerName, e);
        }
        return providerURLs;
    }

    @Override
    public final Class<? extends IPolicy<?>> getPolicyClass(String objectName) throws ObjectNotFoundException, ServerClusterViewManagerException {
        return this.policyStrategyManager.getPolicyClass(objectName);
    }

    @Override
    public final Class<? extends IStrategy<?>> getStrategyClass(String objectName) throws ObjectNotFoundException, ServerClusterViewManagerException {
        return this.policyStrategyManager.getStrategyClass(objectName);
    }

    @Override
    public final long getDateOfProperties(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getPolicyData().getDateOfProperties();
    }

    @Override
    public final Map<String, Object> getPropertiesForPolicy(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getPolicyData().getProperties();
    }

    @Override
    public final Object getPropertyForPolicy(String objectName, String propertyName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getPolicyData().getProperties().get(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setPropertiesForPolicy(String objectName, Map<String, Object> properties) throws ObjectNotFoundException {
        DistributedObjectInfo distributedObjectInfo;
        DistributedObjectInfo distributedObjectInfo2 = distributedObjectInfo = this.getDistributedObjectInfo(objectName);
        synchronized (distributedObjectInfo2) {
            for (Map.Entry<String, Object> propertyEntry : properties.entrySet()) {
                distributedObjectInfo.getPolicyData().setProperty(propertyEntry.getKey(), propertyEntry.getValue());
            }
            this.setDistributedObjectInfo(objectName, distributedObjectInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setPropertyForPolicy(String objectName, String propertyName, Object valueName) throws ObjectNotFoundException {
        DistributedObjectInfo distributedObjectInfo;
        DistributedObjectInfo distributedObjectInfo2 = distributedObjectInfo = this.getDistributedObjectInfo(objectName);
        synchronized (distributedObjectInfo2) {
            distributedObjectInfo.getPolicyData().setProperty(propertyName, valueName);
            this.setDistributedObjectInfo(objectName, distributedObjectInfo);
        }
    }

    @Override
    public final boolean isClustered(String objectName) {
        return this.containObject(objectName);
    }

    @Override
    public final String getClusterName(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getClusterName();
    }

    @Override
    public boolean isProxyEnabled(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).isProxyEnabled();
    }

    @Override
    public final String getPolicyClassName(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getPolicyData().getPolicyType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setPolicyClassName(String objectName, String policyType) throws ObjectNotFoundException {
        DistributedObjectInfo distributedObjectInfo;
        DistributedObjectInfo distributedObjectInfo2 = distributedObjectInfo = this.getDistributedObjectInfo(objectName);
        synchronized (distributedObjectInfo2) {
            distributedObjectInfo.getPolicyData().setPolicyType(policyType);
            this.setDistributedObjectInfo(objectName, distributedObjectInfo);
        }
    }

    @Override
    public final String getStrategyClassName(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getPolicyData().getStrategyType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setStrategyClassName(String objectName, String strategyClassName) throws ObjectNotFoundException {
        DistributedObjectInfo distributedObjectInfo;
        DistributedObjectInfo distributedObjectInfo2 = distributedObjectInfo = this.getDistributedObjectInfo(objectName);
        synchronized (distributedObjectInfo2) {
            distributedObjectInfo.getPolicyData().setStrategyType(strategyClassName);
            this.setDistributedObjectInfo(objectName, distributedObjectInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setAlgorithmForPolicy(String objectName, String policyClassName, String strategyClassName, Map<String, Object> properties) throws ObjectNotFoundException {
        DistributedObjectInfo distributedObjectInfo;
        DistributedObjectInfo distributedObjectInfo2 = distributedObjectInfo = this.getDistributedObjectInfo(objectName);
        synchronized (distributedObjectInfo2) {
            PolicyData policyData = distributedObjectInfo.getPolicyData();
            policyData.setPolicyType(policyClassName);
            policyData.setStrategyType(strategyClassName);
            policyData.setProperties(properties);
            this.setDistributedObjectInfo(objectName, distributedObjectInfo);
        }
    }

    @Override
    public final IPoolConfiguration getPoolConfiguration(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getPoolConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setPoolConfiguration(String objectName, IPoolConfiguration poolConfiguration) throws ObjectNotFoundException {
        DistributedObjectInfo distributedObjectInfo;
        DistributedObjectInfo distributedObjectInfo2 = distributedObjectInfo = this.getDistributedObjectInfo(objectName);
        synchronized (distributedObjectInfo2) {
            distributedObjectInfo.setPoolConfiguration(poolConfiguration);
            this.setDistributedObjectInfo(objectName, distributedObjectInfo);
        }
    }

    @Override
    public final InetAddress getInetAddress() {
        return this.inetAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasProtocol(String protocolName) {
        Map<String, Protocol> map = this.protocols;
        synchronized (map) {
            return this.protocols.containsKey(protocolName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Set<String> getProtocols() {
        Map<String, Protocol> map = this.protocols;
        synchronized (map) {
            return new HashSet<String>(this.protocols.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getInitialContextFactoryName(String protocolName) throws ProtocolNotFoundException {
        Map<String, Protocol> map = this.protocols;
        synchronized (map) {
            Protocol protocol = this.protocols.get(protocolName);
            if (protocol == null) {
                throw new ProtocolNotFoundException(protocolName);
            }
            return protocol.getInitialContextFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ServerId getRefOnLocalRegistry(String protocolName) throws ProtocolNotFoundException {
        Map<String, Protocol> map = this.protocols;
        synchronized (map) {
            Protocol protocol = this.protocols.get(protocolName);
            if (protocol == null) {
                throw new ProtocolNotFoundException(protocolName);
            }
            return protocol.getLocalRegistry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<ServerId> getRefOnLocalRegistries() {
        Map<String, Protocol> map = this.protocols;
        synchronized (map) {
            HashSet<ServerId> serverRefs = new HashSet<ServerId>();
            for (Protocol protocol : this.protocols.values()) {
                serverRefs.add(protocol.getLocalRegistry());
            }
            return serverRefs;
        }
    }

    @Override
    public final JMXServiceURL getJMXServiceURL(String protocolName) {
        return CMIAdminConnectorManager.getJMXServiceURL(protocolName);
    }

    protected abstract void initStats();

    @Override
    public final boolean isReplicated(String objectName) throws ObjectNotFoundException {
        return this.isReplicationManagerStarted() && this.getDistributedObjectInfo(objectName).isReplicated();
    }

    @Override
    public final Set<String> getApplicationExceptionNames(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getApplicationExceptionNames();
    }

    @Override
    public final boolean hasState(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).isStateful();
    }

    @Override
    public final boolean isReplicationManagerStarted() {
        return this.replicationManagerStarted;
    }

    @Override
    public final void setReplicationManagerStarted(boolean replicationManagerStarted) {
        this.replicationManagerStarted = replicationManagerStarted;
    }

    @Override
    public final Map<String, Set<String>> getAvailablePoliciesAndStrategies() {
        HashMap<String, Set<String>> ret = new HashMap<String, Set<String>>();
        ret.put("policies", new HashSet<String>(this.policyStrategyManager.getPolicyClassNames()));
        ret.put("strategies", new HashSet<String>(this.policyStrategyManager.getStrategyClassNames()));
        return ret;
    }

    public final boolean isEmbeddedPolicy(String className) {
        return this.policyStrategyManager.isEmbeddedPolicy(className);
    }

    public final boolean isEmbeddedStrategy(String className) {
        return this.policyStrategyManager.isEmbeddedStrategy(className);
    }

    @Override
    public final Object addLoadBalancingArchive(byte[] bytesOfFile, String location, Class<?>[] policies, Class<?>[] strategies) {
        LOGGER.debug("Sending new load balancing archive located at '{0}'. Step 3: server-side manager is delegating reception to policy/stretegy manager ", location);
        return this.policyStrategyManager.addLoadBalancingArchive(bytesOfFile, location, policies, strategies);
    }

    @Override
    public final void removeLoadBalancingArchive(Object archiveId, String[] policies, String[] strategies, boolean isArchiveOwner) throws Exception {
        this.policyStrategyManager.removeLoadBalancingArchive(archiveId, policies, strategies, isArchiveOwner);
    }

    public abstract void broadCastArchive(Object var1, byte[] var2);

    public abstract boolean isAlreadyDistributed(Object var1);

    public abstract void removeDistributedArchive(Object var1);

    public final IPolicyStrategyManager getPolicyStrategyManager() {
        return this.policyStrategyManager;
    }

    public final void setPolicyStrategyManager(IPolicyStrategyManager policyStrategyManager) {
        this.policyStrategyManager = policyStrategyManager;
    }

    public final IPolicyStrategyLoader getPolicyStrategyLoader() {
        return this.policyStrategyLoader;
    }

    public final void setPolicyStrategyLoader(IPolicyStrategyLoader policyStrategyLoader) {
        this.policyStrategyLoader = policyStrategyLoader;
    }

    @Override
    public final Set<ServerId> getServerRefs(String protocolName) {
        HashSet<ServerId> serverRefs = new HashSet<ServerId>();
        for (String objectName : this.getObjectNames()) {
            try {
                for (CMIReference cmiRef : this.getCMIReferences(objectName, protocolName)) {
                    serverRefs.add((ServerId)cmiRef.getServerRef());
                }
            }
            catch (ObjectNotFoundException e) {
            }
        }
        return serverRefs;
    }

    @Override
    public final Set<ServerId> getRefsOnRegistries(String serverName) {
        HashSet<ServerId> serverRefs = new HashSet<ServerId>();
        for (String objectName : this.getObjectNames()) {
            try {
                for (CMIReference cmiRef : this.getCMIReferences(objectName)) {
                    ServerId serverId = (ServerId)cmiRef.getServerRef();
                    if (!serverId.getServerName().equals(serverName)) continue;
                    serverRefs.add(serverId);
                }
            }
            catch (ObjectNotFoundException e) {
            }
        }
        return serverRefs;
    }

    @Override
    public final Set<String> getServerObjectForProtocol(String serverUrl, String protocolName) {
        HashSet<String> objectRefs = new HashSet<String>();
        for (String objectName : this.getObjectNames()) {
            try {
                for (CMIReference cmiRef : this.getCMIReferences(objectName, protocolName)) {
                    if (!cmiRef.getServerRef().getProviderURL().equals(serverUrl)) continue;
                    objectRefs.add(objectName);
                }
            }
            catch (ObjectNotFoundException e) {
            }
        }
        return objectRefs;
    }

    @Override
    public final Collection<CMIReference> getCMIReferences(String objectName, String protocolName, Set<Object> qualities) throws ObjectNotFoundException {
        Collection<CMIReference> cmiReferences = this.getCMIReferences(objectName, protocolName);
        if (qualities != null) {
            cmiReferences = this.applyFilters(cmiReferences, qualities);
        }
        return cmiReferences;
    }

    @Override
    public void removeCMIReference(CMIReference cmiReference) {
        if (this.doRemoveCMIReference(cmiReference)) {
            this.getEventDispatcher().dispatch(new EventObjectRemoved(cmiReference.getObjectName()));
        }
    }

    protected abstract boolean doRemoveCMIReference(CMIReference var1);

    @Override
    public final Set<String> getDomainNames() {
        HashSet<String> domainNames = new HashSet<String>();
        for (String objectName : this.getObjectNames()) {
            try {
                for (CMIReference cmiRef : this.getCMIReferences(objectName)) {
                    domainNames.add(((ServerId)cmiRef.getServerRef()).getDomainName());
                }
            }
            catch (ObjectNotFoundException e) {
            }
        }
        return domainNames;
    }

    @Override
    public final Set<String> getServerNames(String domainName) {
        HashSet<String> serverNames = new HashSet<String>();
        for (String objectName : this.getObjectNames()) {
            try {
                for (CMIReference cmiRef : this.getCMIReferences(objectName)) {
                    ServerId serverId = (ServerId)cmiRef.getServerRef();
                    if (!serverId.getDomainName().equals(domainName)) continue;
                    serverNames.add(serverId.getServerName());
                }
            }
            catch (ObjectNotFoundException e) {
            }
        }
        return serverNames;
    }

    @Override
    public final Set<ServerId> getBlacklistedServers() {
        HashSet<ServerId> serverIds = new HashSet<ServerId>();
        for (String objectName : this.getObjectNames()) {
            try {
                for (CMIReference cmiRef : this.getCMIReferences(objectName)) {
                    ServerId serverId = (ServerId)cmiRef.getServerRef();
                    if (!this.isServerBlackListed(serverId)) continue;
                    serverIds.add(serverId);
                }
            }
            catch (ObjectNotFoundException e) {
            }
        }
        return serverIds;
    }

    @Override
    public final Set<CMIReference> getCMIRefsForServerRef(ServerRef serverRef) {
        HashSet<CMIReference> cmiRefs = new HashSet<CMIReference>();
        for (String objectName : this.getObjectNames()) {
            try {
                for (CMIReference cmiRef : this.getCMIReferences(objectName)) {
                    ServerRef serverId = cmiRef.getServerRef();
                    if (!serverId.equals(serverRef)) continue;
                    cmiRefs.add(cmiRef);
                }
            }
            catch (ObjectNotFoundException e) {
            }
        }
        return cmiRefs;
    }

    @Override
    public final List<IFilter> getFilters(String objectName) throws ObjectNotFoundException {
        return new ArrayList<IFilter>(this.getDistributedObjectInfo(objectName).getFilters());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addFilter(String objectName, IFilter filter) throws ObjectNotFoundException {
        DistributedObjectInfo distributedObjectInfo;
        if (!(filter instanceof Serializable)) {
            throw new IllegalArgumentException("The provided filter is not serializable.");
        }
        DistributedObjectInfo distributedObjectInfo2 = distributedObjectInfo = this.getDistributedObjectInfo(objectName);
        synchronized (distributedObjectInfo2) {
            distributedObjectInfo.addFilter(filter);
            this.setDistributedObjectInfo(objectName, distributedObjectInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean removeFilter(String objectName, IFilter filter) throws ObjectNotFoundException {
        boolean deleted;
        DistributedObjectInfo distributedObjectInfo;
        DistributedObjectInfo distributedObjectInfo2 = distributedObjectInfo = this.getDistributedObjectInfo(objectName);
        synchronized (distributedObjectInfo2) {
            deleted = distributedObjectInfo.removeFilter(filter);
            this.setDistributedObjectInfo(objectName, distributedObjectInfo);
        }
        return deleted;
    }

    protected final Collection<CMIReference> applyFilters(Collection<CMIReference> cmiReferences, Set<Object> qualities) throws ObjectNotFoundException {
        if (cmiReferences.isEmpty()) {
            return cmiReferences;
        }
        List<CMIReference> availables = new ArrayList<CMIReference>(cmiReferences);
        for (IFilter localFilter : this.localFilters) {
            if (!localFilter.accept(qualities)) continue;
            availables = localFilter.choose(availables);
        }
        for (IFilter globalFilter : this.getGlobalFilters()) {
            if (!globalFilter.accept(qualities)) continue;
            availables = globalFilter.choose(availables);
        }
        String objectName = ((CMIReference)cmiReferences.toArray()[0]).getObjectName();
        for (IFilter objectFilter : this.getFilters(objectName)) {
            if (!objectFilter.accept(qualities)) continue;
            availables = objectFilter.choose(availables);
        }
        return availables;
    }

    @Override
    public final IUpdatedClientConfig getClientConfig() {
        UpdatedClientConfig clientConfig = new UpdatedClientConfig();
        return clientConfig;
    }

    protected final void updatePool(DistributedObjectInfo oldDistributedObjectInfo, DistributedObjectInfo newDistributedObjectInfo) throws ObjectNotFoundException {
        String objectName = newDistributedObjectInfo.getObjectName();
        if (this.hasPool(objectName)) {
            IPoolConfiguration newPoolConfiguration = newDistributedObjectInfo.getPoolConfiguration();
            if (oldDistributedObjectInfo != null) {
                IPoolConfiguration oldPoolConfiguration = oldDistributedObjectInfo.getPoolConfiguration();
                if (oldPoolConfiguration != null) {
                    if (newPoolConfiguration == null) {
                        newPoolConfiguration = new PoolConfiguration();
                    }
                    if (!oldPoolConfiguration.equals(newPoolConfiguration)) {
                        this.getPool(objectName).setPoolConfiguration(newPoolConfiguration);
                    }
                }
            } else if (newPoolConfiguration != null && newPoolConfiguration != new PoolConfiguration()) {
                this.getPool(objectName).setPoolConfiguration(newPoolConfiguration);
            }
        }
    }

    @Override
    public final ImmutableClusteredObjectInfos getImmutableInfos(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName);
    }
}

