/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.controller.server.impl.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import net.jcip.annotations.ThreadSafe;
import org.ow2.cmi.admin.MBeanUtils;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.controller.provider.ServerClusterViewProvider;
import org.ow2.cmi.controller.server.AbsServerClusterViewManager;
import org.ow2.cmi.controller.server.ClusterView;
import org.ow2.cmi.controller.server.DistributedObjectInfo;
import org.ow2.cmi.controller.server.Domain;
import org.ow2.cmi.controller.server.ServerClusterViewManagerException;
import org.ow2.cmi.controller.server.ServerView;
import org.ow2.cmi.controller.server.filter.IFilter;
import org.ow2.cmi.controller.server.impl.jms.Config;
import org.ow2.cmi.controller.server.impl.jms.JMSClusterViewManagerException;
import org.ow2.cmi.controller.server.impl.jms.JORAMHelper;
import org.ow2.cmi.controller.server.impl.jms.JORAMServer;
import org.ow2.cmi.controller.server.impl.jms.JORAMServerException;
import org.ow2.cmi.controller.server.impl.jms.JmsProvider;
import org.ow2.cmi.lb.ILoadBalancerTweaker;
import org.ow2.cmi.lb.data.PolicyData;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.ObjectNotFoundException;
import org.ow2.cmi.reference.ServerId;
import org.ow2.cmi.reference.ServerNotFoundException;
import org.ow2.cmi.reference.ServerRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class JMSClusterViewManager
extends AbsServerClusterViewManager
implements MessageListener,
NotificationListener {
    private static Log logger = LogFactory.getLog(JMSClusterViewManager.class);
    private static final String PROVIDER_URL_PROPERTY = "providerUrl";
    private static final String ACTION_PROPERTY = "action";
    private static final String TYPE_PROPERTY = "type";
    private static final String ADD_ACTION = "add";
    private static final String REM_ACTION = "rem";
    private static final String SET_ACTION = "set";
    private static final String CMIIREF_TYPE = "cmiref";
    private static final String OBJINFO_TYPE = "objinfo";
    private static final String DELAY_TYPE = "delay";
    private static final String FILTER_TYPE = "filter";
    private static final String SERVER_TYPE = "server";
    private static final String VALUE_PROPERTY = "value";
    private static final String BLACKLIST_TYPE = "blacklist";
    private static final String LOAD_TYPE = "load";
    private Topic topic;
    private MessageConsumer subscriber;
    private MessageProducer publisher;
    private Connection topicConnection;
    private Session sessionSubscriber;
    private Session sessionPublisher;
    private ClusterView clusterView = new ClusterView();
    private ObjectName delegate;
    private ObjectName objectNameToListen;
    private ServerId localRegistryId;
    private ClusterViewCleaner clusterViewCleaner;
    private Heartbeat heartbeat;
    private JORAMServer joramServer;

    @Override
    public void doStart() throws JMSClusterViewManagerException {
        if (this.isDistributed() && (this.getExtTopicJNDIName() == null || this.getLocalTopicJNDIName() == null)) {
            logger.error("Invalid configuration: in a distributed config, the JNDI names have to be specified for both the local and external topic", new Object[0]);
            throw new JMSClusterViewManagerException("Invalid configuration: in a distributed config, the JNDI names have to be specified for both the local and external topic");
        }
        if (!this.isDistributed()) {
            if (this.getExtTopicJNDIName() == null && this.getLocalTopicJNDIName() == null) {
                logger.error("Invalid configuration: no topic JNDI name specified", new Object[0]);
                throw new JMSClusterViewManagerException("Invalid configuration: no topic JNDI name specified");
            }
            if (this.getExtTopicJNDIName() != null && this.getLocalTopicJNDIName() != null) {
                logger.error("Invalid configuration: in a non distributed config, the JNDI names have to be specified for either the local topic or the external topic", new Object[0]);
                throw new JMSClusterViewManagerException("Invalid configuration: in a non distributed config, the JNDI names have to be specified for either the local topic or the external topic");
            }
        }
        if (!this.isSubscriber() && !this.isPublisher()) {
            logger.error("Invalid configuration: neither a subscriber and nor a publisher", new Object[0]);
            throw new JMSClusterViewManagerException("Invalid configuration: neither a subscriber and nor a publisher");
        }
        if (((Config)this.getConfig()).isJmsServerEmbedded()) {
            this.joramServer = new JORAMServer((Config)this.getConfig());
            try {
                this.joramServer.start();
            }
            catch (JORAMServerException e) {
                logger.error("Unable to start an embedded instance of JORAM server", e);
                throw new JMSClusterViewManagerException("Unable to start an embedded instance of JORAM server", e);
            }
            this.setRegistrationOpened(true);
        } else {
            if (this.getObjectNameToListen() != null) {
                try {
                    this.objectNameToListen = new ObjectName(this.getObjectNameToListen());
                }
                catch (Exception e) {
                    logger.error("Unable to check if JMS is available", e);
                    throw new JMSClusterViewManagerException("Unable to check if JMS is available", e);
                }
            }
            if (this.getObjectNameToListen() == null || MBeanUtils.getMBeanServer().isRegistered(this.objectNameToListen)) {
                this.setRegistrationOpened(true);
            } else {
                try {
                    this.delegate = new ObjectName("JMImplementation:type=MBeanServerDelegate");
                    MBeanUtils.getMBeanServer().addNotificationListener(this.delegate, this, null, null);
                }
                catch (Exception e) {
                    logger.error("Unable to add the listener for JMS", e);
                    throw new JMSClusterViewManagerException("Unable to add the listener for JMS", e);
                }
                logger.info("CMI server waiting for a JMS implementation...", new Object[0]);
            }
        }
    }

    @Override
    public void doStop() throws JMSClusterViewManagerException {
        this.removeLocalServerView();
        this.setRegistrationOpened(false);
        this.setImplementationAvailable(false);
        this.closeConnection();
        this.clusterView.clear();
        if (this.delegate != null && MBeanUtils.getMBeanServer().isRegistered(this.delegate)) {
            try {
                MBeanUtils.getMBeanServer().removeNotificationListener(this.delegate, this);
            }
            catch (Exception e) {
                logger.warn("Unable to remove the listener for JMS", e);
            }
        }
        if (this.joramServer != null) {
            this.joramServer.stop();
        }
    }

    private boolean isDistributed() {
        return this.isClustered() || this.isHierarchical();
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (notification.getType().equals("JMX.mbean.registered")) {
            if (notification instanceof MBeanServerNotification && this.objectNameToListen.equals(((MBeanServerNotification)notification).getMBeanName())) {
                this.setRegistrationOpened(true);
                if (this.getState().equals((Object)ClusterViewManager.State.STARTED)) {
                    try {
                        new InitialContext();
                    }
                    catch (NamingException e) {
                        logger.warn("Unable to create a cmi context", e);
                    }
                }
            }
        } else if (notification.getType().equals("JMX.mbean.unregistered") && notification instanceof MBeanServerNotification && this.objectNameToListen.equals(((MBeanServerNotification)notification).getMBeanName())) {
            logger.warn("JMS no more available: auto-stopping the CMI server.", new Object[0]);
            this.sessionPublisher = null;
            this.sessionSubscriber = null;
            this.publisher = null;
            this.subscriber = null;
            this.topicConnection = null;
            this.topic = null;
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void initServerConfig(String contextFactory, ServerId serverId, Context cmiContext) throws ServerClusterViewManagerException {
        Topic extTopic;
        ServerView serverView;
        block53: {
            if (this.localRegistryId != null) return;
            this.localRegistryId = serverId;
            Short id = ((Config)this.getConfig()).getServerId();
            if (id == null) {
                logger.error("Invalid configuration: server id missing!", new Object[0]);
                throw new JMSClusterViewManagerException("Invalid configuration: server id missing!");
            }
            try {
                serverView = new ServerView(this.localRegistryId, id, JORAMHelper.getServerName());
            }
            catch (JORAMServerException e) {
                logger.error("Unable to retrieve the local server name", e);
                throw new JMSClusterViewManagerException("Unable to retrieve the local server name", e);
            }
            serverView.addDomain(new Domain(this.getDomainName(), this.getDomainPort()));
            extTopic = null;
            Context extContext = null;
            if (this.getExtProviderURL() != null) {
                Hashtable<String, String> env = null;
                env = new Hashtable<String, String>();
                env.put("java.naming.factory.initial", contextFactory);
                env.put("java.naming.provider.url", this.getExtProviderURL());
                try {
                    extContext = new InitialContext(env);
                }
                catch (NamingException e) {
                    logger.error("Unable to create a context", e);
                    throw new JMSClusterViewManagerException("Unable to create a context", e);
                }
            } else if (this.isDistributed()) {
                extContext = cmiContext;
            }
            try {
                this.clusterView = this.retrieveClusterView(cmiContext);
            }
            catch (Exception e) {
                logger.warn("Cannot retrieve the cluster view: no provider found for the jndi name {0}", this.getJmsProviderName(), e);
            }
            if (extContext != null) {
                try {
                    ConnectionFactory cf;
                    try {
                        extTopic = (Topic)extContext.lookup(this.getExtTopicJNDIName());
                    }
                    catch (NamingException e) {
                        logger.error("Unable to retrieve the external topic with name " + this.getExtTopicJNDIName(), e);
                        throw new JMSClusterViewManagerException("Unable to retrieve the external topic with name " + this.getExtTopicJNDIName(), e);
                    }
                    if (extContext instanceof ILoadBalancerTweaker) {
                        ServerRef lastServerRef = ((ILoadBalancerTweaker)((Object)cmiContext)).getLastServerRef();
                        ((ILoadBalancerTweaker)((Object)cmiContext)).setNextServerRef(lastServerRef);
                    }
                    this.topic = extTopic;
                    try {
                        cf = (ConnectionFactory)extContext.lookup(this.getConnectionFactoryName());
                    }
                    catch (NamingException e) {
                        logger.error("Unable to retrieve the connection factory with name " + this.getConnectionFactoryName(), e);
                        throw new JMSClusterViewManagerException("Unable to retrieve the connection factory with name " + this.getConnectionFactoryName(), e);
                    }
                    this.initConnection(cf, this.isDistributed());
                    if (extContext instanceof ILoadBalancerTweaker) {
                        ((ILoadBalancerTweaker)((Object)cmiContext)).setNextServerRef(null);
                    }
                    HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
                    properties.put(ACTION_PROPERTY, (Serializable)((Object)ADD_ACTION));
                    properties.put(TYPE_PROPERTY, (Serializable)((Object)SERVER_TYPE));
                    this.sendMessage(serverView, properties);
                    if (this.getExtProviderURL() == null || extContext == null) break block53;
                }
                catch (Throwable throwable) {
                    if (this.getExtProviderURL() == null) throw throwable;
                    if (extContext == null) throw throwable;
                    try {
                        extContext.close();
                        throw throwable;
                    }
                    catch (NamingException e) {
                        logger.debug("Unable to close the context", e);
                    }
                    throw throwable;
                }
                try {
                    extContext.close();
                }
                catch (NamingException e) {
                    logger.debug("Unable to close the context", e);
                }
            }
        }
        if (this.isDistributed()) {
            this.closeConnection();
            try {
                JORAMHelper.setDistributedConfig((Config)this.getConfig(), this.clusterView);
            }
            catch (JORAMServerException e) {
                logger.error("Unable to set a distributed config", e);
                throw new JMSClusterViewManagerException("Unable to set a distributed config", e);
            }
        }
        if (this.getLocalTopicJNDIName() != null) {
            String localProviderURL = serverId.getProviderURL();
            InitialContext localContext = null;
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", contextFactory);
            env.put("java.naming.provider.url", localProviderURL);
            try {
                localContext = new InitialContext(env);
            }
            catch (NamingException e) {
                logger.error("Unable to create a context", e);
                throw new JMSClusterViewManagerException("Unable to create a context", e);
            }
            try {
                ConnectionFactory cf;
                try {
                    this.topic = (Topic)localContext.lookup(this.getLocalTopicJNDIName());
                    logger.debug("Topic found with name {0} in the local registry", this.getLocalTopicJNDIName());
                }
                catch (NamingException e) {
                    logger.debug("No topic found with name {0} in the local registry.", this.getLocalTopicJNDIName(), e);
                    this.topic = null;
                }
                if (this.topic == null) {
                    try {
                        this.topic = JORAMHelper.createTopic(this.getLocalTopicName(), extTopic, this.isClustered(), this.isHierarchical());
                    }
                    catch (Exception e) {
                        logger.error("Cannot create the topic {0}", this.getLocalTopicName(), e);
                        throw new JMSClusterViewManagerException("Cannot create the topic " + this.getLocalTopicName(), e);
                    }
                    try {
                        localContext.rebind(this.getLocalTopicJNDIName(), (Object)this.topic);
                        logger.debug("My topic with name {0} has been bound", this.getLocalTopicJNDIName());
                    }
                    catch (NamingException e) {
                        logger.warn("Unable to bind my topic with name " + this.getLocalTopicJNDIName(), new Object[0]);
                    }
                } else if (this.isDistributed()) {
                    try {
                        JORAMHelper.checkMyTopic(this.topic, extTopic, this.isClustered(), this.isHierarchical());
                    }
                    catch (JORAMServerException e) {
                        logger.warn("The topic checking has failed", e);
                    }
                }
                if (this.joramServer != null) {
                    try {
                        localContext.rebind(this.getConnectionFactoryName(), (Object)this.joramServer.getTcpConnectionFactory());
                    }
                    catch (NamingException e) {
                        logger.error("Unable to bind the TCP connection factory", e);
                        throw new JMSClusterViewManagerException("Unable to bind the TCP connection factory", e);
                    }
                    cf = this.joramServer.getLocalConnectionFactory();
                } else {
                    try {
                        cf = (ConnectionFactory)localContext.lookup(this.getConnectionFactoryName());
                    }
                    catch (NamingException e) {
                        logger.error("Unable to retrieve the connection factory with name " + this.getConnectionFactoryName(), e);
                        throw new JMSClusterViewManagerException("Unable to retrieve the connection factory with name " + this.getConnectionFactoryName(), e);
                    }
                }
                this.initConnection(cf, false);
            }
            catch (Throwable throwable) {
                try {
                    localContext.close();
                    throw throwable;
                }
                catch (NamingException e) {
                    logger.warn("Unable to close the context", e);
                }
                throw throwable;
            }
            try {
                localContext.close();
            }
            catch (NamingException e) {
                logger.warn("Unable to close the context", e);
            }
        }
        this.clusterView.addServerView(this.localRegistryId.getProviderURL(), serverView);
        super.initServerConfig(contextFactory, serverId, cmiContext);
        if (this.isClusterViewShared()) {
            this.bindClusterViewProvider(contextFactory, serverId);
        }
        this.setImplementationAvailable(true);
        logger.info("CMI server available.", new Object[0]);
        this.initHeartBeat();
        if (!this.isSubscriber()) return;
        this.initClusterViewCleaner();
    }

    private void initClusterViewCleaner() {
        this.clusterViewCleaner = new ClusterViewCleaner();
        this.getCmiThreadFactory().newThread(this.clusterViewCleaner, "Cluster View Cleaner").start();
    }

    private void initHeartBeat() {
        this.heartbeat = new Heartbeat();
        this.getCmiThreadFactory().newThread(this.heartbeat, "Heart Beat").start();
    }

    private void bindClusterViewProvider(String contextFactory, ServerId serverId) throws JMSClusterViewManagerException {
        JmsProvider jmsProvider;
        String myProviderURL = serverId.getProviderURL();
        InitialContext myContext = null;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", contextFactory);
        env.put("java.naming.provider.url", myProviderURL);
        try {
            myContext = new InitialContext(env);
        }
        catch (NamingException e) {
            logger.error("Unable to create a context", e);
            throw new JMSClusterViewManagerException("Unable to create a context", e);
        }
        try {
            jmsProvider = new JmsProvider(this);
        }
        catch (RemoteException e) {
            logger.error("Unable to create the JMS Provider", e);
            throw new JMSClusterViewManagerException("Unable to create the JMS Provider", e);
        }
        try {
            myContext.rebind(this.getJmsProviderName(), (Object)jmsProvider);
            logger.debug("The JMS provider with name {0} has been bound", this.getJmsProviderName());
        }
        catch (NamingException e) {
            logger.error("Cannot share the cluster view provider with name " + this.getJmsProviderName(), e);
            throw new JMSClusterViewManagerException("Cannot share the cluster view provider with name " + this.getJmsProviderName(), e);
        }
    }

    private void initConnection(ConnectionFactory cf, boolean publisherOnly) throws JMSClusterViewManagerException {
        try {
            this.topicConnection = cf.createConnection();
            if (this.isSubscriber() && !publisherOnly) {
                this.sessionSubscriber = this.topicConnection.createSession(false, 1);
                this.subscriber = this.sessionSubscriber.createConsumer(this.topic);
                this.subscriber.setMessageListener(this);
            }
            if (this.isPublisher() || publisherOnly) {
                this.sessionPublisher = this.topicConnection.createSession(false, 1);
                this.publisher = this.sessionPublisher.createProducer(this.topic);
            }
            this.topicConnection.start();
        }
        catch (JMSException e) {
            logger.error("Unable to initialize a connection", e);
            throw new JMSClusterViewManagerException("Unable to initialize a connection", e);
        }
    }

    private void closeConnection() throws JMSClusterViewManagerException {
        try {
            if (this.topicConnection != null) {
                this.topicConnection.close();
                this.topicConnection = null;
            }
            if (this.publisher != null) {
                this.publisher.close();
                this.publisher = null;
            }
            if (this.subscriber != null) {
                this.subscriber.close();
                this.subscriber = null;
            }
            if (this.sessionSubscriber != null) {
                this.sessionSubscriber.close();
                this.sessionSubscriber = null;
            }
            if (this.sessionPublisher != null) {
                this.sessionPublisher.close();
                this.sessionPublisher = null;
            }
        }
        catch (JMSException e) {
            logger.error("Unable to close the connection", e);
            throw new JMSClusterViewManagerException("Unable to close the connection", e);
        }
    }

    private ClusterView retrieveClusterView(Context cmiContext) throws RemoteException, NamingException {
        ClusterView cView = ((ServerClusterViewProvider)cmiContext.lookup(this.getJmsProviderName())).getClusterView();
        logger.debug("Cluster view retrieved: {0}", this.clusterView);
        return cView;
    }

    private void removeLocalServerView() {
        ServerId serverId = this.getLocalServer();
        try {
            this.removeServerView(serverId.getProviderURL());
        }
        catch (ServerNotFoundException e) {
            logger.warn("Unable to remove my-self from the cluster view!", e);
        }
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put(ACTION_PROPERTY, (Serializable)((Object)REM_ACTION));
        properties.put(TYPE_PROPERTY, (Serializable)((Object)SERVER_TYPE));
        this.sendMessage(null, properties);
    }

    private void addServerView(String providerUrl, ServerView serverView) throws JMSClusterViewManagerException {
        if (this.clusterView.addServerView(providerUrl, serverView) && this.getDomainName() != null && !this.localRegistryId.getProviderURL().equals(providerUrl)) {
            try {
                JORAMHelper.addDomain((Config)this.getConfig());
                JORAMHelper.addServer(serverView, this.getDomainName());
            }
            catch (JORAMServerException e) {
                logger.error("Unable to update the distributed config!", e);
                throw new JMSClusterViewManagerException("Unable to update the distributed config!", e);
            }
        }
    }

    private void removeServerView(String providerUrl) throws ServerNotFoundException {
        Domain domain;
        this.clusterView.removeClusteredObjects(providerUrl);
        ServerView serverView = this.clusterView.removeServerView(providerUrl);
        if (serverView == null) {
            logger.error("Unknown server: " + providerUrl, new Object[0]);
            throw new ServerNotFoundException("Unknown server", providerUrl);
        }
        if (this.getDomainName() != null && !this.localRegistryId.getProviderURL().equals(providerUrl) && (domain = serverView.getDomain(this.getDomainName())) != null) {
            try {
                JORAMHelper.removeServer(this.topic, serverView.getId());
            }
            catch (JORAMServerException e) {
                logger.warn("Unable to update the distributed config!", e);
            }
        }
    }

    @Override
    protected boolean containObject(String objectName) {
        return this.clusterView.containsObject(objectName);
    }

    @Override
    protected DistributedObjectInfo getDistributedObjectInfo(String objectName) throws ObjectNotFoundException {
        return this.clusterView.getObjectInfo(objectName);
    }

    @Override
    public void broadCastArchive(Object archiveId, byte[] bytesOfFile) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    protected void initStats() {
    }

    @Override
    public boolean isAlreadyDistributed(Object archiveId) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public void removeDistributedArchive(Object archiveId) {
        throw new UnsupportedOperationException("TODO");
    }

    private void sendMessage(Object data, Map<String, Serializable> properties) {
        if (this.isPublisher()) {
            if (!(data instanceof Serializable)) {
                throw new IllegalArgumentException("The provided object is not serializable.");
            }
            try {
                Message msg;
                if (data == null) {
                    msg = this.sessionPublisher.createMessage();
                } else {
                    msg = this.sessionPublisher.createBytesMessage();
                    ((BytesMessage)msg).writeBytes(this.serialize(data));
                }
                for (Map.Entry<String, Serializable> entry : properties.entrySet()) {
                    msg.setObjectProperty(entry.getKey(), entry.getValue());
                }
                msg.setStringProperty(PROVIDER_URL_PROPERTY, this.getLocalServer().getProviderURL());
                this.publisher.send(msg);
            }
            catch (Exception e) {
                logger.warn("Unable to send a message to add {0} with properties {1}", data, properties, e);
            }
        }
    }

    private ServerId getLocalServer() {
        return this.localRegistryId;
    }

    @Override
    protected void addDistributedObjectInfo(String objectName, DistributedObjectInfo distributedObjectInfo) {
        this.addLocalDistributedObjectInfo(objectName, distributedObjectInfo);
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put(ACTION_PROPERTY, (Serializable)((Object)ADD_ACTION));
        properties.put(TYPE_PROPERTY, (Serializable)((Object)OBJINFO_TYPE));
        this.sendMessage(distributedObjectInfo, properties);
    }

    @Override
    protected void setDistributedObjectInfo(String objectName, DistributedObjectInfo distributedObjectInfo) {
        this.setLocalDistributedObjectInfo(objectName, distributedObjectInfo);
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put(ACTION_PROPERTY, (Serializable)((Object)SET_ACTION));
        properties.put(TYPE_PROPERTY, (Serializable)((Object)OBJINFO_TYPE));
        this.sendMessage(distributedObjectInfo, properties);
    }

    @Override
    public void addCMIReference(CMIReference cmiReference) {
        this.addLocalCMIReference(cmiReference);
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put(ACTION_PROPERTY, (Serializable)((Object)ADD_ACTION));
        properties.put(TYPE_PROPERTY, (Serializable)((Object)CMIIREF_TYPE));
        this.sendMessage(cmiReference, properties);
    }

    public List<CMIReference> getCMIReferences(String objectName) throws ObjectNotFoundException {
        return this.clusterView.getCMIReferences(objectName);
    }

    @Override
    public Collection<CMIReference> getCMIReferences(String objectName, String protocolName) throws ObjectNotFoundException {
        return this.clusterView.getCMIReferences(objectName, protocolName);
    }

    @Override
    public Set<String> getObjectNames() {
        return this.clusterView.getObjectNames();
    }

    private void setLocalDistributedObjectInfo(String objectName, DistributedObjectInfo distributedObjectInfo) {
        logger.debug("Updating the infos of {0} with {1}", objectName, distributedObjectInfo);
        DistributedObjectInfo oldDistributedObjectInfo = this.clusterView.addObjectInfo(distributedObjectInfo, true);
        if (!oldDistributedObjectInfo.equals(distributedObjectInfo)) {
            PolicyData policyData = oldDistributedObjectInfo.getPolicyData();
            if (!policyData.equals(distributedObjectInfo.getPolicyData())) {
                try {
                    this.updatePolicy(objectName);
                }
                catch (Exception e) {
                    logger.error("Cannot update the policy for the object with name " + objectName, e);
                }
            }
            try {
                this.updatePool(oldDistributedObjectInfo, distributedObjectInfo);
            }
            catch (ObjectNotFoundException e) {
                logger.error("Cannot update the pool configuration for the object with name " + objectName, e);
            }
        }
    }

    private void addLocalDistributedObjectInfo(String objectName, DistributedObjectInfo distributedObjectInfo) {
        logger.debug("Adding the infos of {0} with {1}", objectName, distributedObjectInfo);
        this.clusterView.addObjectInfo(distributedObjectInfo, false);
        try {
            this.updatePolicy(objectName);
        }
        catch (Exception e) {
            logger.warn("Cannot update the policy for the object with name " + objectName, e);
        }
        try {
            this.updatePool(null, distributedObjectInfo);
        }
        catch (ObjectNotFoundException e) {
            logger.warn("Cannot update the pool configuration for the object with name " + objectName, e);
        }
    }

    private void addLocalCMIReference(CMIReference cmiReference) {
        this.clusterView.addCMIReference(cmiReference);
    }

    @Override
    protected boolean doRemoveCMIReference(CMIReference cmiReference) {
        try {
            this.removeLocalCMIReference(cmiReference);
            HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
            properties.put(ACTION_PROPERTY, (Serializable)((Object)REM_ACTION));
            properties.put(TYPE_PROPERTY, (Serializable)((Object)CMIIREF_TYPE));
            this.sendMessage(cmiReference, properties);
            if (this.clusterView.getCMIReferences(cmiReference.getObjectName()).isEmpty()) {
                this.clusterView.removeCMIReference(cmiReference);
                return true;
            }
        }
        catch (ObjectNotFoundException e) {
            logger.debug("Cannot remove the CMIReference {0}", cmiReference, e);
        }
        return false;
    }

    private void removeLocalCMIReference(CMIReference cmiReference) throws ObjectNotFoundException {
        this.clusterView.removeCMIReference(cmiReference);
    }

    @Override
    public void setDelayToRefresh(int delay) {
        this.setLocalDelay(delay);
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put(ACTION_PROPERTY, (Serializable)((Object)SET_ACTION));
        properties.put(TYPE_PROPERTY, (Serializable)((Object)DELAY_TYPE));
        properties.put(VALUE_PROPERTY, Integer.valueOf(delay));
        this.sendMessage(null, properties);
    }

    @Override
    protected void initDelayToRefresh(int delayToRefresh) {
    }

    private void setLocalDelay(int delay) {
        this.clusterView.setDelay(delay);
    }

    @Override
    public int getDelayToRefresh() {
        return this.clusterView.getDelay();
    }

    @Override
    public List<IFilter> getGlobalFilters() {
        return this.clusterView.getFilters();
    }

    @Override
    public void addGlobalFilter(IFilter filter) throws IllegalArgumentException {
        this.addFilter(filter);
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put(ACTION_PROPERTY, (Serializable)((Object)ADD_ACTION));
        this.sendMessage(filter, properties);
    }

    @Override
    public void removeGlobalFilter(IFilter filter) {
        if (this.removeFilter(filter)) {
            HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
            properties.put(ACTION_PROPERTY, (Serializable)((Object)REM_ACTION));
            this.sendMessage(filter, properties);
        }
    }

    private void addFilter(IFilter filter) {
        this.clusterView.addFilter(filter);
    }

    private boolean removeFilter(IFilter filter) {
        return this.clusterView.removeFilter(filter);
    }

    @Override
    public boolean isServerBlackListed(ServerRef serverRef) {
        return this.clusterView.isServerBlackListed(serverRef.getProviderURL());
    }

    @Override
    public void addServerToBlackList(ServerRef serverRef) {
        try {
            if (!this.clusterView.addServerToBlackList(serverRef.getProviderURL())) {
                HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
                properties.put(ACTION_PROPERTY, (Serializable)((Object)SET_ACTION));
                properties.put(TYPE_PROPERTY, (Serializable)((Object)BLACKLIST_TYPE));
                properties.put(VALUE_PROPERTY, Boolean.valueOf(true));
                this.sendMessage(null, properties);
            }
        }
        catch (ServerNotFoundException e) {
            logger.warn("Unable to add to the blacklist since unknown server: {0}", serverRef, e);
        }
    }

    @Override
    public void removeServerFromBlackList(ServerRef serverRef) {
        try {
            if (this.clusterView.removeServerFromBlackList(serverRef.getProviderURL())) {
                HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
                properties.put(ACTION_PROPERTY, (Serializable)((Object)SET_ACTION));
                properties.put(TYPE_PROPERTY, (Serializable)((Object)BLACKLIST_TYPE));
                properties.put(VALUE_PROPERTY, Boolean.valueOf(false));
                this.sendMessage(null, properties);
            }
        }
        catch (ServerNotFoundException e) {
            logger.warn("Unable to remove from the blacklist since unknown server: {0}", serverRef, e);
        }
    }

    @Override
    public Set<String> getClusterNames() {
        return this.clusterView.getClusterNames();
    }

    @Override
    public int getNbClientsConnectedToProvider() {
        return -1;
    }

    @Override
    public Set<String> getObjectNames(String clusterName) {
        return this.clusterView.getObjectNames(clusterName);
    }

    @Override
    public void registerClient(UUID uuid) {
    }

    @Override
    public boolean isPoolToEmpty(String objectName) throws ObjectNotFoundException {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public void addPoolToEmpty(String objectName) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public void removePoolToEmpty(String objectName) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public int getLoadFactor(ServerRef serverRef) throws ServerNotFoundException {
        return this.clusterView.getLoadFactor(serverRef.getProviderURL());
    }

    @Override
    public void setLoadFactor(ServerRef serverRef, int loadFactor) {
        try {
            if (this.clusterView.setLoadFactor(serverRef.getProviderURL(), loadFactor) != loadFactor) {
                HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
                properties.put(ACTION_PROPERTY, (Serializable)((Object)SET_ACTION));
                properties.put(TYPE_PROPERTY, (Serializable)((Object)LOAD_TYPE));
                properties.put(VALUE_PROPERTY, Integer.valueOf(loadFactor));
                this.sendMessage(null, properties);
            }
        }
        catch (ServerNotFoundException e) {
            logger.warn("Unable to set the loadfactor since unknown server: {0}", serverRef, e);
        }
    }

    @Override
    public long getDateOfConfiguration() {
        return -1L;
    }

    @Override
    public void onMessage(Message msg) {
        String type;
        String action;
        String providerURL;
        try {
            providerURL = msg.getStringProperty(PROVIDER_URL_PROPERTY);
        }
        catch (JMSException e) {
            logger.warn("Unable to retrieve the provider URL: ignoring the message {0}", msg, e);
            return;
        }
        if (providerURL == null) {
            logger.warn("Unable to retrieve the provider URL: ignoring the message {0}", msg);
            return;
        }
        try {
            action = msg.getStringProperty(ACTION_PROPERTY);
        }
        catch (JMSException e) {
            logger.warn("Unable to retrieve the action property: ignoring the message {0}", msg);
            return;
        }
        try {
            type = msg.getStringProperty(TYPE_PROPERTY);
        }
        catch (JMSException e) {
            logger.warn("Unable to retrieve the type property: ignoring the message {0}", msg);
            return;
        }
        Object value = null;
        if (msg instanceof BytesMessage) {
            BytesMessage bytesMessage = (BytesMessage)msg;
            try {
                value = this.unserialize(bytesMessage);
            }
            catch (Exception e) {
                logger.error("Cannot unserialize the bytes message {0}", bytesMessage, e);
                return;
            }
        }
        try {
            value = this.getValue(msg);
        }
        catch (JMSException e) {
            logger.warn("Unable to retrieve the value: ignoring the message {0}", msg);
            return;
        }
        if (!providerURL.equals(this.getLocalServer().getProviderURL())) {
            try {
                this.process(providerURL, action, type, value);
            }
            catch (ServerClusterViewManagerException e) {
                logger.warn("The processing has failed for the message: {0}", msg);
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void process(String providerURL, String action, String type, Object value) throws ServerClusterViewManagerException {
        if (action.equals(ADD_ACTION)) {
            if (type.equals(CMIIREF_TYPE)) {
                if (!(value instanceof CMIReference)) {
                    logger.error("Illegal value {0} for the specified type {1}", value, type);
                    throw new ServerClusterViewManagerException("Illegal value " + value + " for the specified type " + type);
                }
                logger.debug("A new object is available at this location: {0}", value);
                this.addLocalCMIReference((CMIReference)value);
                return;
            }
            if (type.equals(OBJINFO_TYPE)) {
                if (!(value instanceof DistributedObjectInfo)) {
                    logger.error("Illegal value {0} for the specified type {1}", value, type);
                    throw new ServerClusterViewManagerException("Illegal value " + value + " for the specified type " + type);
                }
                this.addLocalDistributedObjectInfo(((DistributedObjectInfo)value).getObjectName(), (DistributedObjectInfo)value);
                return;
            }
            if (type.equals(FILTER_TYPE)) {
                if (!(value instanceof IFilter)) {
                    logger.error("Illegal value {0} for the specified type {1}", value, type);
                    throw new ServerClusterViewManagerException("Illegal value " + value + " for the specified type " + type);
                }
                this.addFilter((IFilter)value);
                return;
            }
            if (!type.equals(SERVER_TYPE)) {
                logger.error("Unknown type {1} for the action {0}", action, type);
                throw new ServerClusterViewManagerException("Unknown type " + type + " for the action " + action);
            }
            if (!(value instanceof ServerView)) {
                logger.error("Illegal value {0} for the specified type {1}", value, type);
                throw new ServerClusterViewManagerException("Illegal value " + value + " for the specified type " + type);
            }
            this.addServerView(providerURL, (ServerView)value);
            return;
        }
        if (action.equals(REM_ACTION)) {
            if (type.equals(CMIIREF_TYPE)) {
                if (!(value instanceof CMIReference)) {
                    logger.error("Illegal value {0} for the specified type {1}", value, type);
                    throw new ServerClusterViewManagerException("Illegal value " + value + " for the specified type " + type);
                }
                logger.debug("A new object is to remove for this location: {0}", value);
                try {
                    this.removeLocalCMIReference((CMIReference)value);
                    return;
                }
                catch (ObjectNotFoundException e) {
                    logger.error("Cannot remove the CMIReference {0}", value, e);
                    throw new ServerClusterViewManagerException("Cannot remove the CMIReference " + value, e);
                }
            }
            if (type.equals(FILTER_TYPE)) {
                if (!(value instanceof IFilter)) {
                    logger.error("Illegal value {0} for the specified type {1}", value, type);
                    throw new ServerClusterViewManagerException("Illegal value " + value + " for the specified type " + type);
                }
                this.removeFilter((IFilter)value);
                return;
            }
            if (!type.equals(SERVER_TYPE)) {
                logger.error("Unknown type {1} for the action {0}", action, type);
                throw new ServerClusterViewManagerException("Unknown type " + type + " for the action " + action);
            }
            try {
                this.removeServerView(providerURL);
                return;
            }
            catch (ServerNotFoundException e) {
                logger.error("Unknown server: {0}", value, e);
                throw new ServerClusterViewManagerException("Unknown server: " + value, e);
            }
        }
        if (!action.equals(SET_ACTION)) {
            logger.error("Unknown action: {0}", action);
            throw new ServerClusterViewManagerException("Unknown action: " + action);
        }
        if (value instanceof DistributedObjectInfo) {
            this.setLocalDistributedObjectInfo(((DistributedObjectInfo)value).getObjectName(), (DistributedObjectInfo)value);
            return;
        }
        if (type.equals(BLACKLIST_TYPE)) {
            if (!(value instanceof Boolean)) {
                logger.error("Illegal value {0} for the specified type {1}", value, type);
                throw new ServerClusterViewManagerException("Illegal value " + value + " for the specified type " + type);
            }
            if (((Boolean)value).booleanValue()) {
                try {
                    this.clusterView.addServerToBlackList(providerURL);
                    return;
                }
                catch (ServerNotFoundException e) {
                    logger.error("Unknown server: {0}", value, e);
                    throw new ServerClusterViewManagerException("Unknown server: " + value, e);
                }
            }
            try {
                this.clusterView.removeServerFromBlackList(providerURL);
                return;
            }
            catch (ServerNotFoundException e) {
                logger.error("Unknown server: {0}", value, e);
                throw new ServerClusterViewManagerException("Unknown server: " + value, e);
            }
        }
        if (type.equals(LOAD_TYPE)) {
            if (!(value instanceof Integer)) {
                logger.error("Illegal value {0} for the specified type {1}", value, type);
                throw new ServerClusterViewManagerException("Illegal value " + value + " for the specified type " + type);
            }
            try {
                this.clusterView.setLoadFactor(providerURL, (Integer)value);
                return;
            }
            catch (ServerNotFoundException e) {
                logger.error("Unknown server: {0}", value, e);
                throw new ServerClusterViewManagerException("Unknown server: " + value, e);
            }
        }
        if (!type.equals(DELAY_TYPE)) {
            logger.error("Unknown type {1} for the action {0}", action, type);
            throw new ServerClusterViewManagerException("Unknown type " + type + " for the action " + action);
        }
        if (!(value instanceof Integer)) {
            logger.error("Illegal value {0} for the specified type {1}", value, type);
            throw new ServerClusterViewManagerException("Illegal value " + value + " for the specified type " + type);
        }
        this.setLocalDelay((Integer)value);
    }

    private Object getValue(Message msg) throws JMSException {
        return msg.getObjectProperty(VALUE_PROPERTY);
    }

    private byte[] serialize(Object object) throws IOException {
        ByteArrayOutputStream bOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(bOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        return bOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object unserialize(BytesMessage bytesMessage) throws IOException, JMSException, ClassNotFoundException {
        byte[] bytes = new byte[(int)bytesMessage.getBodyLength()];
        bytesMessage.readBytes(bytes);
        ObjectInputStream stream = new ObjectInputStream(new ByteArrayInputStream(bytes)){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                String name = desc.getName();
                return Class.forName(name, false, this.getClass().getClassLoader());
            }
        };
        try {
            Object object = stream.readObject();
            return object;
        }
        finally {
            stream.close();
        }
    }

    private String getExtTopicJNDIName() {
        return ((Config)this.getConfig()).getExtTopicJNDIName();
    }

    private String getLocalTopicJNDIName() {
        return ((Config)this.getConfig()).getLocalTopicJNDIName();
    }

    private String getLocalTopicName() {
        return ((Config)this.getConfig()).getLocalTopicName();
    }

    private String getExtProviderURL() {
        return ((Config)this.getConfig()).getExtProviderURL();
    }

    private boolean isClustered() {
        return ((Config)this.getConfig()).isClustered();
    }

    private boolean isHierarchical() {
        return ((Config)this.getConfig()).isHierarchical();
    }

    private boolean isClusterViewShared() {
        return ((Config)this.getConfig()).isClusterViewShared();
    }

    private String getObjectNameToListen() {
        return ((Config)this.getConfig()).getObjectNameToListen();
    }

    private String getJmsProviderName() {
        return ((Config)this.getConfig()).getJmsProviderName();
    }

    private String getConnectionFactoryName() {
        return ((Config)this.getConfig()).getConnectionFactoryName();
    }

    public long getPeriodToBeat() {
        return ((Config)this.getConfig()).getPeriodToBeat();
    }

    private long getPeriodToCleanUp() {
        return ((Config)this.getConfig()).getPeriodToCleanUp();
    }

    private long getWaitingBeatNumber() {
        return ((Config)this.getConfig()).getWaitingBeatNumber();
    }

    private boolean isPublisher() {
        return ((Config)this.getConfig()).isPublisher();
    }

    private boolean isSubscriber() {
        return ((Config)this.getConfig()).isSubscriber();
    }

    private String getDomainName() {
        return ((Config)this.getConfig()).getDomainName();
    }

    private short getDomainPort() {
        return ((Config)this.getConfig()).getDomainPort();
    }

    public ClusterView getClusterView() {
        return this.clusterView;
    }

    private class ClusterViewCleaner
    implements Runnable,
    MessageListener {
        private Map<String, Long> timestamps;

        private ClusterViewCleaner() {
        }

        public void run() {
            this.timestamps = new ConcurrentHashMap<String, Long>();
            try {
                Session session = JMSClusterViewManager.this.topicConnection.createSession(false, 1);
                MessageConsumer consumer = session.createConsumer(JMSClusterViewManager.this.topic);
                consumer.setMessageListener(this);
            }
            catch (JMSException e) {
                logger.error("Cannot init the consumer for the cluster view cleaner!", e);
                throw new RuntimeException("Cannot init the consumer for the cluster view cleaner!", e);
            }
            while (JMSClusterViewManager.this.isImplementationAvailable()) {
                try {
                    Thread.sleep(JMSClusterViewManager.this.getPeriodToCleanUp());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                logger.debug("Cleaning the cluster view...", new Object[0]);
                this.cleanClusterView();
            }
        }

        private synchronized void cleanClusterView() {
            HashSet<String> providerUrls = new HashSet<String>(JMSClusterViewManager.this.clusterView.getServerViews().keySet());
            for (String providerURL : providerUrls) {
                Long timestamp = this.timestamps.get(providerURL);
                if (timestamp == null || timestamp + JMSClusterViewManager.this.getPeriodToBeat() * JMSClusterViewManager.this.getWaitingBeatNumber() >= System.currentTimeMillis()) continue;
                if (providerURL.equals(JMSClusterViewManager.this.getLocalServer().getProviderURL())) {
                    logger.warn("The local registry doesn't anymore send heartbeats!", providerURL);
                    continue;
                }
                logger.debug("Removing {0}", providerURL);
                try {
                    JMSClusterViewManager.this.removeServerView(providerURL);
                }
                catch (ServerNotFoundException e) {
                    logger.warn("Error when removing " + providerURL, e);
                }
            }
        }

        public void onMessage(Message msg) {
            if (msg instanceof TextMessage) {
                try {
                    this.timestamps.put(msg.getStringProperty(JMSClusterViewManager.PROVIDER_URL_PROPERTY), msg.getJMSTimestamp());
                }
                catch (JMSException e) {
                    logger.warn("Cannot extract the content of {0}", msg, e);
                }
            }
        }
    }

    private class Heartbeat
    implements Runnable {
        private Heartbeat() {
        }

        public void run() {
            Message msg;
            MessageProducer producer;
            try {
                Session session = JMSClusterViewManager.this.topicConnection.createSession(false, 1);
                producer = session.createProducer(JMSClusterViewManager.this.topic);
                msg = session.createMessage();
                msg.setStringProperty(JMSClusterViewManager.PROVIDER_URL_PROPERTY, JMSClusterViewManager.this.getLocalServer().getProviderURL());
            }
            catch (JMSException e) {
                logger.error("Cannot init the producer for the heartbeat!", e);
                throw new RuntimeException("Cannot init the producer for the heartbeat!", e);
            }
            while (JMSClusterViewManager.this.isImplementationAvailable()) {
                try {
                    producer.send(msg);
                }
                catch (JMSException e) {
                    logger.warn("Cannot send a heartbeat!", e);
                }
                try {
                    Thread.sleep(JMSClusterViewManager.this.getPeriodToBeat());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

