/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.controller.server.impl.jms;

import java.net.ConnectException;
import java.util.Arrays;
import java.util.List;
import org.objectweb.joram.client.jms.Topic;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.admin.Server;
import org.ow2.cmi.controller.server.ClusterView;
import org.ow2.cmi.controller.server.Domain;
import org.ow2.cmi.controller.server.ServerView;
import org.ow2.cmi.controller.server.impl.jms.Config;
import org.ow2.cmi.controller.server.impl.jms.JORAMServerException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public final class JORAMHelper {
    private static Log logger = LogFactory.getLog(JORAMHelper.class);

    private JORAMHelper() {
    }

    public static javax.jms.Topic createTopic(String topicName, javax.jms.Topic extTopic, boolean clustered, boolean hierarchical) throws JORAMServerException {
        Topic topic;
        try {
            topic = Topic.create(topicName);
            topic.setFreeReading();
            topic.setFreeWriting();
            if (hierarchical && extTopic instanceof Topic) {
                topic.setParent((Topic)extTopic);
            } else if (clustered && extTopic instanceof Topic) {
                topic.addClusteredTopic((Topic)extTopic);
            }
        }
        catch (ConnectException e) {
            logger.error("Unable to create the topic with name " + topicName, e);
            throw new JORAMServerException("Unable to create the topic with name " + topicName, e);
        }
        catch (AdminException e) {
            logger.error("Unable to create the topic with name " + topicName, e);
            throw new JORAMServerException("Unable to create the topic with name " + topicName, e);
        }
        return topic;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void checkMyTopic(javax.jms.Topic localTopic, javax.jms.Topic extTopic, boolean clustered, boolean hierarchical) throws JORAMServerException {
        if (hierarchical && localTopic instanceof Topic && extTopic instanceof Topic) {
            try {
                Topic topic = ((Topic)localTopic).getHierarchicalFather();
                if (topic != null) {
                    if (((Object)topic).equals(extTopic)) return;
                    logger.error("Not a hierarchical topic as expected.", new Object[0]);
                    throw new JORAMServerException("Not a hierarchical topic as expected.");
                }
                ((Topic)localTopic).setParent((Topic)extTopic);
                return;
            }
            catch (ConnectException e) {
                logger.error("Unable to check the use of hierarchical topic", e);
                throw new JORAMServerException("Unable to check the use of hierarchical topic", e);
            }
            catch (AdminException e) {
                logger.error("Unable to check the use of hierarchical topic", e);
                throw new JORAMServerException("Unable to check the use of hierarchical topic", e);
            }
        }
        if (!clustered || !(localTopic instanceof Topic) || !(extTopic instanceof Topic)) return;
        try {
            List fellows = ((Topic)localTopic).getClusterFellows();
            if (fellows.contains(localTopic)) return;
            ((Topic)localTopic).addClusteredTopic((Topic)extTopic);
            return;
        }
        catch (ConnectException e) {
            logger.error("Unable to check the use of clustered topic", e);
            throw new JORAMServerException("Unable to check the use of clustered topic", e);
        }
        catch (AdminException e) {
            logger.error("Unable to check the use of clustered topic", e);
            throw new JORAMServerException("Unable to check the use of clustered topic", e);
        }
    }

    public static void setDistributedConfig(Config config, ClusterView clusterView) throws JORAMServerException {
        String domainName = config.getDomainName();
        if (domainName == null) {
            logger.error("Unable to set a distributed config without domain name!", new Object[0]);
            throw new JORAMServerException("Unable to set a distributed config without domain name!");
        }
        if (logger.isDebugEnabled()) {
            try {
                logger.debug("Servers belonging to the domain {0}: {1}", domainName, AdminModule.getServersIds(domainName));
            }
            catch (ConnectException e) {
                logger.debug("Unable to retrieve the servers belonging to the domain " + domainName, e);
            }
            catch (AdminException e) {
                logger.debug("Unable to retrieve the servers belonging to the domain " + domainName, e);
            }
        }
        try {
            JORAMHelper.addDomain(config);
            if (clusterView != null) {
                for (ServerView serverView : clusterView.getServerViews(domainName)) {
                    JORAMHelper.addServer(serverView, domainName);
                }
            }
        }
        catch (Exception e) {
            logger.error("Unable to administrate the JORAM server", e);
            throw new JORAMServerException("Unable to administrate the JORAM server", e);
        }
    }

    public static String getServerName() throws JORAMServerException {
        try {
            return AdminModule.getLocalServer().getName();
        }
        catch (ConnectException e) {
            logger.error("Unable to retrieve the local server name", e);
            throw new JORAMServerException("Unable to retrieve the local server name", e);
        }
        catch (AdminException e) {
            logger.error("Unable to retrieve the local server name", e);
            throw new JORAMServerException("Unable to retrieve the local server name", e);
        }
    }

    public static void addServer(ServerView serverView, String domainName) throws JORAMServerException {
        Domain domain = serverView.getDomain(domainName);
        if (domain != null) {
            try {
                Server[] servers;
                for (Server server : servers = AdminModule.getServers(domainName)) {
                    if (server.getId() != serverView.getId()) continue;
                    return;
                }
                AdminModule.addServer(serverView.getId(), serverView.getServerRef().getHostname(), domainName, domain.getPort(), serverView.getServerName());
                logger.debug("New server added to the domain {0}: {1}", serverView);
            }
            catch (ConnectException e) {
                logger.error("Unable to add the server " + serverView, e);
                throw new JORAMServerException("Unable to add the server " + serverView, e);
            }
            catch (AdminException e) {
                logger.error("Unable to add the server " + serverView, e);
                throw new JORAMServerException("Unable to add the server " + serverView, e);
            }
        }
    }

    public static void removeServer(javax.jms.Topic topic, short sid) throws JORAMServerException {
        if (topic != null && topic instanceof Topic) {
            List fellows;
            Topic superTopic;
            try {
                superTopic = ((Topic)topic).getHierarchicalFather();
            }
            catch (ConnectException e) {
                logger.error("Unable to check the use of hierarchical topic", e);
                throw new JORAMServerException("Unable to check the use of hierarchical topic", e);
            }
            catch (AdminException e) {
                logger.error("Unable to check the use of hierarchical topic", e);
                throw new JORAMServerException("Unable to check the use of hierarchical topic", e);
            }
            if (superTopic != null) {
                try {
                    ((Topic)topic).unsetParent();
                }
                catch (ConnectException e) {
                    logger.error("Unable to unset the parent", e);
                    throw new JORAMServerException("Unable to unset the parent", e);
                }
                catch (AdminException e) {
                    logger.error("Unable to unset the parent", e);
                    throw new JORAMServerException("Unable to unset the parent", e);
                }
            }
            try {
                fellows = ((Topic)topic).getClusterFellows();
            }
            catch (ConnectException e) {
                logger.error("Unable to check the use of clustered topic", e);
                throw new JORAMServerException("Unable to check the use of clustered topic", e);
            }
            catch (AdminException e) {
                logger.error("Unable to check the use of clustered topic", e);
                throw new JORAMServerException("Unable to check the use of clustered topic", e);
            }
            if (fellows != null && !fellows.isEmpty()) {
                try {
                    ((Topic)topic).removeFromCluster();
                }
                catch (ConnectException e) {
                    logger.error("Unable to remove from the cluster", e);
                    throw new JORAMServerException("Unable to remove from the cluster", e);
                }
                catch (AdminException e) {
                    logger.error("Unable to remove from the cluster", e);
                    throw new JORAMServerException("Unable to remove from the cluster", e);
                }
            }
        }
        try {
            AdminModule.removeServer(sid);
        }
        catch (ConnectException e) {
            logger.error("Unable to remove the server " + sid, e);
            throw new JORAMServerException("Unable to remove the server " + sid, e);
        }
        catch (AdminException e) {
            logger.error("Unable to remove the server " + sid, e);
            throw new JORAMServerException("Unable to remove the server " + sid, e);
        }
    }

    public static void addDomain(Config config) throws JORAMServerException {
        if (config.getDomainPort() == null) {
            logger.error("Unable to add a domain without its domain name", new Object[0]);
            throw new JORAMServerException("Unable to add a domain without its domain name");
        }
        try {
            List<String> domains = Arrays.asList(AdminModule.getDomainNames(config.getServerId().shortValue()));
            logger.debug("Server {0} belongs to the domains {1}", config.getServerId(), domains);
            if (!domains.contains(config.getDomainName())) {
                AdminModule.addDomain(config.getDomainName(), config.getServerId().shortValue(), config.getDomainPort().shortValue());
                logger.debug("New domain added {0} to the server {1}", config.getDomainPort(), config.getServerId());
            }
        }
        catch (ConnectException e) {
            logger.error("Unable to add the domain " + config.getDomainName(), e);
            throw new JORAMServerException("Unable to add the domain " + config.getDomainName(), e);
        }
        catch (AdminException e) {
            logger.error("Unable to add the domain " + config.getDomainName(), e);
            throw new JORAMServerException("Unable to add the domain " + config.getDomainName(), e);
        }
    }
}

