/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.controller.server.impl.jms;

import fr.dyade.aaa.agent.AgentServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ConnectException;
import java.util.Arrays;
import javax.jms.ConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.admin.User;
import org.objectweb.joram.client.jms.local.LocalConnectionFactory;
import org.objectweb.joram.client.jms.tcp.TcpConnectionFactory;
import org.ow2.cmi.controller.server.impl.jms.Config;
import org.ow2.cmi.controller.server.impl.jms.JORAMServerException;

public final class JORAMServer {
    private static Log logger = LogFactory.getLog(JORAMServer.class);
    private final Config config;
    private User anonymousUser;
    private ConnectionFactory tcpCF;
    private ConnectionFactory localCF;

    public JORAMServer(Config config) {
        this.config = config;
    }

    public void start() throws JORAMServerException {
        if (this.config.getServerId() == null) {
            logger.error("Unable to start a JORAM server without server id");
            throw new JORAMServerException("Unable to start a JORAM server without server id");
        }
        Object[] args = new String[]{Short.toString(this.config.getServerId()), "./s" + this.config.getServerId()};
        try {
            AgentServer.main((String[])args);
        }
        catch (Exception e) {
            logger.error("Unable to start the JORAM server with the args " + Arrays.toString(args), e);
            throw new JORAMServerException("Unable to start the JORAM server with the args " + Arrays.toString(args), e);
        }
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("joramAdmin.xml");
        if (is != null) {
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader(is);
                AdminModule.executeAdmin(reader);
            }
            catch (Exception e) {
                logger.error("Unable to administrate the JORAM server", e);
                throw new JORAMServerException("Unable to administrate the JORAM server", e);
            }
            finally {
                try {
                    if (reader != null) {
                        ((Reader)reader).close();
                    }
                }
                catch (IOException e) {
                    logger.warn("Unable to close the reader of joramAdmin.xml", e);
                }
            }
        }
        try {
            AdminModule.collocatedConnect("root", "root");
        }
        catch (Exception e) {
            logger.error("Unable to connect to the JORAM server", e);
            throw new JORAMServerException("Unable to connect to the JORAM server", e);
        }
        try {
            this.tcpCF = TcpConnectionFactory.create(AdminModule.getLocalHost(), AdminModule.getLocalPort());
        }
        catch (ConnectException e) {
            logger.error("Unable to create a TCP connection factory", e);
            throw new JORAMServerException("Unable to create a TCP connection factory", e);
        }
        this.localCF = LocalConnectionFactory.create();
        try {
            this.anonymousUser = User.create("anonymous", "anonymous");
        }
        catch (ConnectException e) {
            logger.error("Unable to create the anonymous user", e);
            throw new JORAMServerException("Unable to create the anonymous user", e);
        }
        catch (AdminException e) {
            logger.error("Unable to create the anonymous user", e);
            throw new JORAMServerException("Unable to create the anonymous user", e);
        }
    }

    public void stop() {
        try {
            this.anonymousUser.delete();
        }
        catch (ConnectException e) {
            logger.warn("Unable to remove the anonymous user", e);
        }
        catch (AdminException e) {
            logger.warn("Unable to remove the anonymous user", e);
        }
        AgentServer.stop();
    }

    public ConnectionFactory getLocalConnectionFactory() {
        return this.localCF;
    }

    public ConnectionFactory getTcpConnectionFactory() {
        return this.tcpCF;
    }
}

