/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.wildcat;

import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.wildcat.Context;
import org.ow2.wildcat.ContextFactoryException;
import org.ow2.wildcat.event.WEvent;
import org.ow2.wildcat.event.WEventInterface;
import org.ow2.wildcat.hierarchy.BasicContext;
import org.ow2.wildcat.hierarchy.attribute.Attribute;
import org.ow2.wildcat.hierarchy.attribute.POJOAttribute;
import org.ow2.wildcat.hierarchy.resource.LocalResource;
import org.ow2.wildcat.hierarchy.resource.Resource;
import org.ow2.wildcat.remote.RemoteContext;
import org.ow2.wildcat.remote.dispatcher.DispatcherException;
import org.ow2.wildcat.remote.dispatcher.DispatcherFactory;
import org.ow2.wildcat.remote.dispatcher.IDispatcher;
import org.ow2.wildcat.remote.provider.JMSProvider;
import org.ow2.wildcat.remote.provider.joram.JORAMProvider;
import org.ow2.wildcat.util.Messages;

public final class ContextFactory {
    private static Log logger = LogFactory.getLog(ContextFactory.class);
    private static ContextFactory defaultFactory;
    private static Properties DEFAULTS;
    private static final String KEY_CONFIGURATION_FILE = "org.ow2.wildcat.configuration";
    public static final String KEY_LOG_MESSAGES = "org.ow2.wildcat.messages";
    public static final String KEY_CONTEXT_NAME = "org.ow2.wildcat.context_name";
    public static final String KEY_DISPATCHER_NAME = "org.ow2.wildcat.remote.dispatcher_name";
    public static final String KEY_QUEUE_CONNECTION_FACTORY = "org.ow2.wildcat.remote.queue_connection_factory";
    public static final String KEY_TOPIC_CONNECTION_FACTORY = "org.ow2.wildcat.remote.topic_connection_factory";
    public static final String DEFAULT_TOPIC_FACTORY_NAME = "JTCF";
    public static final String DEFAULT_QUEUE_FACTORY_NAME = "JQCF";
    public static final String KEY_JMS_PROVIDER = "org.ow2.wildcat.remote.jms_provider";
    public static final String DEFAULT_JMS_PROVIDER;
    public static final String KEY_CAROL_CONFIG_FILENAME = "org.ow2.wildcat.remote.carol.conf";
    public static final String KEY_CMI_CONFIG_FILENAME = "org.ow2.wildcat.remote.cmi.conf";
    private static final String DEFAULT_CMI_CONFIG_FILENAME = "cmi.properties";
    public static final String KEY_JMS_PROVIDER_URL = "org.ow2.wildcat.remote.jms_provider_url";
    public static final String KEY_JORAM_SERVER_ID = "org.ow2.wildcat.jms.provider.joram.id";
    public static final String KEY_JORAM_SERVER_PORT = "org.ow2.wildcat.jms.provider.joram.port";
    public static final String KEY_JORAM_SERVER_HOSTNAME = "org.ow2.wildcat.jms.provider.joram.hostname";
    public static final String KEY_PURE_JMS = "org.ow2.wildcat.remote.pure_jms";
    private static final String TOPIC_PREFIX = "topic_";
    private Properties properties = null;
    private JMSProvider delegate;

    public static ContextFactory getDefaultFactory() {
        if (defaultFactory == null) {
            ContextFactory.initDefaultProperties();
        }
        return defaultFactory;
    }

    public ContextFactory() {
        ContextFactory.initDefaultProperties();
        this.properties = new Properties();
        String path = null;
        try {
            path = System.getProperties().getProperty(KEY_CONFIGURATION_FILE, "/wildcat.properties");
            this.properties.load(ContextFactory.class.getResourceAsStream(path));
        }
        catch (Exception e) {
            logger.warn("No resource found @ " + path, e);
            this.properties = null;
        }
    }

    public ContextFactory(String configuration) {
        ContextFactory.initDefaultProperties();
        this.properties = new Properties();
        try {
            this.properties.load(ContextFactory.class.getResourceAsStream(configuration));
        }
        catch (Exception e) {
            logger.warn("No resource found @ " + configuration, e);
            this.properties = null;
        }
    }

    public ContextFactory(Properties properties) {
        ContextFactory.initDefaultProperties();
        this.properties = properties;
    }

    public ContextFactory(URL url) {
        ContextFactory.initDefaultProperties();
        this.properties = new Properties();
        try {
            this.properties.load(url.openStream());
        }
        catch (Exception e) {
            logger.warn("No resource found @ " + url, e);
            this.properties = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initDefaultProperties() {
        Class<ContextFactory> clazz = ContextFactory.class;
        synchronized (ContextFactory.class) {
            if (DEFAULTS == null) {
                DEFAULTS = new Properties();
                DEFAULTS.setProperty(KEY_CONTEXT_NAME, "context");
                DEFAULTS.setProperty(KEY_DISPATCHER_NAME, "dispatcher");
                DEFAULTS.setProperty(KEY_QUEUE_CONNECTION_FACTORY, DEFAULT_QUEUE_FACTORY_NAME);
                DEFAULTS.setProperty(KEY_TOPIC_CONNECTION_FACTORY, DEFAULT_TOPIC_FACTORY_NAME);
                DEFAULTS.setProperty(KEY_JMS_PROVIDER, DEFAULT_JMS_PROVIDER);
                DEFAULTS.setProperty(KEY_CMI_CONFIG_FILENAME, DEFAULT_CMI_CONFIG_FILENAME);
                DEFAULTS.setProperty(KEY_JORAM_SERVER_ID, "0");
                DEFAULTS.setProperty(KEY_JORAM_SERVER_HOSTNAME, "localhost");
                DEFAULTS.setProperty(KEY_JORAM_SERVER_PORT, "16010");
                DEFAULTS.setProperty(KEY_PURE_JMS, "false");
                Messages.init("/wildcat_messages_en.properties");
                defaultFactory = new ContextFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public String getProperty(String key) {
        if (this.properties != null && this.properties.containsKey(key)) {
            return this.properties.getProperty(key);
        }
        Properties sprops = System.getProperties();
        if (sprops.containsKey(key)) {
            return sprops.getProperty(key);
        }
        if (DEFAULTS.containsKey(key)) {
            return DEFAULTS.getProperty(key);
        }
        return null;
    }

    public Properties getProperties(String ... keys) {
        Properties results = new Properties();
        for (String k : keys) {
            results.setProperty(k, this.getProperty(k));
        }
        return results;
    }

    public Context createContext() {
        return new BasicContext(this, this.getProperty(KEY_CONTEXT_NAME));
    }

    public Context createContext(String name) {
        return new BasicContext(this, name);
    }

    public Resource createResource() {
        return new LocalResource();
    }

    public Attribute createAttribute(WEventInterface.Scope scope, Object value) {
        return new POJOAttribute(scope, value);
    }

    public void export(Context context) throws ContextFactoryException {
        try {
            DispatcherFactory.getDispatcher(this).export(context);
        }
        catch (Exception e) {
            logger.error("Unable to export the context with name " + context.getName(), e);
            throw new ContextFactoryException("Unable to export the context with name " + context.getName(), e);
        }
    }

    public void unexport(Context context) throws ContextFactoryException {
        try {
            DispatcherFactory.getDispatcher(this).unexport(context);
        }
        catch (Exception e) {
            logger.error("Unable to unexport the context with name " + context.getName(), e);
            throw new ContextFactoryException("Unable to unexport the context with name " + context.getName(), e);
        }
    }

    public RemoteContext lookup(String alias) throws ContextFactoryException {
        try {
            return DispatcherFactory.getDispatcher(this).lookup(alias);
        }
        catch (Exception e) {
            logger.error("Unable to get a remote context for " + alias, e);
            throw new ContextFactoryException("Unable to get a remote context for " + alias, e);
        }
    }

    public void notifyEvent(Context me, WEvent ... events) throws ContextFactoryException {
        try {
            DispatcherFactory.getDispatcher(this).notifyEvent(me, events);
        }
        catch (DispatcherException e) {
            logger.error("Unable to notify the remote contexts of events", e);
            throw new ContextFactoryException("Unable to notify the remote contexts of events", e);
        }
    }

    public boolean listen(Context me, String source) {
        try {
            return DispatcherFactory.getDispatcher(this).listen(me, source);
        }
        catch (DispatcherException e) {
            logger.debug("Unable to listen the remote context with name " + source, e);
            return false;
        }
    }

    public void doNotListen(Context me, String source) throws ContextFactoryException {
        try {
            DispatcherFactory.getDispatcher(this).doNotListen(me, source);
        }
        catch (DispatcherException e) {
            logger.error("Unable to not any more listen the remote context with name " + source, e);
            throw new ContextFactoryException("Unable to not any nore listen the remote context with name " + source, e);
        }
    }

    public boolean isEmbedded() {
        return this.getProperty(KEY_JMS_PROVIDER_URL) == null;
    }

    public IDispatcher getDispatcher() throws ContextFactoryException {
        try {
            return DispatcherFactory.getDispatcher(this);
        }
        catch (DispatcherException e) {
            logger.error("Unable to retrieve the dispatcher", e);
            throw new ContextFactoryException("Unable to retrieve the dispatcher", e);
        }
    }

    public JMSProvider getJMSProviderDelegate() {
        if (this.delegate == null) {
            String classname = this.getProperty(KEY_JMS_PROVIDER);
            try {
                this.delegate = (JMSProvider)this.getClass().getClassLoader().loadClass(classname).newInstance();
            }
            catch (Exception e) {
                logger.warn("Unable to load the JMS provider with class name " + classname, e);
            }
        }
        return this.delegate;
    }

    public boolean isRemoteContextAvailable(String context) {
        try {
            return DispatcherFactory.getDispatcher(this).isRemoteContextAvailable(context);
        }
        catch (DispatcherException e) {
            logger.warn("Unable to know if the remote context with name " + context + " is available", e);
            return false;
        }
    }

    public String computeTopicName(String context) {
        return this.computeTopicJNDIName(context);
    }

    public String computeTopicJNDIName(String context) {
        return TOPIC_PREFIX + context;
    }

    static {
        DEFAULT_JMS_PROVIDER = JORAMProvider.class.getName();
    }
}

