/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.wildcat.remote.dispatcher;

import java.net.URL;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.carol.util.configuration.ServerConfiguration;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.controller.factory.ClusterViewManagerFactory;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.wildcat.ContextFactory;
import org.ow2.wildcat.remote.dispatcher.DispatcherException;
import org.ow2.wildcat.remote.dispatcher.IDispatcher;
import org.ow2.wildcat.remote.dispatcher.jms.JMSDispatcher;
import org.ow2.wildcat.remote.dispatcher.rmi.RMIDispatcher;
import org.ow2.wildcat.remote.provider.JMSProvider;
import org.ow2.wildcat.remote.provider.JMSProviderException;

public final class DispatcherFactory {
    private static Log logger = LogFactory.getLog(DispatcherFactory.class);
    private static IDispatcher dispatcher;

    private DispatcherFactory() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IDispatcher getDispatcher(ContextFactory contextFactory) throws DispatcherException {
        if (dispatcher != null) return dispatcher;
        boolean useCmi = !Boolean.parseBoolean(contextFactory.getProperty("org.ow2.wildcat.remote.pure_jms"));
        boolean cmiStarted = false;
        System.setProperty("carol.server.mode", "true");
        String carolConfFilename = contextFactory.getProperty("org.ow2.wildcat.remote.carol.conf");
        try {
            if (carolConfFilename != null) {
                URL carolConfUrl = Thread.currentThread().getContextClassLoader().getResource(carolConfFilename);
                if (carolConfFilename == null) {
                    logger.error("Unable to find the Carol configuration file for name " + carolConfFilename, new Object[0]);
                    throw new DispatcherException("Unable to find the Carol configuration file for name " + carolConfFilename);
                }
                ConfigurationRepository.init(carolConfUrl);
            } else {
                ConfigurationRepository.init();
            }
        }
        catch (Exception e) {
            logger.error("Unable to init Carol!", e);
            throw new DispatcherException("Unable to init Carol!", e);
        }
        ServerConfiguration serverConfig = ConfigurationRepository.getServerConfiguration();
        JMSProvider delegate = contextFactory.getJMSProviderDelegate();
        if (delegate != null) {
            try {
                delegate.init(contextFactory);
            }
            catch (JMSProviderException e) {
                logger.error("Unable to init the JMS provider delegate", e);
                throw new DispatcherException("Unable to init the JMS provider delegate", e);
            }
        }
        ClusterViewManager clusterViewManager = null;
        if (useCmi && !serverConfig.isStartCMI()) {
            URL url = Thread.currentThread().getContextClassLoader().getResource(contextFactory.getProperty("org.ow2.wildcat.remote.cmi.conf"));
            try {
                if (!serverConfig.isStartCMI()) {
                    serverConfig.enableCMI(url);
                }
                cmiStarted = true;
                clusterViewManager = ClusterViewManagerFactory.getFactory().create();
                clusterViewManager.start();
            }
            catch (Exception e) {
                logger.info("Unable to configure CMI", e);
                useCmi = false;
            }
        } else if (useCmi) {
            clusterViewManager = ClusterViewManagerFactory.getFactory().getClusterViewManager();
        }
        if (useCmi && clusterViewManager != null && clusterViewManager.getState().equals((Object)ClusterViewManager.State.AVAILABLE)) {
            dispatcher = new RMIDispatcher(contextFactory);
            return dispatcher;
        }
        if (cmiStarted) {
            try {
                if (clusterViewManager != null && serverConfig.isStartCMI()) {
                    serverConfig.disableCMI();
                    clusterViewManager.destroy();
                }
            }
            catch (Exception e) {
                logger.debug("Error while disabling CMI", e);
            }
        }
        logger.info("Unable to use the RMI mode, using the pure JMS mode", new Object[0]);
        dispatcher = new JMSDispatcher(contextFactory);
        return dispatcher;
    }
}

