/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.wildcat.remote.dispatcher.jms;

import java.rmi.RemoteException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.wildcat.event.WEventInterface;
import org.ow2.wildcat.hierarchy.attribute.Attribute;
import org.ow2.wildcat.hierarchy.resource.Resource;
import org.ow2.wildcat.remote.RemoteContext;
import org.ow2.wildcat.remote.dispatcher.DispatcherException;
import org.ow2.wildcat.remote.dispatcher.jms.ContextOperation;
import org.ow2.wildcat.remote.dispatcher.jms.ContextOperationResult;
import org.ow2.wildcat.remote.dispatcher.jms.JMSDispatcher;
import org.ow2.wildcat.remote.dispatcher.jms.OperationType;
import org.ow2.wildcat.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSRemoteContext
implements RemoteContext {
    private static Log logger = LogFactory.getLog(JMSRemoteContext.class);
    private final JMSDispatcher dispatcher;
    private final String alias;

    public JMSRemoteContext(JMSDispatcher dispatcher, String alias) {
        this.dispatcher = dispatcher;
        this.alias = alias;
    }

    @Override
    public void attachAttribute(String attribute, Attribute attr) {
        logger.debug(Messages.message(JMSRemoteContext.class.getName() + ".onsr", new Object[0]));
    }

    @Override
    public void attachResource(String resource, Resource res) {
        logger.debug(Messages.message(JMSRemoteContext.class.getName() + ".onsr", new Object[0]));
    }

    @Override
    public void createAttribute(String attribute, WEventInterface.Scope scope, Object value) {
        ContextOperation co = new ContextOperation(this.alias, OperationType.CREATE_ATTRIBUTE, new Object[]{attribute, scope, value});
        try {
            this.dispatcher.doRemoteContextOperation(co);
        }
        catch (DispatcherException e) {
            logger.warn("Unable to create the attribute with name: " + attribute, e);
        }
    }

    @Override
    public Attribute getAttribute(String attribute) {
        logger.debug(Messages.message(JMSRemoteContext.class.getName() + ".onsr", new Object[0]));
        return null;
    }

    @Override
    public void createPeriodicAttributePoller(String attribute, long duration, TimeUnit unit, WEventInterface.Scope scope) {
        logger.debug(Messages.message(JMSRemoteContext.class.getName() + ".onsr", new Object[0]));
    }

    @Override
    public void createResource(String resource) {
        ContextOperation co = new ContextOperation(this.alias, OperationType.CREATE_RESOURCE, resource);
        try {
            this.dispatcher.doRemoteContextOperation(co);
        }
        catch (DispatcherException e) {
            logger.warn("Unable to create the resource with name: " + resource, e);
        }
    }

    @Override
    public void createSymlink(String link, String target) {
        ContextOperation co = new ContextOperation(this.alias, OperationType.CREATE_SYMLINK, link, target);
        try {
            this.dispatcher.doRemoteContextOperation(co);
        }
        catch (DispatcherException e) {
            logger.warn("Unable to create the link with name: " + link, e);
        }
    }

    @Override
    public String getName() {
        return this.alias;
    }

    @Override
    public Object getValue(String attribute) {
        ContextOperationResult cor;
        ContextOperation co = new ContextOperation(this.alias, OperationType.GET_VALUE, attribute);
        try {
            cor = this.dispatcher.doRemoteContextOperation(co);
        }
        catch (DispatcherException e) {
            logger.warn("Unable to get the value for attribute with name: " + attribute, e);
            return null;
        }
        return cor.getResult();
    }

    @Override
    public Set<String> list(String resource) {
        ContextOperationResult cor;
        ContextOperation co = new ContextOperation(this.alias, OperationType.LIST, resource);
        try {
            cor = this.dispatcher.doRemoteContextOperation(co);
        }
        catch (DispatcherException e) {
            logger.warn("Unable to get the set of attributes for resource with name: " + resource, e);
            return null;
        }
        return (Set)cor.getResult();
    }

    @Override
    public Object setValue(String attribute, Object value) {
        ContextOperationResult cor;
        ContextOperation co = new ContextOperation(this.alias, OperationType.SET_VALUE, attribute, value);
        try {
            cor = this.dispatcher.doRemoteContextOperation(co);
        }
        catch (DispatcherException e) {
            logger.warn("Unable to set the value of attribute with name: " + attribute, e);
            return null;
        }
        return cor.getResult();
    }

    public void export() {
        logger.debug(Messages.message(JMSRemoteContext.class.getName() + ".onsr", new Object[0]));
    }

    @Override
    public void detachAttribute(String attribute) {
        logger.debug(Messages.message(JMSRemoteContext.class.getName() + ".onsr", new Object[0]));
    }

    @Override
    public void detachResource(String resource) {
        logger.debug(Messages.message(JMSRemoteContext.class.getName() + ".onsr", new Object[0]));
    }

    @Override
    public void removePeriodicAttributePoller(String attribute) {
        logger.debug(Messages.message(JMSRemoteContext.class.getName() + ".onsr", new Object[0]));
    }

    @Override
    public Resource getResource(String resource) throws RemoteException {
        logger.debug(Messages.message(JMSRemoteContext.class.getName() + ".onsr", new Object[0]));
        return null;
    }
}

