/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.wildcat.sensors;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.ow2.wildcat.sensors.Sensor;
import org.ow2.wildcat.sensors.TextFileSensor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KernelVersionSensor
extends TextFileSensor
implements Sensor {
    private static final long serialVersionUID = -8499111079247453557L;
    private static final MessageFormat VERSION_NUMBER = new MessageFormat("Linux version {0,number,integer}.{1,number,integer}.{2,number,integer}");

    public KernelVersionSensor() {
        super("/proc/version");
    }

    @Override
    protected Map<String, Object> getValues(String[] lines) {
        HashMap<String, Object> samples = new HashMap<String, Object>();
        String version2 = lines[0];
        samples.put("uname", version2);
        try {
            Object[] numbers = (Object[])VERSION_NUMBER.parseObject(version2);
            assert (numbers != null && numbers.length == 3);
            assert (numbers[0] instanceof Integer && numbers[1] instanceof Integer && numbers[2] instanceof Integer);
            samples.put("major-version", numbers[0]);
            samples.put("minor-version", numbers[1]);
            samples.put("patch-level", numbers[2]);
            samples.put("version", numbers[0] + "." + numbers[1] + "." + numbers[2]);
        }
        catch (ParseException pe) {
            // empty catch block
        }
        return samples;
    }
}

