/**
 * WildCAT
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 EMN
 * Contact: wildcat@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: AttributeListener.java 330 2008-09-03 17:03:41Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.wildcat.osgi;

import java.util.HashMap;
import java.util.Map;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.ow2.wildcat.Context;
import org.ow2.wildcat.ContextException;
import org.ow2.wildcat.osgi.api.IAttributeAttacher;

/**
 * Listen for attaching and detaching WildCAT attributes.
 * @author Loris Bouzonnet
 */
public class AttributeListener implements ServiceListener {

	/**
	 * OSGi bundle context to retrieve the incoming {@link IAttributeAttacher}.
	 */
	private final BundleContext context;

	/**
	 * WildCAT Context.
	 */
	private final Context ctx;

	private Map<ServiceReference, String> paths = new HashMap<ServiceReference, String>();

	/**
	 * @param bundleContext
	 * @param ctx
	 */
	public AttributeListener(final BundleContext bundleContext, final Context ctx) {
		this.context = bundleContext;
		this.ctx = ctx;
	}

	/**
	 * @param event
	 */
	public void serviceChanged(final ServiceEvent event) {
		ServiceReference ref = event.getServiceReference();
		// React on REGISTERED|UNREGISTERING events
		switch(event.getType()) {
		case ServiceEvent.REGISTERED:
			IAttributeAttacher attacher = (IAttributeAttacher) context.getService(ref);
			try {
				ctx.attachAttribute(attacher.getPath(), attacher.getAttribute());
			} catch (ContextException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			paths.put(ref, attacher.getPath());
			break;
		case ServiceEvent.UNREGISTERING:
			try {
				ctx.detachAttribute(paths.remove(ref));
			} catch (ContextException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			break;
		}
	}

}
